/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.MEPortableCellContainer;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.contents.PortableCellViewer;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public class PortableCellItem
extends AEBasePoweredItem
implements IStorageCell<IAEItemStack>,
IGuiItem {
    private final StorageTier tier;

    public PortableCellItem(StorageTier tier, class_1792.class_1793 props) {
        super(AEConfig.instance().getPortableCellBattery(), props);
        this.tier = tier;
    }

    public class_1271<class_1799> method_7836(class_1937 w, class_1657 player, class_1268 hand) {
        ContainerOpener.openContainer(MEPortableCellContainer.TYPE, player, ContainerLocator.forHand(player, hand));
        return new class_1271(class_1269.field_5812, (Object)player.method_5998(hand));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 advancedTooltips) {
        super.method_7851(stack, world, lines, advancedTooltips);
        ICellInventoryHandler<IAEItemStack> cdi = Api.instance().registries().cell().getCellInventory(stack, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        Api.instance().client().addCellInformation(cdi, lines);
    }

    @Override
    public int getBytes(class_1799 cellItem) {
        return this.tier.getBytes();
    }

    @Override
    public int getBytesPerType(class_1799 cellItem) {
        return this.tier.getBytesPerType();
    }

    @Override
    public int getTotalTypes(class_1799 cellItem) {
        return this.tier.getTypes();
    }

    @Override
    public boolean isBlackListed(class_1799 cellItem, IAEItemStack requestedAddition) {
        return false;
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(class_1799 i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public boolean isEditable(class_1799 is) {
        return true;
    }

    @Override
    public FixedItemInv getUpgradesInventory(class_1799 is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public FixedItemInv getConfigInventory(class_1799 is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(class_1799 is) {
        String fz = is.method_7948().method_10558("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(class_1799 is, FuzzyMode fzMode) {
        is.method_7948().method_10582("FuzzyMode", fzMode.name());
    }

    @Override
    public IGuiItemObject getGuiObject(class_1799 is, int playerInventorySlot, class_1937 w, class_2338 pos) {
        return new PortableCellViewer(is, playerInventorySlot);
    }

    public static enum StorageTier {
        SIZE_1K(512, 54, 8),
        SIZE_4K(2048, 45, 32),
        SIZE_16K(8192, 36, 128),
        SIZE_64K(16834, 27, 512);

        private final int bytes;
        private final int types;
        private final int bytesPerType;

        private StorageTier(int bytes, int types, int bytesPerType) {
            this.bytes = bytes;
            this.types = types;
            this.bytesPerType = bytesPerType;
        }

        public int getBytes() {
            return this.bytes;
        }

        public int getTypes() {
            return this.types;
        }

        public int getBytesPerType() {
            return this.bytesPerType;
        }
    }
}

