/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered.powersink;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public abstract class AEBasePoweredItem
extends AEBaseItem
implements IAEItemPowerStorage {
    private static final String CURRENT_POWER_NBT_KEY = "internalCurrentPower";
    private static final String MAX_POWER_NBT_KEY = "internalMaxPower";
    private final DoubleSupplier powerCapacity;

    public AEBasePoweredItem(DoubleSupplier powerCapacity, class_1792.class_1793 props) {
        super(props);
        this.powerCapacity = powerCapacity;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 advancedTooltips) {
        class_2487 tag = stack.method_7969();
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getAEMaxPower(stack);
        if (tag != null) {
            internalCurrentPower = tag.method_10574(CURRENT_POWER_NBT_KEY);
        }
        double percent = internalCurrentPower / internalMaxPower;
        lines.add((class_2561)GuiText.StoredEnergy.text().method_27662().method_27693(':' + MessageFormat.format(" {0,number,#} ", internalCurrentPower)).method_10852((class_2561)new class_2588(PowerUnits.AE.unlocalizedName)).method_27693(" - " + MessageFormat.format(" {0,number,#.##%} ", percent)));
    }

    public boolean method_7846() {
        return true;
    }

    public void method_7850(class_1761 group, class_2371<class_1799> items) {
        super.method_7850(group, items);
        if (this.method_7877(group)) {
            class_1799 charged = new class_1799((class_1935)this, 1);
            class_2487 tag = charged.method_7948();
            tag.method_10549(CURRENT_POWER_NBT_KEY, this.getAEMaxPower(charged));
            tag.method_10549(MAX_POWER_NBT_KEY, this.getAEMaxPower(charged));
            items.add((Object)charged);
        }
    }

    @Override
    public double injectAEPower(class_1799 is, double amount, Actionable mode) {
        double maxStorage = this.getAEMaxPower(is);
        double currentStorage = this.getAECurrentPower(is);
        double required = maxStorage - currentStorage;
        double overflow = amount - required;
        if (mode == Actionable.MODULATE) {
            class_2487 data = is.method_7948();
            double toAdd = Math.min(amount, required);
            data.method_10549(CURRENT_POWER_NBT_KEY, currentStorage + toAdd);
        }
        return Math.max(0.0, overflow);
    }

    @Override
    public double extractAEPower(class_1799 is, double amount, Actionable mode) {
        double currentStorage = this.getAECurrentPower(is);
        double fulfillable = Math.min(amount, currentStorage);
        if (mode == Actionable.MODULATE) {
            class_2487 data = is.method_7948();
            data.method_10549(CURRENT_POWER_NBT_KEY, currentStorage - fulfillable);
        }
        return fulfillable;
    }

    @Override
    public double getAEMaxPower(class_1799 is) {
        return this.powerCapacity.getAsDouble();
    }

    @Override
    public double getAECurrentPower(class_1799 is) {
        class_2487 data = is.method_7948();
        return data.method_10574(CURRENT_POWER_NBT_KEY);
    }

    @Override
    public AccessRestriction getPowerFlow(class_1799 is) {
        return AccessRestriction.WRITE;
    }
}

