/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.me.cache.helpers.TickTracker;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.PriorityQueue;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;

public class TickManagerCache
implements ITickManager {
    private final HashMap<IGridNode, TickTracker> alertable = new HashMap();
    private final HashMap<IGridNode, TickTracker> sleeping = new HashMap();
    private final HashMap<IGridNode, TickTracker> awake = new HashMap();
    private final PriorityQueue<TickTracker> upcomingTicks = new PriorityQueue();
    private long currentTick = 0L;

    public TickManagerCache(IGrid g) {
    }

    public long getAvgNanoTime(IGridNode node) {
        TickTracker tt = this.awake.get(node);
        if (tt == null) {
            tt = this.sleeping.get(node);
        }
        if (tt == null) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public void onUpdateTick() {
        TickTracker tt = null;
        try {
            ++this.currentTick;
            while (!this.upcomingTicks.isEmpty() && (tt = this.upcomingTicks.peek()).getNextTick() <= this.currentTick) {
                this.upcomingTicks.poll();
                int diff = (int)(this.currentTick - tt.getLastTick());
                TickRateModulation mod = tt.getGridTickable().tickingRequest(tt.getNode(), diff);
                switch (mod) {
                    case FASTER: {
                        tt.setCurrentRate(tt.getCurrentRate() - 2);
                        break;
                    }
                    case IDLE: {
                        tt.setCurrentRate(tt.getRequest().maxTickRate);
                        break;
                    }
                    case SAME: {
                        break;
                    }
                    case SLEEP: {
                        this.sleepDevice(tt.getNode());
                        break;
                    }
                    case SLOWER: {
                        tt.setCurrentRate(tt.getCurrentRate() + 1);
                        break;
                    }
                    case URGENT: {
                        tt.setCurrentRate(0);
                        break;
                    }
                }
                if (!this.awake.containsKey(tt.getNode())) continue;
                this.addToQueue(tt);
            }
        }
        catch (Throwable t) {
            class_128 crashreport = class_128.method_560((Throwable)t, (String)"Ticking GridNode");
            class_129 section = crashreport.method_562(tt.getGridTickable().getClass().getSimpleName() + " being ticked.");
            tt.addEntityCrashInfo(section);
            throw new class_148(crashreport);
        }
    }

    private void addToQueue(TickTracker tt) {
        tt.setLastTick(this.currentTick);
        this.upcomingTicks.add(tt);
    }

    @Override
    public void removeNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof IGridTickable) {
            this.alertable.remove(gridNode);
            this.sleeping.remove(gridNode);
            this.awake.remove(gridNode);
        }
    }

    @Override
    public void addNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof IGridTickable) {
            IGridTickable tickable = (IGridTickable)((Object)machine);
            TickingRequest tr = tickable.getTickingRequest(gridNode);
            Preconditions.checkNotNull((Object)tr);
            TickTracker tt = new TickTracker(tr, gridNode, (IGridTickable)((Object)machine), this.currentTick);
            if (tr.canBeAlerted) {
                this.alertable.put(gridNode, tt);
            }
            if (tr.isSleeping) {
                this.sleeping.put(gridNode, tt);
            } else {
                this.awake.put(gridNode, tt);
                this.addToQueue(tt);
            }
        }
    }

    @Override
    public void onSplit(IGridStorage storageB) {
    }

    @Override
    public void onJoin(IGridStorage storageB) {
    }

    @Override
    public void populateGridStorage(IGridStorage storage) {
    }

    @Override
    public boolean alertDevice(IGridNode node) {
        Preconditions.checkNotNull((Object)node);
        TickTracker tt = this.alertable.get(node);
        if (tt == null) {
            return false;
        }
        this.sleeping.remove(node);
        this.awake.put(node, tt);
        tt.setLastTick(tt.getLastTick() - (long)tt.getRequest().maxTickRate);
        tt.setCurrentRate(tt.getRequest().minTickRate);
        this.upcomingTicks.remove(tt);
        this.upcomingTicks.add(tt);
        return true;
    }

    @Override
    public boolean sleepDevice(IGridNode node) {
        Preconditions.checkNotNull((Object)node);
        if (this.awake.containsKey(node)) {
            TickTracker gt = this.awake.get(node);
            this.awake.remove(node);
            this.sleeping.put(node, gt);
            return true;
        }
        return false;
    }

    @Override
    public boolean wakeDevice(IGridNode node) {
        Preconditions.checkNotNull((Object)node);
        if (this.sleeping.containsKey(node)) {
            TickTracker gt = this.sleeping.get(node);
            this.sleeping.remove(node);
            this.awake.put(node, gt);
            this.upcomingTicks.remove(gt);
            this.addToQueue(gt);
            return true;
        }
        return false;
    }
}

