/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache.helpers;

import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.util.DimensionalCoord;
import javax.annotation.Nonnull;
import net.minecraft.class_129;

public class TickTracker
implements Comparable<TickTracker> {
    private final TickingRequest request;
    private final IGridTickable gt;
    private final IGridNode node;
    private long lastTick;
    private int currentRate;

    public TickTracker(TickingRequest req, IGridNode node, IGridTickable gt, long currentTick) {
        this.request = req;
        this.gt = gt;
        this.node = node;
        this.setCurrentRate((req.minTickRate + req.maxTickRate) / 2);
        this.setLastTick(currentTick);
    }

    @Override
    public int compareTo(@Nonnull TickTracker t) {
        int next = Long.compare(this.getNextTick(), t.getNextTick());
        if (next != 0) {
            return next;
        }
        int last = Long.compare(this.getLastTick(), t.getLastTick());
        if (last != 0) {
            return last;
        }
        return Integer.compare(this.getCurrentRate(), t.getCurrentRate());
    }

    public void addEntityCrashInfo(class_129 section) {
        if (this.getGridTickable() instanceof IPart) {
            IPart part = (IPart)((Object)this.getGridTickable());
            part.addEntityCrashInfo(section);
        }
        section.method_578("CurrentTickRate", (Object)this.getCurrentRate());
        section.method_578("MinTickRate", (Object)this.getRequest().minTickRate);
        section.method_578("MaxTickRate", (Object)this.getRequest().maxTickRate);
        section.method_578("MachineType", (Object)this.getGridTickable().getClass().getName());
        section.method_578("GridBlockType", (Object)this.getNode().getGridBlock().getClass().getName());
        section.method_578("ConnectedSides", this.getNode().getConnectedSides());
        DimensionalCoord dc = this.getNode().getGridBlock().getLocation();
        if (dc != null) {
            section.method_578("Location", (Object)dc);
        }
    }

    public int getCurrentRate() {
        return this.currentRate;
    }

    public void setCurrentRate(int currentRate) {
        this.currentRate = Math.min(this.getRequest().maxTickRate, Math.max(this.getRequest().minTickRate, currentRate));
    }

    public long getNextTick() {
        return this.lastTick + (long)this.currentRate;
    }

    public long getLastTick() {
        return this.lastTick;
    }

    public void setLastTick(long lastTick) {
        this.lastTick = lastTick;
    }

    public IGridNode getNode() {
        return this.node;
    }

    public IGridTickable getGridTickable() {
        return this.gt;
    }

    public TickingRequest getRequest() {
        return this.request;
    }
}

