/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCraftingCpuChange;
import appeng.api.util.AEPartLocation;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.tile.crafting.CraftingBlockEntity;
import java.util.Iterator;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public class CraftingCPUCalculator
extends MBCalculator<CraftingBlockEntity, CraftingCPUCluster> {
    public CraftingCPUCalculator(CraftingBlockEntity t) {
        super(t);
    }

    @Override
    public boolean checkMultiblockScale(class_2338 min, class_2338 max) {
        if (max.method_10263() - min.method_10263() > 16) {
            return false;
        }
        if (max.method_10264() - min.method_10264() > 16) {
            return false;
        }
        return max.method_10260() - min.method_10260() <= 16;
    }

    @Override
    public CraftingCPUCluster createCluster(class_1937 w, class_2338 min, class_2338 max) {
        return new CraftingCPUCluster(min, max);
    }

    @Override
    public boolean verifyInternalStructure(class_1937 w, class_2338 min, class_2338 max) {
        boolean storage = false;
        for (class_2338 blockPos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            IAEMultiBlock te = (IAEMultiBlock)w.method_8321(blockPos);
            if (te == null || !te.isValid()) {
                return false;
            }
            if (storage || !(te instanceof CraftingBlockEntity)) continue;
            storage = ((CraftingBlockEntity)te).getStorageBytes() > 0;
        }
        return storage;
    }

    @Override
    public void updateTiles(CraftingCPUCluster c, class_1937 w, class_2338 min, class_2338 max) {
        for (class_2338 blockPos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            CraftingBlockEntity te = (CraftingBlockEntity)w.method_8321(blockPos);
            te.updateStatus(c);
            c.addTile(te);
        }
        c.done();
        Iterator<CraftingBlockEntity> i = c.getTiles();
        while (i.hasNext()) {
            IGrid g;
            IGridHost gh = i.next();
            IGridNode n = gh.getGridNode(AEPartLocation.INTERNAL);
            if (n == null || (g = n.getGrid()) == null) continue;
            g.postEvent(new MENetworkCraftingCpuChange(n));
            return;
        }
    }

    @Override
    public boolean isValidTile(class_2586 te) {
        return te instanceof CraftingBlockEntity;
    }
}

