/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.ICraftingHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingCpuChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.crafting.CraftBranchFailure;
import appeng.crafting.CraftingJob;
import appeng.crafting.CraftingLink;
import appeng.crafting.CraftingWatcher;
import appeng.crafting.MECraftingInventory;
import appeng.me.cache.CraftingGridCache;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.MBCalculator;
import appeng.me.helpers.MachineSource;
import appeng.tile.crafting.CraftingBlockEntity;
import appeng.tile.crafting.CraftingMonitorBlockEntity;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public final class CraftingCPUCluster
implements IAECluster,
ICraftingCPU {
    private static final String LOG_MARK_AS_COMPLETE = "Completed job for %s.";
    private final class_2338 boundsMin;
    private final class_2338 boundsMax;
    private final int[] usedOps = new int[3];
    private final Map<ICraftingPatternDetails, TaskProgress> tasks = new HashMap<ICraftingPatternDetails, TaskProgress>();
    private final List<CraftingBlockEntity> tiles = new ArrayList<CraftingBlockEntity>();
    private final List<CraftingBlockEntity> storage = new ArrayList<CraftingBlockEntity>();
    private final List<CraftingMonitorBlockEntity> status = new ArrayList<CraftingMonitorBlockEntity>();
    private final HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap();
    private ICraftingLink myLastLink;
    private class_2561 myName = null;
    private boolean isDestroyed = false;
    private MECraftingInventory inventory = new MECraftingInventory();
    private IAEItemStack finalOutput;
    private boolean waiting = false;
    private IItemList<IAEItemStack> waitingFor = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private long availableStorage = 0L;
    private MachineSource machineSrc = null;
    private int accelerator = 0;
    private boolean isComplete = true;
    private int remainingOperations;
    private boolean somethingChanged;
    private long lastTime;
    private long elapsedTime;
    private long startItemCount;
    private long remainingItemCount;

    public CraftingCPUCluster(class_2338 boundsMin, class_2338 boundsMax) {
        this.boundsMin = boundsMin.method_10062();
        this.boundsMax = boundsMax.method_10062();
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public ICraftingLink getLastCraftingLink() {
        return this.myLastLink;
    }

    @Override
    public class_2338 getBoundsMin() {
        return this.boundsMin;
    }

    @Override
    public class_2338 getBoundsMax() {
        return this.boundsMax;
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    public IMEInventory<IAEItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        for (CraftingBlockEntity r : this.tiles) {
            r.updateMeta(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        boolean ownsModification;
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        boolean bl = ownsModification = !MBCalculator.isModificationInProgress();
        if (ownsModification) {
            MBCalculator.setModificationInProgress(this);
        }
        try {
            boolean posted = false;
            for (CraftingBlockEntity r : this.tiles) {
                IGrid g;
                IGridNode n = r.getActionableNode();
                if (n != null && !posted && (g = n.getGrid()) != null) {
                    g.postEvent(new MENetworkCraftingCpuChange(n));
                    posted = true;
                }
                r.updateStatus(null);
            }
        }
        finally {
            if (ownsModification) {
                MBCalculator.setModificationInProgress(null);
            }
        }
    }

    public Iterator<CraftingBlockEntity> getTiles() {
        return this.tiles.iterator();
    }

    void addTile(CraftingBlockEntity te) {
        if (this.machineSrc == null || te.isCoreBlock()) {
            this.machineSrc = new MachineSource(te);
        }
        te.setCoreBlock(false);
        te.saveChanges();
        this.tiles.add(0, te);
        if (te.isStorage()) {
            this.availableStorage += (long)te.getStorageBytes();
            this.storage.add(te);
        } else if (te.isStatus()) {
            this.status.add((CraftingMonitorBlockEntity)te);
        } else if (te.isAccelerator()) {
            ++this.accelerator;
        }
    }

    public boolean canAccept(IAEItemStack input) {
        IAEItemStack is;
        return input instanceof IAEItemStack && (is = this.waitingFor.findPrecise(input)) != null && is.getStackSize() > 0L;
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
        if (!(input instanceof IAEItemStack)) {
            return input;
        }
        IAEItemStack what = input.copy();
        IAEItemStack is = this.waitingFor.findPrecise(what);
        if (type == Actionable.SIMULATE) {
            if (is != null && is.getStackSize() > 0L) {
                if (is.getStackSize() >= what.getStackSize()) {
                    if (this.finalOutput.equals(what)) {
                        if (this.myLastLink != null) {
                            return ((CraftingLink)this.myLastLink).injectItems(what.copy(), type);
                        }
                        return what;
                    }
                    return null;
                }
                IAEItemStack leftOver = what.copy();
                leftOver.decStackSize(is.getStackSize());
                IAEItemStack used = what.copy();
                used.setStackSize(is.getStackSize());
                if (this.finalOutput.equals(what)) {
                    if (this.myLastLink != null) {
                        leftOver.add(((CraftingLink)this.myLastLink).injectItems(used.copy(), type));
                        return leftOver;
                    }
                    return what;
                }
                return leftOver;
            }
        } else if (type == Actionable.MODULATE && is != null && is.getStackSize() > 0L) {
            this.waiting = false;
            this.postChange(what, src);
            if (is.getStackSize() >= what.getStackSize()) {
                is.decStackSize(what.getStackSize());
                this.updateElapsedTime(what);
                this.markDirty();
                this.postCraftingStatusChange((IAEItemStack)what.copy().setStackSize(-what.getStackSize()));
                if (this.finalOutput.equals(what)) {
                    IAEItemStack leftover = what;
                    this.finalOutput.decStackSize(what.getStackSize());
                    if (this.myLastLink != null) {
                        leftover = ((CraftingLink)this.myLastLink).injectItems(what, type);
                    }
                    if (this.finalOutput.getStackSize() <= 0L) {
                        this.completeJob();
                    }
                    this.updateCPU();
                    return leftover;
                }
                return this.inventory.injectItems(what, type, src);
            }
            IAEItemStack insert = what.copy();
            insert.setStackSize(is.getStackSize());
            what.decStackSize(is.getStackSize());
            is.setStackSize(0L);
            this.postCraftingStatusChange((IAEItemStack)insert.copy().setStackSize(-insert.getStackSize()));
            if (this.finalOutput.equals(insert)) {
                IAEItemStack leftover = input;
                this.finalOutput.decStackSize(insert.getStackSize());
                if (this.myLastLink != null) {
                    what.add(((CraftingLink)this.myLastLink).injectItems(insert.copy(), type));
                    leftover = what;
                }
                if (this.finalOutput.getStackSize() <= 0L) {
                    this.completeJob();
                }
                this.updateCPU();
                this.markDirty();
                return leftover;
            }
            this.inventory.injectItems(insert, type, src);
            this.markDirty();
            return what;
        }
        return input;
    }

    private void postChange(IAEItemStack diff, IActionSource src) {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.getListeners();
        if (i.hasNext()) {
            ImmutableList single = ImmutableList.of((Object)diff.copy());
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> o = i.next();
                IMEMonitorHandlerReceiver<IAEItemStack> receiver = o.getKey();
                if (receiver.isValid(o.getValue())) {
                    receiver.postChange(null, (Iterable<IAEItemStack>)single, src);
                    continue;
                }
                i.remove();
            }
        }
    }

    private void markDirty() {
        this.getCore().saveChanges();
    }

    private void postCraftingStatusChange(IAEItemStack diff) {
        Collection<CraftingWatcher> list;
        if (this.getGrid() == null) {
            return;
        }
        CraftingGridCache sg = (CraftingGridCache)this.getGrid().getCache(ICraftingGrid.class);
        if (sg.getInterestManager().containsKey(diff) && !(list = sg.getInterestManager().get(diff)).isEmpty()) {
            for (CraftingWatcher iw : list) {
                iw.getHost().onRequestChange(sg, diff);
            }
        }
    }

    private void completeJob() {
        if (this.myLastLink != null) {
            ((CraftingLink)this.myLastLink).markDone();
        }
        if (AELog.isCraftingLogEnabled()) {
            IAEItemStack logStack = this.finalOutput.copy();
            logStack.setStackSize(this.startItemCount);
            AELog.crafting(LOG_MARK_AS_COMPLETE, logStack);
        }
        this.remainingItemCount = 0L;
        this.startItemCount = 0L;
        this.lastTime = 0L;
        this.elapsedTime = 0L;
        this.isComplete = true;
    }

    private void updateCPU() {
        IAEItemStack send = this.finalOutput;
        if (this.finalOutput != null && this.finalOutput.getStackSize() <= 0L) {
            send = null;
        }
        for (CraftingMonitorBlockEntity t : this.status) {
            t.setJob(send);
        }
    }

    private Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> getListeners() {
        return this.listeners.entrySet().iterator();
    }

    private CraftingBlockEntity getCore() {
        if (this.machineSrc == null) {
            return null;
        }
        return (CraftingBlockEntity)this.machineSrc.machine().get();
    }

    private IGrid getGrid() {
        for (CraftingBlockEntity r : this.tiles) {
            IGrid g;
            IGridNode gn = r.getActionableNode();
            if (gn == null || (g = gn.getGrid()) == null) continue;
            return r.getActionableNode().getGrid();
        }
        return null;
    }

    private boolean canCraft(ICraftingPatternDetails details) {
        if (!details.isCraftable()) {
            for (IAEItemStack input : details.getInputs()) {
                IAEItemStack ais = this.inventory.extractItems(input.copy(), Actionable.SIMULATE, (IActionSource)this.machineSrc);
                if (ais != null && ais.getStackSize() >= input.getStackSize()) continue;
                return false;
            }
        } else if (details.canSubstitute()) {
            IAEItemStack[] sparseInputs = details.getSparseInputs();
            HashMap<IAEItemStack, Integer> consumedCount = new HashMap<IAEItemStack, Integer>();
            for (int i = 0; i < sparseInputs.length; ++i) {
                List<IAEItemStack> substitutes = details.getSubstituteInputs(i);
                if (substitutes.isEmpty()) continue;
                boolean found = false;
                for (IAEItemStack substitute : substitutes) {
                    for (IAEItemStack fuzz : this.inventory.getItemList().findFuzzy(substitute, FuzzyMode.IGNORE_ALL)) {
                        int alreadyConsumed = consumedCount.getOrDefault(fuzz, 0);
                        if (fuzz.getStackSize() - (long)alreadyConsumed <= 0L) continue;
                        fuzz = fuzz.copy();
                        fuzz.setStackSize(1L);
                        IAEItemStack ais = this.inventory.extractItems(fuzz, Actionable.SIMULATE, (IActionSource)this.machineSrc);
                        if (ais == null || ais.getStackSize() <= 0L) continue;
                        consumedCount.merge(fuzz, 1, Integer::sum);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                return false;
            }
        } else {
            for (IAEItemStack g : details.getInputs()) {
                boolean found = false;
                for (IAEItemStack fuzz : this.inventory.getItemList().findFuzzy(g, FuzzyMode.IGNORE_ALL)) {
                    fuzz = fuzz.copy();
                    fuzz.setStackSize(g.getStackSize());
                    IAEItemStack ais = this.inventory.extractItems(fuzz, Actionable.SIMULATE, (IActionSource)this.machineSrc);
                    if (ais != null && ais.getStackSize() >= g.getStackSize()) {
                        found = true;
                        break;
                    }
                    if (ais == null) continue;
                    g = g.copy();
                    g.decStackSize(ais.getStackSize());
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public void cancel() {
        if (this.myLastLink != null) {
            this.myLastLink.cancel();
        }
        IItemList<IAEItemStack> list = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        this.getListOfItem(list, CraftingItemList.ALL);
        for (IAEItemStack is : list) {
            this.postChange(is, this.machineSrc);
        }
        this.isComplete = true;
        this.myLastLink = null;
        this.tasks.clear();
        ArrayList items = new ArrayList(this.waitingFor.size());
        this.waitingFor.forEach(stack -> items.add(stack.copy().setStackSize(-stack.getStackSize())));
        this.waitingFor.resetStatus();
        for (IAEItemStack is : items) {
            this.postCraftingStatusChange(is);
        }
        this.finalOutput = null;
        this.updateCPU();
        this.storeItems();
    }

    public void updateCraftingLogic(IGrid grid, IEnergyGrid eg, CraftingGridCache cc) {
        if (!this.getCore().isActive()) {
            return;
        }
        if (this.myLastLink != null && this.myLastLink.isCanceled()) {
            this.myLastLink = null;
            this.cancel();
        }
        if (this.isComplete) {
            if (this.inventory.getItemList().isEmpty()) {
                return;
            }
            this.storeItems();
            return;
        }
        this.waiting = false;
        if (this.waiting || this.tasks.isEmpty()) {
            return;
        }
        int started = this.remainingOperations = this.accelerator + 1 - (this.usedOps[0] + this.usedOps[1] + this.usedOps[2]);
        if (this.remainingOperations > 0) {
            do {
                this.somethingChanged = false;
                this.executeCrafting(eg, cc);
            } while (this.somethingChanged && this.remainingOperations > 0);
        }
        this.usedOps[2] = this.usedOps[1];
        this.usedOps[1] = this.usedOps[0];
        this.usedOps[0] = started - this.remainingOperations;
        if (this.remainingOperations > 0 && !this.somethingChanged) {
            this.waiting = true;
        }
    }

    private void executeCrafting(IEnergyGrid eg, CraftingGridCache cc) {
        Iterator<Map.Entry<ICraftingPatternDetails, TaskProgress>> i = this.tasks.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<ICraftingPatternDetails, TaskProgress> e = i.next();
            if (e.getValue().value <= 0L) {
                i.remove();
                continue;
            }
            ICraftingPatternDetails details = e.getKey();
            if (!this.canCraft(details)) continue;
            class_1715 ic = null;
            for (ICraftingMedium m : cc.getMediums(e.getKey())) {
                if (e.getValue().value <= 0L || m.isBusy()) continue;
                if (ic == null) {
                    int x;
                    IAEItemStack[] input = details.getSparseInputs();
                    double sum = 0.0;
                    for (IAEItemStack anInput : input) {
                        if (anInput == null) continue;
                        sum += (double)anInput.getStackSize();
                    }
                    if (eg.extractAEPower(sum, Actionable.MODULATE, PowerMultiplier.CONFIG) < sum - 0.01) continue;
                    ic = new class_1715((class_1703)new ContainerNull(), 3, 3);
                    boolean found = false;
                    for (x = 0; x < input.length; ++x) {
                        if (input[x] == null) continue;
                        found = false;
                        if (details.isCraftable()) {
                            ArrayList<IAEItemStack> itemList;
                            if (details.canSubstitute()) {
                                List<IAEItemStack> substitutes = details.getSubstituteInputs(x);
                                itemList = new ArrayList(substitutes.size());
                                for (IAEItemStack stack : substitutes) {
                                    itemList.addAll(this.inventory.getItemList().findFuzzy(stack, FuzzyMode.IGNORE_ALL));
                                }
                            } else {
                                itemList = new ArrayList<IAEItemStack>(1);
                                IAEItemStack item = this.inventory.getItemList().findPrecise((IAEItemStack)input[x]);
                                if (item != null) {
                                    itemList.add(item);
                                }
                            }
                            for (IAEItemStack fuzz : itemList) {
                                IAEItemStack ais;
                                class_1799 is;
                                fuzz = fuzz.copy();
                                fuzz.setStackSize(input[x].getStackSize());
                                if (!details.isValidItemForSlot(x, fuzz.createItemStack(), this.getWorld()) || (is = (ais = this.inventory.extractItems(fuzz, Actionable.MODULATE, (IActionSource)this.machineSrc)) == null ? class_1799.field_8037 : ais.createItemStack()).method_7960()) continue;
                                this.postChange(AEItemStack.fromItemStack(is), this.machineSrc);
                                ic.method_5447(x, is);
                                found = true;
                                break;
                            }
                        } else {
                            class_1799 is;
                            IAEItemStack ais = this.inventory.extractItems(input[x].copy(), Actionable.MODULATE, (IActionSource)this.machineSrc);
                            class_1799 class_17992 = is = ais == null ? class_1799.field_8037 : ais.createItemStack();
                            if (!is.method_7960()) {
                                this.postChange((IAEItemStack)input[x], this.machineSrc);
                                ic.method_5447(x, is);
                                if ((long)is.method_7947() == input[x].getStackSize()) {
                                    found = true;
                                    continue;
                                }
                            }
                        }
                        if (!found) break;
                    }
                    if (!found) {
                        for (x = 0; x < ic.method_5439(); ++x) {
                            class_1799 is = ic.method_5438(x);
                            if (is.method_7960()) continue;
                            this.inventory.injectItems(AEItemStack.fromItemStack(is), Actionable.MODULATE, (IActionSource)this.machineSrc);
                        }
                        ic = null;
                        break;
                    }
                }
                if (!m.pushPattern(details, ic)) continue;
                this.somethingChanged = true;
                --this.remainingOperations;
                for (IAEItemStack out : details.getOutputs()) {
                    this.postChange(out, this.machineSrc);
                    this.waitingFor.add(out.copy());
                    this.postCraftingStatusChange(out.copy());
                }
                if (details.isCraftable()) {
                    for (int x = 0; x < ic.method_5439(); ++x) {
                        class_1799 output = Platform.getRecipeRemainder(ic.method_5438(x));
                        if (output.method_7960()) continue;
                        AEItemStack cItem = AEItemStack.fromItemStack(output);
                        this.postChange(cItem, this.machineSrc);
                        this.waitingFor.add(cItem);
                        this.postCraftingStatusChange(cItem);
                    }
                }
                ic = null;
                this.markDirty();
                e.getValue().value--;
                if (e.getValue().value <= 0L || this.remainingOperations != 0) continue;
                return;
            }
            if (ic == null) continue;
            for (int x = 0; x < ic.method_5439(); ++x) {
                class_1799 is = ic.method_5438(x);
                if (is.method_7960()) continue;
                this.inventory.injectItems(AEItemStack.fromItemStack(is), Actionable.MODULATE, (IActionSource)this.machineSrc);
            }
        }
    }

    private void storeItems() {
        IGrid g = this.getGrid();
        if (g == null) {
            return;
        }
        IStorageGrid sg = (IStorageGrid)g.getCache(IStorageGrid.class);
        IMEMonitor<IAEItemStack> ii = sg.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        for (IAEItemStack is : this.inventory.getItemList()) {
            if ((is = this.inventory.extractItems(is.copy(), Actionable.MODULATE, (IActionSource)this.machineSrc)) != null) {
                this.postChange(is, this.machineSrc);
                is = ii.injectItems(is, Actionable.MODULATE, this.machineSrc);
            }
            if (is == null) continue;
            this.inventory.injectItems(is, Actionable.MODULATE, (IActionSource)this.machineSrc);
        }
        if (this.inventory.getItemList().isEmpty()) {
            this.inventory = new MECraftingInventory();
        }
        this.markDirty();
    }

    public ICraftingLink submitJob(IGrid g, ICraftingJob job, IActionSource src, ICraftingRequester requestingMachine) {
        if (!this.tasks.isEmpty() || !this.waitingFor.isEmpty()) {
            return null;
        }
        if (!(job instanceof CraftingJob)) {
            return null;
        }
        if (this.isBusy() || !this.isActive() || this.availableStorage < job.getByteTotal()) {
            return null;
        }
        IStorageGrid sg = (IStorageGrid)g.getCache(IStorageGrid.class);
        IMEMonitor<IAEItemStack> storage = sg.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        MECraftingInventory ci = new MECraftingInventory(storage, true, false, false);
        try {
            this.waitingFor.resetStatus();
            ((CraftingJob)job).getTree().setJob(ci, this, src);
            if (ci.commit(src)) {
                this.finalOutput = job.getOutput();
                this.waiting = false;
                this.isComplete = false;
                this.markDirty();
                this.updateCPU();
                String craftID = this.generateCraftingID();
                this.myLastLink = new CraftingLink(this.generateLinkData(craftID, requestingMachine == null, false), this);
                this.prepareElapsedTime();
                if (requestingMachine == null) {
                    return this.myLastLink;
                }
                CraftingLink whatLink = new CraftingLink(this.generateLinkData(craftID, false, true), requestingMachine);
                this.submitLink(this.myLastLink);
                this.submitLink(whatLink);
                IItemList<IAEItemStack> list = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
                this.getListOfItem(list, CraftingItemList.ALL);
                for (IAEItemStack ge : list) {
                    this.postChange(ge, this.machineSrc);
                }
                return whatLink;
            }
            this.tasks.clear();
            this.inventory.getItemList().resetStatus();
        }
        catch (CraftBranchFailure e) {
            this.tasks.clear();
            this.inventory.getItemList().resetStatus();
        }
        return null;
    }

    @Override
    public boolean isBusy() {
        Iterator<Map.Entry<ICraftingPatternDetails, TaskProgress>> i = this.tasks.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().getValue().value > 0L) continue;
            i.remove();
        }
        return !this.tasks.isEmpty() || !this.waitingFor.isEmpty();
    }

    @Override
    public IActionSource getActionSource() {
        return this.machineSrc;
    }

    @Override
    public long getAvailableStorage() {
        return this.availableStorage;
    }

    @Override
    public int getCoProcessors() {
        return this.accelerator;
    }

    @Override
    public class_2561 getName() {
        return this.myName;
    }

    public boolean isActive() {
        CraftingBlockEntity core = this.getCore();
        if (core == null) {
            return false;
        }
        IGridNode node = core.getActionableNode();
        if (node == null) {
            return false;
        }
        return node.isActive();
    }

    private String generateCraftingID() {
        long now = System.currentTimeMillis();
        int hash = System.identityHashCode(this);
        int hmm = this.finalOutput == null ? 0 : this.finalOutput.hashCode();
        return Long.toString(now, 36) + '-' + Integer.toString(hash, 36) + '-' + Integer.toString(hmm, 36);
    }

    private class_2487 generateLinkData(String craftingID, boolean standalone, boolean req) {
        class_2487 tag = new class_2487();
        tag.method_10582("CraftID", craftingID);
        tag.method_10556("canceled", false);
        tag.method_10556("done", false);
        tag.method_10556("standalone", standalone);
        tag.method_10556("req", req);
        return tag;
    }

    private void submitLink(ICraftingLink myLastLink2) {
        if (this.getGrid() != null) {
            CraftingGridCache cc = (CraftingGridCache)this.getGrid().getCache(ICraftingGrid.class);
            cc.addLink((CraftingLink)myLastLink2);
        }
    }

    public void getListOfItem(IItemList<IAEItemStack> list, CraftingItemList whichList) {
        switch (whichList) {
            case ACTIVE: {
                for (IAEItemStack iAEItemStack : this.waitingFor) {
                    list.add(iAEItemStack);
                }
                break;
            }
            case PENDING: {
                for (Map.Entry<ICraftingPatternDetails, TaskProgress> entry : this.tasks.entrySet()) {
                    for (IAEItemStack ais : entry.getKey().getOutputs()) {
                        ais = ais.copy();
                        ais.setStackSize(ais.getStackSize() * entry.getValue().value);
                        list.add(ais);
                    }
                }
                break;
            }
            case STORAGE: {
                this.inventory.getAvailableItems(list);
                break;
            }
            default: {
                this.inventory.getAvailableItems(list);
                for (IAEItemStack iAEItemStack : this.waitingFor) {
                    list.add(iAEItemStack);
                }
                for (Map.Entry entry : this.tasks.entrySet()) {
                    for (IAEItemStack ais : ((ICraftingPatternDetails)entry.getKey()).getOutputs()) {
                        ais = ais.copy();
                        ais.setStackSize(ais.getStackSize() * ((TaskProgress)entry.getValue()).value);
                        list.add(ais);
                    }
                }
            }
        }
    }

    public void addStorage(IAEItemStack extractItems) {
        this.inventory.injectItems(extractItems, Actionable.MODULATE, (IActionSource)null);
    }

    public void addEmitable(IAEItemStack i) {
        this.waitingFor.add(i);
        this.postCraftingStatusChange(i);
    }

    public void addCrafting(ICraftingPatternDetails details, long crafts) {
        TaskProgress i = this.tasks.get(details);
        if (i == null) {
            i = new TaskProgress();
            this.tasks.put(details, i);
        }
        TaskProgress taskProgress = i;
        taskProgress.value = taskProgress.value + crafts;
    }

    public IAEItemStack getItemStack(IAEItemStack what, CraftingItemList storage2) {
        IAEItemStack is;
        switch (storage2) {
            case STORAGE: {
                is = this.inventory.getItemList().findPrecise(what);
                break;
            }
            case ACTIVE: {
                is = this.waitingFor.findPrecise(what);
                break;
            }
            case PENDING: {
                is = what.copy();
                is.setStackSize(0L);
                for (Map.Entry<ICraftingPatternDetails, TaskProgress> t : this.tasks.entrySet()) {
                    for (IAEItemStack ais : t.getKey().getOutputs()) {
                        if (!ais.equals(is)) continue;
                        is.setStackSize(is.getStackSize() + ais.getStackSize() * t.getValue().value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Operation");
            }
        }
        if (is != null) {
            return is.copy();
        }
        is = what.copy();
        is.setStackSize(0L);
        return is;
    }

    public void writeToNBT(class_2487 data) {
        data.method_10566("finalOutput", (class_2520)this.writeItem(this.finalOutput));
        data.method_10566("inventory", (class_2520)this.writeList(this.inventory.getItemList()));
        data.method_10556("waiting", this.waiting);
        data.method_10556("isComplete", this.isComplete);
        if (this.myLastLink != null) {
            class_2487 link = new class_2487();
            this.myLastLink.writeToNBT(link);
            data.method_10566("link", (class_2520)link);
        }
        class_2499 list = new class_2499();
        for (Map.Entry<ICraftingPatternDetails, TaskProgress> e : this.tasks.entrySet()) {
            class_2487 item = this.writeItem(AEItemStack.fromItemStack(e.getKey().getPattern()));
            item.method_10544("craftingProgress", e.getValue().value);
            list.add((Object)item);
        }
        data.method_10566("tasks", (class_2520)list);
        data.method_10566("waitingFor", (class_2520)this.writeList(this.waitingFor));
        data.method_10544("elapsedTime", this.getElapsedTime());
        data.method_10544("startItemCount", this.getStartItemCount());
        data.method_10544("remainingItemCount", this.getRemainingItemCount());
    }

    private class_2487 writeItem(IAEItemStack finalOutput2) {
        class_2487 out = new class_2487();
        if (finalOutput2 != null) {
            finalOutput2.writeToNBT(out);
        }
        return out;
    }

    private class_2499 writeList(IItemList<IAEItemStack> myList) {
        class_2499 out = new class_2499();
        for (IAEItemStack ais : myList) {
            out.add((Object)this.writeItem(ais));
        }
        return out;
    }

    void done() {
        CraftingBlockEntity core = this.getCore();
        core.setCoreBlock(true);
        if (core.getPreviousState() != null) {
            this.readFromNBT(core.getPreviousState());
            core.setPreviousState(null);
        }
        this.updateCPU();
        this.updateName();
    }

    public void readFromNBT(class_2487 data) {
        this.finalOutput = AEItemStack.fromNBT(data.method_10562("finalOutput"));
        for (IAEItemStack ais : this.readList(data.method_10554("inventory", 10))) {
            this.inventory.injectItems(ais, Actionable.MODULATE, (IActionSource)this.machineSrc);
        }
        this.waiting = data.method_10577("waiting");
        this.isComplete = data.method_10577("isComplete");
        if (data.method_10545("link")) {
            class_2487 link = data.method_10562("link");
            this.myLastLink = new CraftingLink(link, this);
            this.submitLink(this.myLastLink);
        }
        class_2499 list = data.method_10554("tasks", 10);
        for (int x = 0; x < list.size(); ++x) {
            ICraftingPatternDetails details;
            class_2487 item = list.method_10602(x);
            IAEItemStack pattern = AEItemStack.fromNBT(item);
            ICraftingHelper craftingHelper = Api.instance().crafting();
            if (!craftingHelper.isEncodedPattern(pattern) || (details = craftingHelper.decodePattern(pattern.createItemStack(), this.getWorld())) == null) continue;
            TaskProgress tp = new TaskProgress();
            tp.value = item.method_10537("craftingProgress");
            this.tasks.put(details, tp);
        }
        this.waitingFor = this.readList(data.method_10554("waitingFor", 10));
        for (IAEItemStack is : this.waitingFor) {
            this.postCraftingStatusChange(is.copy());
        }
        this.lastTime = System.nanoTime();
        this.elapsedTime = data.method_10537("elapsedTime");
        this.startItemCount = data.method_10537("startItemCount");
        this.remainingItemCount = data.method_10537("remainingItemCount");
    }

    public void updateName() {
        this.myName = null;
        for (CraftingBlockEntity te : this.tiles) {
            if (!te.hasCustomInventoryName()) continue;
            if (this.myName != null) {
                this.myName = this.myName.method_27662().method_27693(" ").method_10852(te.getCustomInventoryName());
                continue;
            }
            this.myName = te.getCustomInventoryName();
        }
    }

    private IItemList<IAEItemStack> readList(class_2499 tag) {
        IItemList<IAEItemStack> out = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        if (tag == null) {
            return out;
        }
        for (int x = 0; x < tag.size(); ++x) {
            IAEItemStack ais = AEItemStack.fromNBT(tag.method_10602(x));
            if (ais == null) continue;
            out.add(ais);
        }
        return out;
    }

    private class_1937 getWorld() {
        return this.getCore().method_10997();
    }

    public IAEItemStack making(IAEItemStack what) {
        return this.waitingFor.findPrecise(what);
    }

    public void breakCluster() {
        CraftingBlockEntity t = this.getCore();
        if (t != null) {
            t.breakCluster();
        }
    }

    private void prepareElapsedTime() {
        this.lastTime = System.nanoTime();
        this.elapsedTime = 0L;
        IItemList<IAEItemStack> list = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        this.getListOfItem(list, CraftingItemList.ACTIVE);
        this.getListOfItem(list, CraftingItemList.PENDING);
        int itemCount = 0;
        for (IAEItemStack ge : list) {
            itemCount = (int)((long)itemCount + ge.getStackSize());
        }
        this.startItemCount = itemCount;
        this.remainingItemCount = itemCount;
    }

    private void updateElapsedTime(IAEItemStack is) {
        long nextStartTime = System.nanoTime();
        this.elapsedTime = this.getElapsedTime() + nextStartTime - this.lastTime;
        this.lastTime = nextStartTime;
        this.remainingItemCount = this.getRemainingItemCount() - is.getStackSize();
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long getRemainingItemCount() {
        return this.remainingItemCount;
    }

    public long getStartItemCount() {
        return this.startItemCount;
    }

    private static class TaskProgress {
        private long value;

        private TaskProgress() {
        }
    }
}

