/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.events.LocatableEventAnnounce;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.features.ILocatable;
import appeng.api.networking.IGridNode;
import appeng.api.util.AEPartLocation;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.me.cache.helpers.ConnectionWrapper;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.MBCalculator;
import appeng.tile.qnb.QuantumBridgeBlockEntity;
import appeng.util.iterators.ChainedIterator;
import java.util.Iterator;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public class QuantumCluster
implements ILocatable,
IAECluster {
    private final class_2338 boundsMin;
    private final class_2338 boundsMax;
    private boolean isDestroyed = false;
    private boolean updateStatus = true;
    private QuantumBridgeBlockEntity[] Ring;
    private boolean registered = false;
    private ConnectionWrapper connection;
    private long thisSide;
    private long otherSide;
    private QuantumBridgeBlockEntity center;

    public QuantumCluster(class_2338 min, class_2338 max) {
        this.boundsMin = min.method_10062();
        this.boundsMax = max.method_10062();
        this.setRing(new QuantumBridgeBlockEntity[8]);
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        long qe = this.center.getQEFrequency();
        if (this.thisSide != qe && this.thisSide != -qe) {
            if (qe != 0L) {
                if (this.thisSide != 0L) {
                    ((LocatableEventAnnounce)LocatableEventAnnounce.EVENT.invoker()).onLocatableAnnounce(this, LocatableEventAnnounce.LocatableEvent.UNREGISTER);
                }
                if (this.canUseNode(-qe)) {
                    this.otherSide = qe;
                    this.thisSide = -qe;
                } else if (this.canUseNode(qe)) {
                    this.thisSide = qe;
                    this.otherSide = -qe;
                }
                ((LocatableEventAnnounce)LocatableEventAnnounce.EVENT.invoker()).onLocatableAnnounce(this, LocatableEventAnnounce.LocatableEvent.REGISTER);
            } else {
                ((LocatableEventAnnounce)LocatableEventAnnounce.EVENT.invoker()).onLocatableAnnounce(this, LocatableEventAnnounce.LocatableEvent.UNREGISTER);
                this.otherSide = 0L;
                this.thisSide = 0L;
            }
        }
        ILocatable myOtherSide = this.otherSide == 0L ? null : Api.instance().registries().locatable().getLocatableBy(this.otherSide);
        boolean shutdown = false;
        if (myOtherSide instanceof QuantumCluster) {
            QuantumCluster sideA = this;
            QuantumCluster sideB = (QuantumCluster)myOtherSide;
            if (sideA.isActive() && sideB.isActive()) {
                if (this.connection != null && this.connection.getConnection() != null) {
                    IGridNode a = this.connection.getConnection().a();
                    IGridNode b = this.connection.getConnection().b();
                    IGridNode sa = sideA.getNode();
                    IGridNode sb = sideB.getNode();
                    if (!(a != sa && b != sa || a != sb && b != sb)) {
                        return;
                    }
                }
                try {
                    if (sideA.connection != null && sideA.connection.getConnection() != null) {
                        sideA.connection.getConnection().destroy();
                        sideA.connection = new ConnectionWrapper(null);
                    }
                    if (sideB.connection != null && sideB.connection.getConnection() != null) {
                        sideB.connection.getConnection().destroy();
                        sideB.connection = new ConnectionWrapper(null);
                    }
                    sideA.connection = sideB.connection = new ConnectionWrapper(Api.instance().grid().createGridConnection(sideA.getNode(), sideB.getNode()));
                }
                catch (FailedConnectionException e) {
                    AELog.debug(e);
                }
            } else {
                shutdown = true;
            }
        } else {
            shutdown = true;
        }
        if (shutdown && this.connection != null && this.connection.getConnection() != null) {
            this.connection.getConnection().destroy();
            this.connection.setConnection(null);
            this.connection = new ConnectionWrapper(null);
        }
    }

    private boolean canUseNode(long qe) {
        QuantumCluster qc = (QuantumCluster)Api.instance().registries().locatable().getLocatableBy(qe);
        if (qc != null) {
            class_1937 theWorld = qc.center.method_10997();
            if (!qc.isDestroyed) {
                if (theWorld.method_22340(qc.center.method_11016())) {
                    class_3218 cur = theWorld.method_8503().method_3847(theWorld.method_27983());
                    class_2586 te = theWorld.method_8321(qc.center.method_11016());
                    return te != qc.center || theWorld != cur;
                }
                AELog.warn("Found a registered QNB with serial %s whose chunk seems to be unloaded: %s", qe, qc);
            }
        }
        return true;
    }

    private boolean isActive() {
        if (this.isDestroyed || !this.registered) {
            return false;
        }
        return this.center.isPowered() && this.hasQES();
    }

    private IGridNode getNode() {
        return this.center.getGridNode(AEPartLocation.INTERNAL);
    }

    private boolean hasQES() {
        return this.thisSide != 0L;
    }

    @Override
    public class_2338 getBoundsMin() {
        return this.boundsMin;
    }

    @Override
    public class_2338 getBoundsMax() {
        return this.boundsMax;
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        MBCalculator.setModificationInProgress(this);
        try {
            if (this.registered) {
                this.registered = false;
            }
            if (this.thisSide != 0L) {
                this.updateStatus(true);
                ((LocatableEventAnnounce)LocatableEventAnnounce.EVENT.invoker()).onLocatableAnnounce(this, LocatableEventAnnounce.LocatableEvent.UNREGISTER);
            }
            this.center.updateStatus(null, (byte)-1, this.isUpdateStatus());
            for (QuantumBridgeBlockEntity r : this.getRing()) {
                r.updateStatus(null, (byte)-1, this.isUpdateStatus());
            }
            this.center = null;
            this.setRing(new QuantumBridgeBlockEntity[8]);
        }
        finally {
            MBCalculator.setModificationInProgress(null);
        }
    }

    public Iterator<QuantumBridgeBlockEntity> getTiles() {
        return new ChainedIterator<QuantumBridgeBlockEntity>(this.getRing()[0], this.getRing()[1], this.getRing()[2], this.getRing()[3], this.getRing()[4], this.getRing()[5], this.getRing()[6], this.getRing()[7], this.center);
    }

    public boolean isCorner(QuantumBridgeBlockEntity tileQuantumBridge) {
        return this.getRing()[0] == tileQuantumBridge || this.getRing()[2] == tileQuantumBridge || this.getRing()[4] == tileQuantumBridge || this.getRing()[6] == tileQuantumBridge;
    }

    @Override
    public long getLocatableSerial() {
        return this.thisSide;
    }

    public QuantumBridgeBlockEntity getCenter() {
        return this.center;
    }

    void setCenter(QuantumBridgeBlockEntity c) {
        this.registered = true;
        this.center = c;
    }

    private boolean isUpdateStatus() {
        return this.updateStatus;
    }

    public void setUpdateStatus(boolean updateStatus) {
        this.updateStatus = updateStatus;
    }

    QuantumBridgeBlockEntity[] getRing() {
        return this.Ring;
    }

    private void setRing(QuantumBridgeBlockEntity[] ring) {
        this.Ring = ring;
    }

    public String toString() {
        if (this.center == null) {
            return "QuantumCluster{no-center}";
        }
        class_1937 world = this.center.method_10997();
        class_2338 pos = this.center.method_11016();
        return "QuantumCluster{" + world + "," + pos + "}";
    }
}

