/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.helpers;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkPowerIdleChange;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IOrientable;
import appeng.core.Api;
import appeng.core.worlddata.WorldData;
import appeng.hooks.TickHandler;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.me.helpers.IGridProxyable;
import appeng.parts.networking.CablePart;
import appeng.tile.AEBaseBlockEntity;
import appeng.util.Platform;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;

public class AENetworkProxy
implements IGridBlock {
    private final IGridProxyable gp;
    private final boolean worldNode;
    private final String nbtName;
    private AEColor myColor = AEColor.TRANSPARENT;
    private class_2487 data = null;
    private class_1799 myRepInstance = class_1799.field_8037;
    private boolean isReady = false;
    private IGridNode node = null;
    private EnumSet<class_2350> validSides;
    private EnumSet<GridFlags> flags = EnumSet.noneOf(GridFlags.class);
    private double idleDraw = 1.0;
    private class_1657 owner;

    public AENetworkProxy(IGridProxyable te, String nbtName, class_1799 visual, boolean inWorld) {
        this.gp = te;
        this.nbtName = nbtName;
        this.worldNode = inWorld;
        this.myRepInstance = visual;
        this.validSides = EnumSet.allOf(class_2350.class);
    }

    public void setVisualRepresentation(class_1799 is) {
        this.myRepInstance = is;
    }

    public void writeToNBT(class_2487 tag) {
        if (this.node != null) {
            this.node.saveToNBT(this.nbtName, tag);
        }
    }

    public void setValidSides(EnumSet<class_2350> validSides) {
        this.validSides = validSides;
        if (this.node != null) {
            this.node.updateState();
        }
    }

    public void validate() {
        if (this.gp instanceof AEBaseBlockEntity) {
            TickHandler.instance().addInit((AEBaseBlockEntity)((Object)this.gp));
        }
    }

    public void onChunkUnloaded() {
        this.isReady = false;
        this.remove();
    }

    public void remove() {
        this.isReady = false;
        if (this.node != null) {
            this.node.destroy();
            this.node = null;
        }
    }

    public void onReady() {
        IOrientable ori;
        this.isReady = true;
        if (this.gp instanceof IOrientable && (ori = (IOrientable)((Object)this.gp)).canBeRotated()) {
            ori.setOrientation(ori.getForward(), ori.getUp());
        }
        this.getNode();
    }

    public IGridNode getNode() {
        if (this.node == null && Platform.isServer() && this.isReady) {
            this.node = Api.instance().grid().createGridNode(this);
            this.readFromNBT(this.data);
            this.node.updateState();
        }
        return this.node;
    }

    public void readFromNBT(class_2487 tag) {
        this.data = tag;
        if (this.node != null && this.data != null) {
            this.node.loadFromNBT(this.nbtName, this.data);
            this.data = null;
        } else if (this.node != null && this.owner != null) {
            GameProfile profile = this.owner.method_7334();
            int playerID = WorldData.instance().playerData().getMePlayerId(profile);
            this.node.setPlayerID(playerID);
            this.owner = null;
        }
    }

    public IPathingGrid getPath() throws GridAccessException {
        IGrid grid = this.getGrid();
        if (grid == null) {
            throw new GridAccessException();
        }
        IPathingGrid pg = (IPathingGrid)grid.getCache(IPathingGrid.class);
        if (pg == null) {
            throw new GridAccessException();
        }
        return pg;
    }

    public IGrid getGrid() throws GridAccessException {
        if (this.node == null) {
            throw new GridAccessException();
        }
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            throw new GridAccessException();
        }
        return grid;
    }

    public ITickManager getTick() throws GridAccessException {
        IGrid grid = this.getGrid();
        if (grid == null) {
            throw new GridAccessException();
        }
        ITickManager pg = (ITickManager)grid.getCache(ITickManager.class);
        if (pg == null) {
            throw new GridAccessException();
        }
        return pg;
    }

    public IStorageGrid getStorage() throws GridAccessException {
        IGrid grid = this.getGrid();
        if (grid == null) {
            throw new GridAccessException();
        }
        IStorageGrid pg = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (pg == null) {
            throw new GridAccessException();
        }
        return pg;
    }

    public P2PCache getP2P() throws GridAccessException {
        IGrid grid = this.getGrid();
        if (grid == null) {
            throw new GridAccessException();
        }
        P2PCache pg = (P2PCache)grid.getCache(P2PCache.class);
        if (pg == null) {
            throw new GridAccessException();
        }
        return pg;
    }

    public ISecurityGrid getSecurity() throws GridAccessException {
        IGrid grid = this.getGrid();
        if (grid == null) {
            throw new GridAccessException();
        }
        ISecurityGrid sg = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        if (sg == null) {
            throw new GridAccessException();
        }
        return sg;
    }

    public ICraftingGrid getCrafting() throws GridAccessException {
        IGrid grid = this.getGrid();
        if (grid == null) {
            throw new GridAccessException();
        }
        ICraftingGrid sg = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        if (sg == null) {
            throw new GridAccessException();
        }
        return sg;
    }

    @Override
    public double getIdlePowerUsage() {
        return this.idleDraw;
    }

    @Override
    public EnumSet<GridFlags> getFlags() {
        return this.flags;
    }

    @Override
    public boolean isWorldAccessible() {
        return this.worldNode;
    }

    @Override
    public DimensionalCoord getLocation() {
        return this.gp.getLocation();
    }

    @Override
    public AEColor getGridColor() {
        return this.getColor();
    }

    @Override
    public void onGridNotification(GridNotification notification) {
        if (notification == GridNotification.OWNER_CHANGED) {
            this.gp.saveChanges();
            return;
        }
        if (this.gp instanceof CablePart) {
            ((CablePart)this.gp).markForUpdate();
        }
    }

    @Override
    public EnumSet<class_2350> getConnectableSides() {
        return this.validSides;
    }

    @Override
    public IGridHost getMachine() {
        return this.gp;
    }

    @Override
    public void gridChanged() {
        this.gp.gridChanged();
    }

    @Override
    public class_1799 getMachineRepresentation() {
        return this.myRepInstance;
    }

    public void setFlags(GridFlags ... requireChannel) {
        EnumSet<GridFlags> flags = EnumSet.noneOf(GridFlags.class);
        Collections.addAll(flags, requireChannel);
        this.flags = flags;
    }

    public void setIdlePowerUsage(double idle) {
        this.idleDraw = idle;
        if (this.node != null) {
            try {
                IGrid g = this.getGrid();
                g.postEvent(new MENetworkPowerIdleChange(this.node));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean isActive() {
        if (this.node == null) {
            return false;
        }
        return this.node.isActive();
    }

    public boolean isPowered() {
        try {
            return this.getEnergy().isNetworkPowered();
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    public IEnergyGrid getEnergy() throws GridAccessException {
        IGrid grid = this.getGrid();
        if (grid == null) {
            throw new GridAccessException();
        }
        IEnergyGrid eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        if (eg == null) {
            throw new GridAccessException();
        }
        return eg;
    }

    public void setOwner(class_1657 player) {
        this.owner = player;
    }

    public AEColor getColor() {
        return this.myColor;
    }

    public void setColor(AEColor myColor) {
        this.myColor = myColor;
    }
}

