/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.items.contents.CellConfig;
import appeng.me.storage.BasicCellInventoryHandler;
import appeng.util.item.AEItemStack;
import net.minecraft.class_1799;

public class CreativeCellInventory
implements IMEInventoryHandler<IAEItemStack> {
    private final IItemList<IAEItemStack> itemListCache = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();

    protected CreativeCellInventory(class_1799 o) {
        CellConfig cc = new CellConfig(o);
        for (class_1799 is : cc) {
            if (is.method_7960()) continue;
            AEItemStack i = AEItemStack.fromItemStack(is);
            i.setStackSize(Integer.MAX_VALUE);
            this.itemListCache.add(i);
        }
    }

    public static ICellInventoryHandler getCell(class_1799 o) {
        return new BasicCellInventoryHandler<IAEItemStack>((IMEInventory)new CreativeCellInventory(o), (IStorageChannel<IAEItemStack>)Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, IActionSource src) {
        IAEItemStack local = this.itemListCache.findPrecise(input);
        if (local == null) {
            return input;
        }
        return null;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
        IAEItemStack local = this.itemListCache.findPrecise(request);
        if (local == null) {
            return null;
        }
        return request.copy();
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList out) {
        for (IAEItemStack ais : this.itemListCache) {
            out.add(ais);
        }
        return out;
    }

    @Override
    public IStorageChannel getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEItemStack input) {
        return this.itemListCache.findPrecise(input) != null;
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        return this.itemListCache.findPrecise(input) != null;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }
}

