/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.fluids.util.AEFluidStack;
import appeng.me.storage.ITickingMonitor;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MEMonitorIFluidHandler
implements IMEMonitor<IAEFluidStack>,
ITickingMonitor {
    private final GroupedFluidInv handler;
    private final IItemList<IAEFluidStack> list = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
    private final HashMap<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> listeners = new HashMap();
    private final Map<FluidKey, CachedFluidStack> memory;
    private IActionSource mySource;
    private StorageFilter mode = StorageFilter.EXTRACTABLE_ONLY;
    private static final FluidAmount MIN_EXTRACTION_AMOUNT = FluidAmount.of((long)1L, (long)1000L);

    public MEMonitorIFluidHandler(GroupedFluidInv handler) {
        this.handler = handler;
        this.memory = new HashMap<FluidKey, CachedFluidStack>();
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEFluidStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEFluidStack> l) {
        this.listeners.remove(l);
    }

    private Simulation getFluidAction(Actionable actionable) {
        return actionable == Actionable.MODULATE ? Simulation.ACTION : Simulation.SIMULATE;
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, IActionSource src) {
        FluidVolume toFill = input.getFluidStack();
        FluidVolume excess = this.handler.attemptInsertion(toFill, this.getFluidAction(type));
        if (excess.equals((Object)toFill)) {
            return input.copy();
        }
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        if (excess.isEmpty()) {
            return null;
        }
        return AEFluidStack.fromFluidVolume(excess, RoundingMode.DOWN);
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable type, IActionSource src) {
        FluidAmount amount = request.getAmount();
        ExactFluidFilter filter = new ExactFluidFilter(request.getFluid());
        FluidVolume removed = this.handler.attemptExtraction((FluidFilter)filter, amount, this.getFluidAction(type));
        if (removed.isEmpty()) {
            return null;
        }
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        return AEFluidStack.fromFluidVolume(removed, RoundingMode.DOWN);
    }

    @Override
    public IStorageChannel getChannel() {
        return Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public TickRateModulation onTick() {
        ArrayList<IAEFluidStack> changes = new ArrayList<IAEFluidStack>();
        this.list.resetStatus();
        boolean changed = false;
        Set storedFluids = this.handler.getStoredFluids();
        for (FluidKey storedFluid : storedFluids) {
            FluidAmount oldAmount;
            CachedFluidStack old = this.memory.get(storedFluid);
            FluidAmount newAmount = this.getCurrentAmount(storedFluid);
            FluidAmount fluidAmount = oldAmount = old == null ? FluidAmount.ZERO : old.volume.amount();
            if (!newAmount.equals(oldAmount)) {
                CachedFluidStack cis = new CachedFluidStack(storedFluid.withAmount(newAmount));
                this.memory.put(storedFluid, cis);
                if (old != null && old.aeStack != null) {
                    old.aeStack.setStackSize(-old.aeStack.getStackSize());
                    changes.add(old.aeStack);
                }
                if (cis.aeStack != null) {
                    changes.add(cis.aeStack);
                    this.list.add(cis.aeStack);
                }
                changed = true;
                continue;
            }
            long newSize = newAmount.isZero() ? 0L : newAmount.asLong(1000L, RoundingMode.DOWN);
            long diff = newSize - (oldAmount.isZero() ? 0L : oldAmount.asLong(1000L, RoundingMode.DOWN));
            IAEStack stack = null;
            if (!newAmount.isZero()) {
                IAEStack<IAEFluidStack> iAEStack = stack = old == null || old.aeStack == null ? AEFluidStack.fromFluidVolume(storedFluid.withAmount(newAmount), RoundingMode.DOWN) : old.aeStack.copy();
            }
            if (stack != null) {
                stack.setStackSize(newSize);
                this.list.add((IAEFluidStack)stack);
            }
            if (diff == 0L || stack == null) continue;
            CachedFluidStack cis = new CachedFluidStack(storedFluid.withAmount(newAmount));
            this.memory.put(storedFluid, cis);
            IAEFluidStack a = stack.copy();
            a.setStackSize(diff);
            changes.add(a);
            changed = true;
        }
        HashSet<FluidKey> toRemove = null;
        for (Map.Entry<FluidKey, CachedFluidStack> entry : this.memory.entrySet()) {
            if (storedFluids.contains(entry.getKey())) continue;
            if (toRemove == null) {
                toRemove = new HashSet<FluidKey>();
            }
            toRemove.add(entry.getKey());
            if (entry.getValue().aeStack == null) continue;
            IAEFluidStack a = entry.getValue().aeStack.copy();
            a.setStackSize(-a.getStackSize());
            changes.add(a);
            changed = true;
        }
        if (toRemove != null) {
            for (FluidKey fluidKey : toRemove) {
                this.memory.remove(fluidKey);
            }
        }
        if (!changes.isEmpty()) {
            this.postDifference(changes);
        }
        return changed ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private FluidAmount getCurrentAmount(FluidKey storedFluid) {
        ExactFluidFilter filter;
        FluidAmount newAmount = this.handler.getAmount_F(storedFluid);
        if (!newAmount.isZero() && this.getMode() == StorageFilter.EXTRACTABLE_ONLY && this.handler.attemptExtraction((FluidFilter)(filter = new ExactFluidFilter(storedFluid)), MIN_EXTRACTION_AMOUNT, Simulation.SIMULATE).isEmpty() && this.handler.attemptExtraction((FluidFilter)filter, FluidAmount.BUCKET, Simulation.SIMULATE).isEmpty()) {
            newAmount = FluidAmount.ZERO;
        }
        return newAmount;
    }

    private static boolean isDifferent(FluidVolume a, FluidVolume b) {
        if (a == b) {
            return false;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return true;
        }
        return !a.getFluidKey().equals((Object)b.getFluidKey());
    }

    private void postDifference(Iterable<IAEFluidStack> a) {
        if (a != null) {
            Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object>> i = this.listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> l = i.next();
                IMEMonitorHandlerReceiver<IAEFluidStack> key = l.getKey();
                if (key.isValid(l.getValue())) {
                    key.postChange(this, a, this.getActionSource());
                    continue;
                }
                i.remove();
            }
        }
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEFluidStack input) {
        return false;
    }

    @Override
    public boolean canAccept(IAEFluidStack input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList out) {
        for (CachedFluidStack is : this.memory.values()) {
            out.addStorage(is.aeStack);
        }
        return out;
    }

    @Override
    public IItemList<IAEFluidStack> getStorageList() {
        return this.list;
    }

    private StorageFilter getMode() {
        return this.mode;
    }

    public void setMode(StorageFilter mode) {
        this.mode = mode;
    }

    private IActionSource getActionSource() {
        return this.mySource;
    }

    @Override
    public void setActionSource(IActionSource mySource) {
        this.mySource = mySource;
    }

    private static class CachedFluidStack {
        private final FluidVolume volume;
        private final IAEFluidStack aeStack;

        CachedFluidStack(FluidVolume volume) {
            this.aeStack = AEFluidStack.fromFluidVolume(volume, RoundingMode.DOWN);
            this.volume = this.aeStack != null ? this.aeStack.getFluidStack() : FluidVolumeUtil.EMPTY;
        }
    }
}

