/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.me.storage.ITickingMonitor;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.ItemSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.minecraft.class_1799;

public class MEMonitorIInventory
implements IMEMonitor<IAEItemStack>,
ITickingMonitor {
    private final InventoryAdaptor adaptor;
    private final IItemList<IAEItemStack> list = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap();
    private final NavigableMap<Integer, CachedItemStack> memory;
    private IActionSource mySource;
    private StorageFilter mode = StorageFilter.EXTRACTABLE_ONLY;

    public MEMonitorIInventory(InventoryAdaptor adaptor) {
        this.adaptor = adaptor;
        this.memory = new ConcurrentSkipListMap<Integer, CachedItemStack>();
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
        class_1799 out = class_1799.field_8037;
        out = type == Actionable.SIMULATE ? this.adaptor.simulateAdd(input.createItemStack()) : this.adaptor.addItems(input.createItemStack());
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        if (out.method_7960()) {
            return null;
        }
        IAEItemStack o = input.copy();
        o.setStackSize(out.method_7947());
        return o;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable type, IActionSource src) {
        class_1799 out = class_1799.field_8037;
        out = type == Actionable.SIMULATE ? this.adaptor.simulateRemove((int)request.getStackSize(), request.getDefinition(), null) : this.adaptor.removeItems((int)request.getStackSize(), request.getDefinition(), null);
        if (out.method_7960()) {
            return null;
        }
        IAEItemStack o = request.copy();
        o.setStackSize(out.method_7947());
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        return o;
    }

    @Override
    public IStorageChannel getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public TickRateModulation onTick() {
        ArrayList<IAEItemStack> changes = new ArrayList<IAEItemStack>();
        this.list.resetStatus();
        int high = 0;
        boolean changed = false;
        for (ItemSlot is : this.adaptor) {
            IAEItemStack stack;
            class_1799 oldIS;
            CachedItemStack old = (CachedItemStack)this.memory.get(is.getSlot());
            high = Math.max(high, is.getSlot());
            class_1799 newIS = !is.isExtractable() && this.getMode() == StorageFilter.EXTRACTABLE_ONLY ? class_1799.field_8037 : is.getItemStack();
            class_1799 class_17992 = oldIS = old == null ? class_1799.field_8037 : old.itemStack;
            if (this.isDifferent(newIS, oldIS)) {
                CachedItemStack cis = new CachedItemStack(is.getItemStack());
                this.memory.put(is.getSlot(), cis);
                if (old != null && old.aeStack != null) {
                    old.aeStack.setStackSize(-old.aeStack.getStackSize());
                    changes.add(old.aeStack);
                }
                if (cis.aeStack != null) {
                    changes.add(cis.aeStack);
                    this.list.add(cis.aeStack);
                }
                changed = true;
                continue;
            }
            int newSize = newIS.method_7960() ? 0 : newIS.method_7947();
            int diff = newSize - (oldIS.method_7960() ? 0 : oldIS.method_7947());
            IAEItemStack iAEItemStack = stack = old == null || old.aeStack == null ? (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(newIS) : old.aeStack.copy();
            if (stack != null) {
                stack.setStackSize(newSize);
                this.list.add(stack);
            }
            if (diff == 0 || stack == null) continue;
            CachedItemStack cis = new CachedItemStack(is.getItemStack());
            this.memory.put(is.getSlot(), cis);
            IAEItemStack a = stack.copy();
            a.setStackSize(diff);
            changes.add(a);
            changed = true;
        }
        NavigableMap<Integer, CachedItemStack> end = this.memory.tailMap(high, false);
        if (!end.isEmpty()) {
            for (CachedItemStack cis : end.values()) {
                if (cis == null || cis.aeStack == null) continue;
                IAEItemStack a = cis.aeStack.copy();
                a.setStackSize(-a.getStackSize());
                changes.add(a);
                changed = true;
            }
            end.clear();
        }
        if (!changes.isEmpty()) {
            this.postDifference(changes);
        }
        return changed ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private boolean isDifferent(class_1799 a, class_1799 b) {
        if (a == b && b.method_7960()) {
            return false;
        }
        if (a.method_7960() && !b.method_7960() || !a.method_7960() && b.method_7960()) {
            return true;
        }
        return !Platform.itemComparisons().isSameItem(a, b);
    }

    private void postDifference(Iterable<IAEItemStack> a) {
        if (a != null) {
            Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> l = i.next();
                IMEMonitorHandlerReceiver<IAEItemStack> key = l.getKey();
                if (key.isValid(l.getValue())) {
                    key.postChange(this, a, this.getActionSource());
                    continue;
                }
                i.remove();
            }
        }
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEItemStack input) {
        return false;
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList out) {
        for (CachedItemStack is : this.memory.values()) {
            out.addStorage(is.aeStack);
        }
        return out;
    }

    @Override
    public IItemList<IAEItemStack> getStorageList() {
        return this.list;
    }

    private StorageFilter getMode() {
        return this.mode;
    }

    public void setMode(StorageFilter mode) {
        this.mode = mode;
    }

    private IActionSource getActionSource() {
        return this.mySource;
    }

    @Override
    public void setActionSource(IActionSource mySource) {
        this.mySource = mySource;
    }

    private static class CachedItemStack {
        private final class_1799 itemStack;
        private final IAEItemStack aeStack;

        public CachedItemStack(class_1799 is) {
            if (is.method_7960()) {
                this.itemStack = class_1799.field_8037;
                this.aeStack = null;
            } else {
                this.itemStack = is.method_7972();
                this.aeStack = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(is);
            }
        }
    }
}

