/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.me.GridAccessException;
import appeng.tile.misc.SecurityStationBlockEntity;
import com.mojang.authlib.GameProfile;

public class SecurityStationInventory
implements IMEInventoryHandler<IAEItemStack> {
    private final IItemList<IAEItemStack> storedItems = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final SecurityStationBlockEntity securityTile;

    public SecurityStationInventory(SecurityStationBlockEntity ts) {
        this.securityTile = ts;
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
        if (this.hasPermission(src) && Api.instance().definitions().items().biometricCard().isSameAs(input.createItemStack()) && this.canAccept(input)) {
            if (type == Actionable.SIMULATE) {
                return null;
            }
            this.getStoredItems().add(input);
            this.securityTile.inventoryChanged();
            return null;
        }
        return input;
    }

    private boolean hasPermission(IActionSource src) {
        if (src.player().isPresent()) {
            try {
                return this.securityTile.getProxy().getSecurity().hasPermission(src.player().get(), SecurityPermissions.SECURITY);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
        IAEItemStack target;
        if (this.hasPermission(src) && (target = this.getStoredItems().findPrecise(request)) != null) {
            IAEItemStack output = target.copy();
            if (mode == Actionable.SIMULATE) {
                return output;
            }
            target.setStackSize(0L);
            this.securityTile.inventoryChanged();
            return output;
        }
        return null;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList out) {
        for (IAEItemStack ais : this.getStoredItems()) {
            out.add(ais);
        }
        return out;
    }

    @Override
    public IStorageChannel getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEItemStack input) {
        return false;
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        if (input.getItem() instanceof IBiometricCard) {
            IBiometricCard tbc = (IBiometricCard)input.getItem();
            GameProfile newUser = tbc.getProfile(input.createItemStack());
            int PlayerID = Api.instance().registries().players().getID(newUser);
            if (this.securityTile.getOwner() == PlayerID) {
                return false;
            }
            for (IAEItemStack ais : this.getStoredItems()) {
                if (!ais.isMeaningful()) continue;
                GameProfile thisUser = tbc.getProfile(ais.createItemStack());
                if (thisUser == newUser) {
                    return false;
                }
                if (thisUser == null || !thisUser.equals((Object)newUser)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }

    public IItemList<IAEItemStack> getStoredItems() {
        return this.storedItems;
    }
}

