/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IDefinitions;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.Api;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IPriorityHost;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.parts.automation.LevelEmitterPart;
import appeng.parts.networking.CablePart;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;

public abstract class AEBasePart
implements IPart,
IGridProxyable,
IActionHost,
IUpgradeableHost,
ICustomNameObject {
    private final AENetworkProxy proxy;
    private final class_1799 is;
    private class_2586 tile = null;
    private IPartHost host = null;
    private AEPartLocation side = null;

    public AEBasePart(class_1799 is) {
        Preconditions.checkNotNull((Object)is);
        this.is = is;
        this.proxy = new AENetworkProxy(this, "part", is, this instanceof CablePart);
        this.proxy.setValidSides(EnumSet.noneOf(class_2350.class));
    }

    public IPartHost getHost() {
        return this.host;
    }

    @Override
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.proxy.getNode();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.GLASS;
    }

    @Override
    public void securityBreak() {
        if (this.getItemStack().method_7947() > 0 && this.getGridNode() != null) {
            ArrayList<class_1799> items = new ArrayList<class_1799>();
            items.add(this.is.method_7972());
            this.host.removePart(this.side, false);
            Platform.spawnDrops(this.tile.method_10997(), this.tile.method_11016(), items);
            this.is.method_7939(0);
        }
    }

    protected AEColor getColor() {
        if (this.host == null) {
            return AEColor.TRANSPARENT;
        }
        return this.host.getColor();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return 0;
    }

    @Override
    public class_2586 getTile() {
        return this.tile;
    }

    @Override
    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.tile);
    }

    @Override
    public void gridChanged() {
    }

    @Override
    public IGridNode getActionableNode() {
        return this.proxy.getNode();
    }

    @Override
    public void saveChanges() {
        this.host.markForSave();
    }

    @Override
    public class_2561 getCustomInventoryName() {
        return this.getItemStack().method_7964();
    }

    @Override
    public boolean hasCustomInventoryName() {
        return this.getItemStack().method_7938();
    }

    @Override
    public void addEntityCrashInfo(class_129 section) {
        section.method_578("Part Side", (Object)this.getSide());
    }

    @Override
    public class_1799 getItemStack(PartItemStack type) {
        if (type == PartItemStack.NETWORK) {
            class_1799 copy = this.is.method_7972();
            copy.method_7980(null);
            return copy;
        }
        return this.is;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public void onNeighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
    }

    @Override
    public boolean canConnectRedstone() {
        return false;
    }

    @Override
    public void readFromNBT(class_2487 data) {
        this.proxy.readFromNBT(data);
    }

    @Override
    public void writeToNBT(class_2487 data) {
        this.proxy.writeToNBT(data);
    }

    @Override
    public int isProvidingStrongPower() {
        return 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return 0;
    }

    @Override
    public void writeToStream(class_2540 data) throws IOException {
    }

    @Override
    public boolean readFromStream(class_2540 data) throws IOException {
        return false;
    }

    @Override
    public IGridNode getGridNode() {
        return this.proxy.getNode();
    }

    @Override
    public void onEntityCollision(class_1297 entity) {
    }

    @Override
    public void removeFromWorld() {
        this.proxy.remove();
    }

    @Override
    public void addToWorld() {
        this.proxy.onReady();
    }

    @Override
    public void setPartHostInfo(AEPartLocation side, IPartHost host, class_2586 tile) {
        this.setSide(side);
        this.tile = tile;
        this.host = host;
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void randomDisplayTick(class_1937 world, class_2338 pos, Random r) {
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public void getDrops(List<class_1799> drops, boolean wrenched) {
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 3.0f;
    }

    @Override
    public boolean isLadder(class_1309 entity) {
        return false;
    }

    @Override
    public IConfigManager getConfigManager() {
        return null;
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        return null;
    }

    private void uploadSettings(SettingsFrom from, class_2487 compound) {
        FixedItemInv inv;
        IConfigManager cm = this.getConfigManager();
        if (cm != null) {
            cm.readFromNBT(compound);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            pHost.setPriority(compound.method_10550("priority"));
        }
        if ((inv = this.getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            AppEngInternalAEInventory target = (AppEngInternalAEInventory)inv;
            AppEngInternalAEInventory tmp = new AppEngInternalAEInventory(null, target.getSlotCount());
            tmp.readFromNBT(compound, "config");
            for (int x = 0; x < tmp.getSlotCount(); ++x) {
                target.forceSetInvStack(x, tmp.getInvStack(x));
            }
            if (this instanceof LevelEmitterPart) {
                LevelEmitterPart partLevelEmitter = (LevelEmitterPart)this;
                partLevelEmitter.setReportingValue(compound.method_10537("reportingValue"));
            }
        }
    }

    private class_2487 downloadSettings(SettingsFrom from) {
        FixedItemInv inv;
        class_2487 output = new class_2487();
        IConfigManager cm = this.getConfigManager();
        if (cm != null) {
            cm.writeToNBT(output);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            output.method_10569("priority", pHost.getPriority());
        }
        if ((inv = this.getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            ((AppEngInternalAEInventory)inv).writeToNBT(output, "config");
            if (this instanceof LevelEmitterPart) {
                LevelEmitterPart partLevelEmitter = (LevelEmitterPart)this;
                output.method_10544("reportingValue", partLevelEmitter.getReportingValue());
            }
        }
        return output.isEmpty() ? null : output;
    }

    public boolean useStandardMemoryCard() {
        return true;
    }

    private boolean useMemoryCard(class_1657 player) {
        class_1799 memCardIS = player.field_7514.method_7391();
        if (!memCardIS.method_7960() && this.useStandardMemoryCard() && memCardIS.method_7909() instanceof IMemoryCard) {
            Optional<class_1799> iface;
            IMemoryCard memoryCard = (IMemoryCard)memCardIS.method_7909();
            class_1799 is = this.getItemStack(PartItemStack.NETWORK);
            IDefinitions definitions = Api.instance().definitions();
            if (definitions.parts().iface().isSameAs(is) && (iface = definitions.blocks().iface().maybeStack(1)).isPresent()) {
                is = iface.get();
            }
            String name = is.method_7922();
            if (player.method_18276()) {
                class_2487 data = this.downloadSettings(SettingsFrom.MEMORY_CARD);
                if (data != null) {
                    memoryCard.setMemoryCardContents(memCardIS, name, data);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                }
            } else {
                String storedName = memoryCard.getSettingsName(memCardIS);
                class_2487 data = memoryCard.getData(memCardIS);
                if (name.equals(storedName)) {
                    this.uploadSettings(SettingsFrom.MEMORY_CARD, data);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                } else {
                    memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean onActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (this.useMemoryCard(player)) {
            return true;
        }
        return this.onPartActivate(player, hand, pos);
    }

    @Override
    public final boolean onShiftActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (this.useMemoryCard(player)) {
            return true;
        }
        return this.onPartShiftActivate(player, hand, pos);
    }

    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        return false;
    }

    public boolean onPartShiftActivate(class_1657 player, class_1268 hand, class_243 pos) {
        return false;
    }

    @Override
    public void onPlacement(class_1657 player, class_1268 hand, class_1799 held, AEPartLocation side) {
        this.proxy.setOwner(player);
    }

    @Override
    public boolean canBePlacedOn(BusSupport what) {
        return what == BusSupport.CABLE;
    }

    @Override
    public boolean requireDynamicRender() {
        return false;
    }

    public AEPartLocation getSide() {
        return this.side;
    }

    private void setSide(AEPartLocation side) {
        this.side = side;
    }

    public class_1799 getItemStack() {
        return this.is;
    }
}

