/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.config.YesNo;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.implementations.parts.ICablePart;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.LayerFlags;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.FacadeRenderState;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.facade.FacadeContainer;
import appeng.helpers.AEMultiTile;
import appeng.me.GridConnection;
import appeng.parts.BusCollisionHelper;
import appeng.parts.CableBusStorage;
import appeng.parts.ICableBusContainer;
import appeng.parts.PartPlacement;
import appeng.parts.VoxelShapeCache;
import appeng.parts.networking.CablePart;
import appeng.util.Platform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public class CableBusContainer
extends CableBusStorage
implements AEMultiTile,
ICableBusContainer {
    private static final ThreadLocal<Boolean> IS_LOADING = new ThreadLocal();
    private final EnumSet<LayerFlags> myLayerFlags = EnumSet.noneOf(LayerFlags.class);
    private YesNo hasRedstone = YesNo.UNDECIDED;
    private IPartHost tcb;
    private boolean requiresDynamicRender = false;
    private boolean inWorld = false;
    private class_265 cachedCollisionShapeLiving;
    private class_265 cachedCollisionShape;
    private class_265 cachedShape;

    public CableBusContainer(IPartHost host) {
        this.tcb = host;
    }

    public static boolean isLoading() {
        Boolean is = IS_LOADING.get();
        return is != null && is != false;
    }

    public void setHost(IPartHost host) {
        this.tcb.clearContainer();
        this.tcb = host;
    }

    public void rotateLeft() {
        IPart[] newSides = new IPart[6];
        newSides[AEPartLocation.UP.ordinal()] = this.getSide(AEPartLocation.UP);
        newSides[AEPartLocation.DOWN.ordinal()] = this.getSide(AEPartLocation.DOWN);
        newSides[AEPartLocation.EAST.ordinal()] = this.getSide(AEPartLocation.NORTH);
        newSides[AEPartLocation.SOUTH.ordinal()] = this.getSide(AEPartLocation.EAST);
        newSides[AEPartLocation.WEST.ordinal()] = this.getSide(AEPartLocation.SOUTH);
        newSides[AEPartLocation.NORTH.ordinal()] = this.getSide(AEPartLocation.WEST);
        for (AEPartLocation dir : AEPartLocation.SIDE_LOCATIONS) {
            this.setSide(dir, newSides[dir.ordinal()]);
        }
        this.getFacadeContainer().rotateLeft();
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return new FacadeContainer(this, this::invalidateShapes);
    }

    @Override
    public boolean canAddPart(class_1799 is, AEPartLocation side) {
        if (PartPlacement.isFacade(is, side) != null) {
            return true;
        }
        if (is.method_7909() instanceof IPartItem) {
            IPartItem bi = (IPartItem)is.method_7909();
            is = is.method_7972();
            is.method_7939(1);
            Object bp = bi.createPart(is);
            if (bp != null) {
                if (bp instanceof ICablePart) {
                    boolean canPlace = true;
                    for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                        if (this.getPart(d) == null || this.getPart(d).canBePlacedOn(((ICablePart)bp).supportsBuses())) continue;
                        canPlace = false;
                    }
                    if (!canPlace) {
                        return false;
                    }
                    return this.getPart(AEPartLocation.INTERNAL) == null;
                }
                if (!(bp instanceof ICablePart) && side != AEPartLocation.INTERNAL) {
                    IPart cable = this.getPart(AEPartLocation.INTERNAL);
                    if (cable != null && !bp.canBePlacedOn(((ICablePart)cable).supportsBuses())) {
                        return false;
                    }
                    return this.getPart(side) == null;
                }
            }
        }
        return false;
    }

    @Override
    public AEPartLocation addPart(class_1799 is, AEPartLocation side, @Nullable class_1657 player, @Nullable class_1268 hand) {
        if (this.canAddPart(is, side) && is.method_7909() instanceof IPartItem) {
            IPartItem bi = (IPartItem)is.method_7909();
            is = is.method_7972();
            is.method_7939(1);
            Object bp = bi.createPart(is);
            if (bp instanceof ICablePart) {
                IGridNode cn;
                boolean canPlace = true;
                for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                    if (this.getPart(d) == null || this.getPart(d).canBePlacedOn(((ICablePart)bp).supportsBuses())) continue;
                    canPlace = false;
                }
                if (!canPlace) {
                    return null;
                }
                if (this.getPart(AEPartLocation.INTERNAL) != null) {
                    return null;
                }
                this.setCenter((ICablePart)bp);
                bp.setPartHostInfo(AEPartLocation.INTERNAL, this, this.tcb.getTile());
                if (player != null) {
                    bp.onPlacement(player, hand, is, side);
                }
                if (this.inWorld) {
                    bp.addToWorld();
                }
                if ((cn = this.getCenter().getGridNode()) != null) {
                    for (AEPartLocation ins : AEPartLocation.SIDE_LOCATIONS) {
                        IGridNode sn;
                        IPart sbp = this.getPart(ins);
                        if (sbp == null || (sn = sbp.getGridNode()) == null) continue;
                        try {
                            GridConnection.create(cn, sn, AEPartLocation.INTERNAL);
                        }
                        catch (FailedConnectionException e) {
                            AELog.debug(e);
                            bp.removeFromWorld();
                            this.setCenter(null);
                            return null;
                        }
                    }
                }
                this.invalidateShapes();
                this.updateConnections();
                this.markForUpdate();
                this.markForSave();
                this.partChanged();
                return AEPartLocation.INTERNAL;
            }
            if (bp != null && !(bp instanceof ICablePart) && side != AEPartLocation.INTERNAL) {
                IPart cable = this.getPart(AEPartLocation.INTERNAL);
                if (cable != null && !bp.canBePlacedOn(((ICablePart)cable).supportsBuses())) {
                    return null;
                }
                this.setSide(side, (IPart)bp);
                bp.setPartHostInfo(side, this, this.getTile());
                if (player != null) {
                    bp.onPlacement(player, hand, is, side);
                }
                if (this.inWorld) {
                    bp.addToWorld();
                }
                if (this.getCenter() != null) {
                    IGridNode cn = this.getCenter().getGridNode();
                    IGridNode sn = bp.getGridNode();
                    if (cn != null && sn != null) {
                        try {
                            GridConnection.create(cn, sn, AEPartLocation.INTERNAL);
                        }
                        catch (FailedConnectionException e) {
                            AELog.debug(e);
                            bp.removeFromWorld();
                            this.setSide(side, null);
                            return null;
                        }
                    }
                }
                this.invalidateShapes();
                this.updateDynamicRender();
                this.updateConnections();
                this.markForUpdate();
                this.markForSave();
                this.partChanged();
                return side;
            }
        }
        return null;
    }

    @Override
    public IPart getPart(AEPartLocation partLocation) {
        if (partLocation == AEPartLocation.INTERNAL) {
            return this.getCenter();
        }
        return this.getSide(partLocation);
    }

    @Override
    public IPart getPart(class_2350 side) {
        return this.getSide(AEPartLocation.fromFacing(side));
    }

    @Override
    public void removePart(AEPartLocation side, boolean suppressUpdate) {
        if (side == AEPartLocation.INTERNAL) {
            if (this.getCenter() != null) {
                this.getCenter().removeFromWorld();
            }
            this.setCenter(null);
        } else {
            if (this.getSide(side) != null) {
                this.getSide(side).removeFromWorld();
            }
            this.setSide(side, null);
        }
        if (!suppressUpdate) {
            this.invalidateShapes();
            this.updateDynamicRender();
            this.updateConnections();
            this.markForUpdate();
            this.markForSave();
            this.partChanged();
        }
    }

    @Override
    public void markForUpdate() {
        this.tcb.markForUpdate();
    }

    @Override
    public DimensionalCoord getLocation() {
        return this.tcb.getLocation();
    }

    @Override
    public class_2586 getTile() {
        return this.tcb.getTile();
    }

    @Override
    public AEColor getColor() {
        if (this.getCenter() != null) {
            ICablePart c = this.getCenter();
            return c.getCableColor();
        }
        return AEColor.TRANSPARENT;
    }

    @Override
    public void clearContainer() {
        throw new UnsupportedOperationException("Now that is silly!");
    }

    @Override
    public boolean isBlocked(class_2350 side) {
        return this.tcb.isBlocked(side);
    }

    @Override
    public SelectedPart selectPart(class_243 pos) {
        for (AEPartLocation side : AEPartLocation.values()) {
            IPart p = this.getPart(side);
            if (p == null) continue;
            ArrayList<class_238> boxes = new ArrayList<class_238>();
            BusCollisionHelper bch = new BusCollisionHelper(boxes, side, true);
            p.getBoxes(bch);
            for (class_238 bb : boxes) {
                if (!(bb = bb.method_1009(0.002, 0.002, 0.002)).method_1006(pos)) continue;
                return new SelectedPart(p, side);
            }
        }
        if (Api.instance().partHelper().getCableRenderMode().opaqueFacades) {
            IFacadeContainer fc = this.getFacadeContainer();
            for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
                IFacadePart p = fc.getFacade(side);
                if (p == null) continue;
                ArrayList<class_238> boxes = new ArrayList<class_238>();
                BusCollisionHelper bch = new BusCollisionHelper(boxes, side, true);
                p.getBoxes(bch, true);
                for (class_238 bb : boxes) {
                    if (!(bb = bb.method_1009(0.01, 0.01, 0.01)).method_1006(pos)) continue;
                    return new SelectedPart(p, side);
                }
            }
        }
        return new SelectedPart();
    }

    @Override
    public void markForSave() {
        this.tcb.markForSave();
    }

    @Override
    public void partChanged() {
        if (this.getCenter() == null) {
            ArrayList<class_1799> facades = new ArrayList<class_1799>();
            IFacadeContainer fc = this.getFacadeContainer();
            for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                IFacadePart fp = fc.getFacade(d);
                if (fp == null) continue;
                facades.add(fp.getItemStack());
                fc.removeFacade(this.tcb, d);
            }
            if (!facades.isEmpty()) {
                class_2586 te = this.tcb.getTile();
                Platform.spawnDrops(te.method_10997(), te.method_11016(), facades);
            }
        }
        this.tcb.partChanged();
    }

    @Override
    public boolean hasRedstone(AEPartLocation side) {
        if (this.hasRedstone == YesNo.UNDECIDED) {
            this.updateRedstone();
        }
        return this.hasRedstone == YesNo.YES;
    }

    @Override
    public boolean isEmpty() {
        IFacadeContainer fc = this.getFacadeContainer();
        for (AEPartLocation s : AEPartLocation.values()) {
            IFacadePart fp;
            IPart part = this.getPart(s);
            if (part != null) {
                return false;
            }
            if (s == AEPartLocation.INTERNAL || (fp = fc.getFacade(s)) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<LayerFlags> getLayerFlags() {
        return this.myLayerFlags;
    }

    @Override
    public void cleanup() {
        this.tcb.cleanup();
    }

    @Override
    public void notifyNeighbors() {
        this.tcb.notifyNeighbors();
    }

    @Override
    public boolean isInWorld() {
        return this.inWorld;
    }

    private void updateRedstone() {
        class_2586 te = this.getTile();
        this.hasRedstone = te.method_10997().method_8482(te.method_11016()) != 0 ? YesNo.YES : YesNo.NO;
    }

    private void updateDynamicRender() {
        this.requiresDynamicRender = false;
        for (AEPartLocation s : AEPartLocation.SIDE_LOCATIONS) {
            IPart p = this.getPart(s);
            if (p == null) continue;
            this.setRequiresDynamicRender(this.isRequiresDynamicRender() || p.requireDynamicRender());
        }
    }

    public void updateConnections() {
        if (this.getCenter() != null) {
            EnumSet<class_2350> sides = EnumSet.allOf(class_2350.class);
            for (class_2350 s : class_2350.values()) {
                if (this.getPart(s) == null && !this.isBlocked(s)) continue;
                sides.remove(s);
            }
            this.getCenter().setValidSides(sides);
            IGridNode n = this.getCenter().getGridNode();
            if (n != null) {
                n.updateState();
            }
        }
    }

    public void addToWorld() {
        if (this.inWorld) {
            return;
        }
        this.inWorld = true;
        IS_LOADING.set(true);
        class_2586 te = this.getTile();
        for (int x = 6; x >= 0; --x) {
            IGridNode cn;
            IPart center;
            IGridNode sn;
            AEPartLocation s = AEPartLocation.fromOrdinal(x);
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.setPartHostInfo(s, this, te);
            part.addToWorld();
            if (s == AEPartLocation.INTERNAL || (sn = part.getGridNode()) == null || (center = this.getPart(AEPartLocation.INTERNAL)) == null || (cn = center.getGridNode()) == null) continue;
            try {
                Api.instance().grid().createGridConnection(cn, sn);
                continue;
            }
            catch (FailedConnectionException e) {
                AELog.debug(e);
            }
        }
        this.partChanged();
        IS_LOADING.set(false);
    }

    public void removeFromWorld() {
        if (!this.inWorld) {
            return;
        }
        this.inWorld = false;
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.removeFromWorld();
        }
        this.invalidateShapes();
        this.partChanged();
    }

    @Override
    public IGridNode getGridNode(AEPartLocation side) {
        IGridNode n;
        IPart part = this.getPart(side);
        if (part != null && (n = part.getExternalFacingNode()) != null) {
            return n;
        }
        if (this.getCenter() != null) {
            return this.getCenter().getGridNode();
        }
        return null;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        AECableType t;
        IPart part = this.getPart(dir);
        if (part instanceof IGridHost && (t = ((IGridHost)((Object)part)).getCableConnectionType(dir)) != null && t != AECableType.NONE) {
            return t;
        }
        if (this.getCenter() != null) {
            ICablePart c = this.getCenter();
            return c.getCableConnectionType();
        }
        return AECableType.NONE;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return this.getPart(AEPartLocation.INTERNAL) instanceof ICablePart ? this.getPart(AEPartLocation.INTERNAL).getCableConnectionLength(cable) : -1.0f;
    }

    @Override
    public void securityBreak() {
        for (AEPartLocation d : AEPartLocation.values()) {
            IPart p = this.getPart(d);
            if (!(p instanceof IGridHost)) continue;
            ((IGridHost)((Object)p)).securityBreak();
        }
    }

    @Override
    public int isProvidingStrongPower(class_2350 side) {
        IPart part = this.getPart(side);
        return part != null ? part.isProvidingStrongPower() : 0;
    }

    @Override
    public int isProvidingWeakPower(class_2350 side) {
        IPart part = this.getPart(side);
        return part != null ? part.isProvidingWeakPower() : 0;
    }

    @Override
    public boolean canConnectRedstone(class_2350 opposite) {
        IPart part = this.getPart(opposite);
        return part != null && part.canConnectRedstone();
    }

    @Override
    public void onEntityCollision(class_1297 entity) {
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.onEntityCollision(entity);
        }
    }

    @Override
    public boolean activate(class_1657 player, class_1268 hand, class_243 pos) {
        SelectedPart p = this.selectPart(pos);
        if (p != null && p.part != null) {
            if (player.method_18276() && p.part.onShiftActivate(player, hand, pos)) {
                return true;
            }
            return p.part.onActivate(player, hand, pos);
        }
        return false;
    }

    @Override
    public boolean clicked(class_1657 player, class_1268 hand, class_243 hitVec) {
        SelectedPart p = this.selectPart(hitVec);
        if (p != null && p.part != null) {
            if (player.method_18276()) {
                return p.part.onShiftClicked(player, hand, hitVec);
            }
            return p.part.onClicked(player, hand, hitVec);
        }
        return false;
    }

    @Override
    public void onneighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
        this.hasRedstone = YesNo.UNDECIDED;
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.onNeighborUpdate(w, pos, neighbor);
        }
        this.invalidateShapes();
    }

    @Override
    public boolean isLadder(class_1309 entity) {
        for (AEPartLocation side : AEPartLocation.values()) {
            IPart p = this.getPart(side);
            if (p == null || !p.isLadder(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void randomDisplayTick(class_1937 world, class_2338 pos, Random r) {
        for (AEPartLocation side : AEPartLocation.values()) {
            IPart p = this.getPart(side);
            if (p == null) continue;
            p.randomDisplayTick(world, pos, r);
        }
    }

    @Override
    public int getLightValue() {
        int light = 0;
        for (AEPartLocation d : AEPartLocation.values()) {
            IPart p = this.getPart(d);
            if (p == null) continue;
            light = Math.max(p.getLightLevel(), light);
        }
        return light;
    }

    public void writeToStream(class_2540 data) throws IOException {
        IPart p;
        int x;
        int sides = 0;
        for (x = 0; x < 7; ++x) {
            p = this.getPart(AEPartLocation.fromOrdinal(x));
            if (p == null) continue;
            sides |= 1 << x;
        }
        data.writeByte((int)((byte)sides));
        for (x = 0; x < 7; ++x) {
            p = this.getPart(AEPartLocation.fromOrdinal(x));
            if (p == null) continue;
            class_1799 is = p.getItemStack(PartItemStack.NETWORK);
            data.method_10804(class_1792.method_7880((class_1792)is.method_7909()));
            p.writeToStream(data);
        }
        this.getFacadeContainer().writeToStream(data);
    }

    public boolean readFromStream(class_2540 data) throws IOException {
        byte sides = data.readByte();
        boolean updateBlock = false;
        for (int x = 0; x < 7; ++x) {
            AEPartLocation side = AEPartLocation.fromOrdinal(x);
            if ((sides & 1 << x) == 1 << x) {
                class_1799 current;
                IPart p = this.getPart(side);
                int itemID = data.method_10816();
                class_1792 myItem = class_1792.method_7875((int)itemID);
                class_1799 class_17992 = current = p != null ? p.getItemStack(PartItemStack.NETWORK) : null;
                if (current != null && current.method_7909() == myItem) {
                    if (!p.readFromStream(data)) continue;
                    updateBlock = true;
                    continue;
                }
                this.removePart(side, false);
                side = this.addPart(new class_1799((class_1935)myItem, 1), side, null, null);
                if (side != null) {
                    p = this.getPart(side);
                    p.readFromStream(data);
                    continue;
                }
                throw new IllegalStateException("Invalid Stream For CableBus Container.");
            }
            if (this.getPart(side) == null) continue;
            this.removePart(side, false);
        }
        this.invalidateShapes();
        return updateBlock |= this.getFacadeContainer().readFromStream(data);
    }

    public void writeToNBT(class_2487 data) {
        data.method_10569("hasRedstone", this.hasRedstone.ordinal());
        IFacadeContainer fc = this.getFacadeContainer();
        for (AEPartLocation s : AEPartLocation.values()) {
            fc.writeToNBT(data);
            IPart part = this.getPart(s);
            if (part == null) continue;
            class_2487 def = new class_2487();
            part.getItemStack(PartItemStack.WORLD).method_7953(def);
            class_2487 extra = new class_2487();
            part.writeToNBT(extra);
            data.method_10566("def:" + this.getSide(part).ordinal(), (class_2520)def);
            data.method_10566("extra:" + this.getSide(part).ordinal(), (class_2520)extra);
        }
    }

    private AEPartLocation getSide(IPart part) {
        if (this.getCenter() == part) {
            return AEPartLocation.INTERNAL;
        }
        for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
            if (this.getSide(side) != part) continue;
            return side;
        }
        throw new IllegalStateException("Uhh Bad Part (" + part + ") on Side.");
    }

    public void readFromNBT(class_2487 data) {
        this.invalidateShapes();
        if (data.method_10545("hasRedstone")) {
            this.hasRedstone = YesNo.values()[data.method_10550("hasRedstone")];
        }
        for (int x = 0; x < 7; ++x) {
            AEPartLocation side = AEPartLocation.fromOrdinal(x);
            String defKey = "def:" + side.ordinal();
            String extraKey = "extra:" + side.ordinal();
            if (data.method_10573(defKey, 10) && data.method_10573(extraKey, 10)) {
                class_1799 current;
                class_2487 def = data.method_10562(defKey);
                class_2487 extra = data.method_10562(extraKey);
                IPart p = this.getPart(side);
                class_1799 iss = class_1799.method_7915((class_2487)def);
                if (iss.method_7960()) continue;
                class_1799 class_17992 = current = p == null ? class_1799.field_8037 : p.getItemStack(PartItemStack.WORLD);
                if (Platform.itemComparisons().isEqualItemType(iss, current)) {
                    p.readFromNBT(extra);
                    continue;
                }
                this.removePart(side, true);
                side = this.addPart(iss, side, null, null);
                if (side != null) {
                    p = this.getPart(side);
                    p.readFromNBT(extra);
                    continue;
                }
                AELog.warn("Invalid NBT For CableBus Container: " + iss.method_7909().getClass().getName() + " is not a valid part; it was ignored.", new Object[0]);
                continue;
            }
            this.removePart(side, false);
        }
        this.getFacadeContainer().readFromNBT(data);
    }

    public List<class_1799> getDrops(List<class_1799> drops) {
        for (AEPartLocation s : AEPartLocation.values()) {
            IFacadePart fp;
            IPart part = this.getPart(s);
            if (part != null) {
                drops.add(part.getItemStack(PartItemStack.BREAK));
                part.getDrops(drops, false);
            }
            if (s == AEPartLocation.INTERNAL || (fp = this.getFacadeContainer().getFacade(s)) == null) continue;
            drops.add(fp.getItemStack());
        }
        return drops;
    }

    public List<class_1799> getNoDrops(List<class_1799> drops) {
        for (AEPartLocation s : AEPartLocation.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.getDrops(drops, false);
        }
        return drops;
    }

    @Override
    public boolean recolourBlock(class_2350 side, AEColor colour, class_1657 who) {
        IPart cable = this.getPart(AEPartLocation.INTERNAL);
        if (cable != null) {
            ICablePart pc = (ICablePart)cable;
            return pc.changeColor(colour, who);
        }
        return false;
    }

    public boolean isRequiresDynamicRender() {
        return this.requiresDynamicRender;
    }

    private void setRequiresDynamicRender(boolean requiresDynamicRender) {
        this.requiresDynamicRender = requiresDynamicRender;
    }

    @Override
    public CableBusRenderState getRenderState() {
        CablePart cable = (CablePart)this.getCenter();
        CableBusRenderState renderState = new CableBusRenderState();
        if (cable != null) {
            renderState.setCableColor(cable.getCableColor());
            renderState.setCableType(cable.getCableConnectionType());
            renderState.setCoreType(CableCoreType.fromCableType(cable.getCableConnectionType()));
            for (class_2350 facing : class_2350.values()) {
                if (!cable.isConnected(facing)) continue;
                AECableType connectionType = cable.getCableConnectionType();
                class_2338 adjacentPos = this.getTile().method_11016().method_10093(facing);
                class_2586 adjacentTe = this.getTile().method_10997().method_8321(adjacentPos);
                if (adjacentTe instanceof IGridHost) {
                    IGridHost gridHost = (IGridHost)adjacentTe;
                    AECableType adjacentType = gridHost.getCableConnectionType(AEPartLocation.fromFacing(facing.method_10153()));
                    connectionType = AECableType.min(connectionType, adjacentType);
                }
                if (adjacentTe instanceof IPartHost) {
                    renderState.getCableBusAdjacent().add(facing);
                }
                renderState.getConnectionTypes().put(facing, connectionType);
            }
            for (class_2350 facing : class_2350.values()) {
                int channels = cable.getCableConnectionType().isSmart() ? cable.getChannelsOnSide(facing) : 0;
                renderState.getChannelsOnSide().put(facing, channels);
            }
        }
        for (class_2350 facing : class_2350.values()) {
            IPart part;
            FacadeRenderState facadeState = this.getFacadeRenderState(facing);
            if (facadeState != null) {
                renderState.getFacades().put(facing, facadeState);
            }
            if ((part = this.getPart(facing)) == null) continue;
            renderState.getPartModelData().put(facing, part.getModelData());
            AEPartLocation loc = AEPartLocation.fromFacing(facing);
            BusCollisionHelper bch = new BusCollisionHelper(renderState.getBoundingBoxes(), loc, true);
            part.getBoxes(bch);
            if (part instanceof IGridHost) {
                int length;
                IGridHost gridHost = (IGridHost)((Object)part);
                AECableType desiredType = gridHost.getCableConnectionType(AEPartLocation.INTERNAL);
                if (renderState.getCoreType() == CableCoreType.GLASS && (desiredType == AECableType.SMART || desiredType == AECableType.COVERED)) {
                    renderState.setCoreType(CableCoreType.COVERED);
                }
                if ((length = (int)part.getCableConnectionLength(null)) > 0 && length <= 8) {
                    renderState.getAttachmentConnections().put(facing, length);
                }
            }
            renderState.getAttachments().put(facing, part.getStaticModels());
        }
        return renderState;
    }

    private FacadeRenderState getFacadeRenderState(class_2350 side) {
        IFacadePart facade = this.getFacade(side.ordinal());
        if (facade != null) {
            class_1799 textureItem = facade.getTextureItem();
            class_2680 blockState = facade.getBlockState();
            class_1937 world = this.getTile().method_10997();
            if (blockState != null && textureItem != null && world != null) {
                return new FacadeRenderState(blockState, !facade.getBlockState().method_26216((class_1922)world, this.getTile().method_11016()));
            }
        }
        return null;
    }

    public class_265 getOutlineShape() {
        if (this.cachedShape == null) {
            this.cachedShape = this.createShape(false, false);
        }
        return this.cachedShape;
    }

    public class_265 getCollisionShape(class_1297 entity) {
        boolean livingEntity = entity instanceof class_1309;
        if (livingEntity) {
            if (this.cachedCollisionShapeLiving == null) {
                this.cachedCollisionShapeLiving = this.createShape(true, true);
            }
            return this.cachedCollisionShapeLiving;
        }
        if (this.cachedCollisionShape == null) {
            this.cachedCollisionShape = this.createShape(true, false);
        }
        return this.cachedCollisionShape;
    }

    private class_265 createShape(boolean forCollision, boolean forLivingEntity) {
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        IFacadeContainer fc = this.getFacadeContainer();
        for (AEPartLocation s : AEPartLocation.values()) {
            IFacadePart fp;
            BusCollisionHelper bch = new BusCollisionHelper(boxes, s, !forCollision);
            IPart part = this.getPart(s);
            if (part != null) {
                part.getBoxes(bch);
            }
            if (!Api.instance().partHelper().getCableRenderMode().opaqueFacades && !forCollision || s == AEPartLocation.INTERNAL || (fp = fc.getFacade(s)) == null) continue;
            fp.getBoxes(bch, forLivingEntity);
        }
        return VoxelShapeCache.get(boxes);
    }

    private void invalidateShapes() {
        this.cachedShape = null;
        this.cachedCollisionShape = null;
        this.cachedCollisionShapeLiving = null;
    }
}

