/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.cells.ICellContainer;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.helpers.IPriorityHost;
import appeng.parts.automation.PlaneConnectionHelper;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.UpgradeablePart;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;

public abstract class AbstractFormationPlanePart<T extends IAEStack<T>>
extends UpgradeablePart
implements ICellContainer,
IPriorityHost,
IMEInventory<T> {
    private boolean wasActive = false;
    private int priority = 0;
    protected boolean blocked = false;
    private final PlaneConnectionHelper connectionHelper = new PlaneConnectionHelper(this);

    public AbstractFormationPlanePart(class_1799 is) {
        super(is);
    }

    protected abstract void updateHandler();

    @Override
    protected int getUpgradeSlots() {
        return 5;
    }

    @Override
    public void upgradesChanged() {
        this.updateHandler();
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        this.updateHandler();
        this.getHost().markForSave();
    }

    public void stateChanged() {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            this.updateHandler();
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        this.connectionHelper.getBoxes(bch);
    }

    public PlaneConnections getConnections() {
        return this.connectionHelper.getConnections();
    }

    @Override
    public void onNeighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
        if (pos.method_10093(this.getSide().getFacing()).equals((Object)neighbor)) {
            class_2586 te = this.getHost().getTile();
            AEPartLocation side = this.getSide();
            class_2338 tePos = te.method_11016().method_10093(side.getFacing());
            this.blocked = this.isBlocking(w, tePos);
        } else {
            this.connectionHelper.updateConnections();
        }
    }

    protected boolean isBlocking(class_1922 w, class_2338 pos) {
        return !w.method_8320(pos).method_26207().method_15800();
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    @Override
    public T extractItems(T request, Actionable mode, IActionSource src) {
        return null;
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out) {
        return out;
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.priority = data.method_10550("priority");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10569("priority", this.getPriority());
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.updateHandler();
    }

    @Override
    public void blinkCell(int slot) {
    }

    @Override
    public void saveChanges(ICellInventory<?> cell) {
    }
}

