/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.settings.TickRates;
import appeng.core.sync.packets.BlockTransitionEffectPacket;
import appeng.core.sync.packets.ItemTransitionEffectPacket;
import appeng.hooks.TickHandler;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.mixins.tags.BlockTagsAccessor;
import appeng.mixins.tags.ItemTagsAccessor;
import appeng.parts.BasicStatePart;
import appeng.parts.automation.PlaneConnectionHelper;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModels;
import appeng.util.FakePlayer;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3494;
import net.minecraft.class_3614;

public class AnnihilationPlanePart
extends BasicStatePart
implements IGridTickable,
IWorldCallable<TickRateModulation> {
    public static final class_2960 TAG_BLACKLIST = new class_2960("appliedenergistics2", "blacklisted/annihilation_plane");
    private static final class_3494.class_5123<class_2248> BLOCK_BLACKLIST = BlockTagsAccessor.register(TAG_BLACKLIST.toString());
    private static final class_3494.class_5123<class_1792> ITEM_BLACKLIST = ItemTagsAccessor.register(TAG_BLACKLIST.toString());
    private static final PlaneModels MODELS = new PlaneModels("part/annihilation_plane", "part/annihilation_plane_on");
    private final IActionSource mySrc = new MachineSource(this);
    private boolean isAccepting = true;
    private boolean breaking = false;
    private final PlaneConnectionHelper connectionHelper = new PlaneConnectionHelper(this);
    private static final class_1792[] SUPPORTED_HARVEST_TOOLS = new class_1792[]{class_1802.field_8556, class_1802.field_8377, class_1802.field_8250};

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public AnnihilationPlanePart(class_1799 is) {
        super(is);
    }

    @Override
    public TickRateModulation call(class_1937 world) {
        this.breaking = false;
        return this.breakBlock(true);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        if (bch.isBBCollision()) {
            bch.addBox(0.0, 0.0, 14.0, 16.0, 16.0, 15.5);
            return;
        }
        this.connectionHelper.getBoxes(bch);
    }

    public PlaneConnections getConnections() {
        return this.connectionHelper.getConnections();
    }

    @Override
    public void onNeighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
        if (pos.method_10093(this.getSide().getFacing()).equals((Object)neighbor)) {
            this.refresh();
        } else {
            this.connectionHelper.updateConnections();
        }
    }

    @Override
    public void onEntityCollision(class_1297 entity) {
        if (this.isAccepting && entity instanceof class_1542 && entity.method_5805() && Platform.isServer() && this.getProxy().isActive()) {
            boolean changed;
            class_1542 itemEntity = (class_1542)entity;
            if (AnnihilationPlanePart.isItemBlacklisted(itemEntity.method_6983().method_7909())) {
                return;
            }
            class_2338 pos = this.getTile().method_11016();
            int planePosX = pos.method_10263();
            int planePosY = pos.method_10264();
            int planePosZ = pos.method_10260();
            double posYMiddle = (entity.method_5829().field_1322 + entity.method_5829().field_1325) / 2.0;
            double entityPosX = entity.method_23317();
            double entityPosY = entity.method_23318();
            double entityPosZ = entity.method_23321();
            boolean captureX = entityPosX > (double)planePosX && entityPosX < (double)(planePosX + 1);
            boolean captureY = posYMiddle > (double)planePosY && posYMiddle < (double)(planePosY + 1);
            boolean captureZ = entityPosZ > (double)planePosZ && entityPosZ < (double)(planePosZ + 1);
            boolean capture = false;
            switch (this.getSide()) {
                case DOWN: {
                    capture = captureX && captureZ && entityPosY < (double)planePosY + 0.1;
                    break;
                }
                case UP: {
                    capture = captureX && captureZ && entityPosY > (double)planePosY + 0.9;
                    break;
                }
                case SOUTH: {
                    capture = captureX && captureY && entityPosZ > (double)planePosZ + 0.9;
                    break;
                }
                case NORTH: {
                    capture = captureX && captureY && entityPosZ < (double)planePosZ + 0.1;
                    break;
                }
                case EAST: {
                    capture = captureZ && captureY && entityPosX > (double)planePosX + 0.9;
                    break;
                }
                case WEST: {
                    capture = captureZ && captureY && entityPosX < (double)planePosX + 0.1;
                    break;
                }
            }
            if (capture && (changed = this.storeEntityItem(itemEntity))) {
                AppEng.instance().sendToAllNearExcept(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), 64.0, this.getTile().method_10997(), new ItemTransitionEffectPacket(entity.method_23317(), entity.method_23318(), entity.method_23321(), this.getSide().getOpposite()));
            }
        }
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    private boolean storeEntityItem(class_1542 entityItem) {
        if (entityItem.method_5805()) {
            IAEItemStack overflow = this.storeItemStack(entityItem.method_6983());
            return this.handleOverflow(entityItem, overflow);
        }
        return false;
    }

    private IAEItemStack storeItemStack(class_1799 item) {
        AEItemStack itemToStore = AEItemStack.fromItemStack(item);
        try {
            IStorageGrid storage = this.getProxy().getStorage();
            IEnergyGrid energy = this.getProxy().getEnergy();
            IAEItemStack overflow = Platform.poweredInsert(energy, storage.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)), itemToStore, this.mySrc);
            this.isAccepting = overflow == null;
            return overflow;
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    private boolean handleOverflow(class_1542 entityItem, IAEItemStack overflow) {
        int newStackSize;
        if (overflow == null || overflow.getStackSize() == 0L) {
            entityItem.method_5650();
            return true;
        }
        int oldStackSize = entityItem.method_6983().method_7947();
        boolean changed = oldStackSize != (newStackSize = (int)overflow.getStackSize());
        entityItem.method_6983().method_7939(newStackSize);
        return changed;
    }

    @Override
    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.refresh();
        this.getHost().markForUpdate();
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.refresh();
        this.getHost().markForUpdate();
    }

    private TickRateModulation breakBlock(boolean modulate) {
        if (this.isAccepting && this.getProxy().isActive()) {
            try {
                class_2586 te = this.getTile();
                class_3218 w = (class_3218)te.method_10997();
                class_2338 pos = te.method_11016().method_10093(this.getSide().getFacing());
                IEnergyGrid energy = this.getProxy().getEnergy();
                class_2680 blockState = w.method_8320(pos);
                if (this.canHandleBlock(w, pos, blockState)) {
                    List<class_1799> items = this.obtainBlockDrops(w, pos);
                    float requiredPower = this.calculateEnergyUsage(w, pos, items);
                    boolean hasPower = energy.extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG) > (double)requiredPower - 0.1;
                    boolean canStore = this.canStoreItemStacks(items);
                    if (hasPower && canStore) {
                        if (modulate) {
                            this.performBreakBlock(w, pos, blockState, energy, requiredPower, items);
                        } else {
                            this.breaking = true;
                            TickHandler.instance().addCallable((class_1936)this.getTile().method_10997(), this);
                        }
                        return TickRateModulation.URGENT;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.IDLE;
    }

    private void performBreakBlock(class_3218 w, class_2338 pos, class_2680 blockState, IEnergyGrid energy, float requiredPower, List<class_1799> items) {
        if (!this.breakBlockAndStoreExtraItems(w, pos)) {
            return;
        }
        for (class_1799 item : items) {
            IAEItemStack overflow = this.storeItemStack(item);
            if (overflow == null) continue;
            Platform.spawnDrops((class_1937)w, pos, Collections.singletonList(overflow.createItemStack()));
        }
        energy.extractAEPower(requiredPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
        AppEng.instance().sendToAllNearExcept(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), 64.0, (class_1937)w, new BlockTransitionEffectPacket(pos, blockState, this.getSide().getOpposite(), BlockTransitionEffectPacket.SoundMode.NONE));
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.AnnihilationPlane.getMin(), TickRates.AnnihilationPlane.getMax(), false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.breaking) {
            return TickRateModulation.URGENT;
        }
        this.isAccepting = true;
        return this.breakBlock(false);
    }

    private boolean canHandleBlock(class_3218 w, class_2338 pos, class_2680 state) {
        if (state.method_26215()) {
            return false;
        }
        if (AnnihilationPlanePart.isBlockBlacklisted(state.method_26204())) {
            return false;
        }
        class_3614 material = state.method_26207();
        float hardness = state.method_26214((class_1922)w, pos);
        boolean ignoreMaterials = material == class_3614.field_15959 || material == class_3614.field_15922 || material == class_3614.field_15920 || material.method_15797();
        return !ignoreMaterials && hardness >= 0.0f && w.method_22340(pos) && w.method_8505((class_1657)FakePlayer.getOrCreate(w), pos);
    }

    protected List<class_1799> obtainBlockDrops(class_3218 w, class_2338 pos) {
        FakePlayer fakePlayer = FakePlayer.getOrCreate(w);
        class_2680 state = w.method_8320(pos);
        class_1799 harvestTool = this.createHarvestTool(state);
        if (harvestTool == null) {
            if (!state.method_29291()) {
                harvestTool = class_1799.field_8037;
            } else {
                return Collections.emptyList();
            }
        }
        class_2586 te = w.method_8321(pos);
        return class_2248.method_9609((class_2680)state, (class_3218)w, (class_2338)pos, (class_2586)te, (class_1297)fakePlayer, (class_1799)harvestTool);
    }

    protected float calculateEnergyUsage(class_3218 w, class_2338 pos, List<class_1799> items) {
        class_2680 state = w.method_8320(pos);
        float hardness = state.method_26214((class_1922)w, pos);
        float requiredEnergy = 1.0f + hardness;
        for (class_1799 is : items) {
            requiredEnergy += (float)is.method_7947();
        }
        return requiredEnergy;
    }

    private boolean canStoreItemStacks(List<class_1799> itemStacks) {
        boolean canStore = itemStacks.isEmpty();
        try {
            IStorageGrid storage = this.getProxy().getStorage();
            for (class_1799 itemStack : itemStacks) {
                AEItemStack itemToTest = AEItemStack.fromItemStack(itemStack);
                IAEItemStack overflow = storage.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)).injectItems(itemToTest, Actionable.SIMULATE, this.mySrc);
                if (overflow != null && itemToTest.getStackSize() <= overflow.getStackSize()) continue;
                canStore = true;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.isAccepting = canStore;
        return canStore;
    }

    private boolean breakBlockAndStoreExtraItems(class_3218 w, class_2338 pos) {
        if (!w.method_22352(pos, false)) {
            return false;
        }
        class_238 box = new class_238(pos).method_1014(0.2);
        for (Object ei : w.method_8390(class_1542.class, box, null)) {
            if (!(ei instanceof class_1542)) continue;
            class_1542 entityItem = (class_1542)ei;
            this.storeEntityItem(entityItem);
        }
        return true;
    }

    private void refresh() {
        this.isAccepting = true;
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    @Nullable
    public Object getModelData() {
        return this.getConnections();
    }

    protected class_1799 createHarvestTool(class_2680 state) {
        for (class_1792 toolItem : SUPPORTED_HARVEST_TOOLS) {
            if (!toolItem.method_7856(state)) continue;
            return new class_1799((class_1935)toolItem);
        }
        return null;
    }

    public static boolean isBlockBlacklisted(class_2248 b) {
        return BLOCK_BLACKLIST.method_15141((Object)b);
    }

    public static boolean isItemBlacklisted(class_1792 i) {
        return ITEM_BLACKLIST.method_15141((Object)i);
    }
}

