/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.FormationPlaneContainer;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.hooks.AECustomEntityItem;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.automation.AbstractFormationPlanePart;
import appeng.parts.automation.PlaneModels;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.FakePlayer;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.PrecisePriorityList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3917;
import net.minecraft.class_3965;

public class FormationPlanePart
extends AbstractFormationPlanePart<IAEItemStack> {
    private static final PlaneModels MODELS = new PlaneModels("part/formation_plane", "part/formation_plane_on");
    private static final Random RANDOM_OFFSET = new Random();
    private final MEInventoryHandler<IAEItemStack> myHandler = new MEInventoryHandler<IAEItemStack>(this, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
    private final AppEngInternalAEInventory Config = new AppEngInternalAEInventory(this, 63);

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public FormationPlanePart(class_1799 is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.PLACE_BLOCK, YesNo.YES);
        this.updateHandler();
    }

    @Override
    protected void updateHandler() {
        this.myHandler.setBaseAccess(AccessRestriction.WRITE);
        this.myHandler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        this.myHandler.setPriority(this.getPriority());
        IItemList<IAEItemStack> priorityList = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
        for (int x = 0; x < this.Config.getSlotCount() && x < slotsToUse; ++x) {
            IAEItemStack is = this.Config.getAEStackInSlot(x);
            if (is == null) continue;
            priorityList.add(is);
        }
        if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            this.myHandler.setPartitionList(new FuzzyPriorityList(priorityList, (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE)));
        } else {
            this.myHandler.setPartitionList(new PrecisePriorityList(priorityList));
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removedStack, class_1799 newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.Config) {
            this.updateHandler();
        }
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.Config.readFromNBT(data, "config");
        this.updateHandler();
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        this.Config.writeToNBT(data, "config");
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.Config;
        }
        return super.getInventoryByName(name);
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.stateChanged();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged changedChannels) {
        this.stateChanged();
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isServer()) {
            ContainerOpener.openContainer(FormationPlaneContainer.TYPE, player, ContainerLocator.forPart(this));
        }
        return true;
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (this.getProxy().isActive() && channel == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            ArrayList<IMEInventoryHandler> handler = new ArrayList<IMEInventoryHandler>(1);
            handler.add(this.myHandler);
            return handler;
        }
        return Collections.emptyList();
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
        if (this.blocked || input == null || input.getStackSize() <= 0L) {
            return input;
        }
        YesNo placeBlock = (YesNo)this.getConfigManager().getSetting(Settings.PLACE_BLOCK);
        class_1799 is = input.createItemStack();
        class_1792 i = is.method_7909();
        long maxStorage = Math.min(input.getStackSize(), (long)is.method_7914());
        boolean worked = false;
        class_2586 te = this.getHost().getTile();
        class_1937 w = te.method_10997();
        if (!(w instanceof class_3218)) {
            return input;
        }
        class_3218 serverWorld = (class_3218)w;
        AEPartLocation side = this.getSide();
        class_2338 placePos = te.method_11016().method_10093(side.getFacing());
        if (w.method_8320(placePos).method_26207().method_15800()) {
            if (placeBlock == YesNo.YES) {
                FakePlayer player = FakePlayer.getOrCreate(serverWorld);
                Platform.configurePlayer((class_1657)player, side, this.getTile());
                maxStorage = is.method_7947();
                worked = true;
                if (type == Actionable.MODULATE) {
                    class_2350 lookDirection = side.getFacing();
                    PlaneDirectionalPlaceContext context = new PlaneDirectionalPlaceContext(w, (class_1657)player, placePos, lookDirection, is, lookDirection.method_10153());
                    i.method_7884((class_1838)context);
                    maxStorage -= (long)is.method_7947();
                } else {
                    maxStorage = 1L;
                }
            } else {
                int sum = this.countEntitesAround(w, placePos);
                if (sum < AEConfig.instance().getFormationPlaneEntityLimit()) {
                    worked = true;
                    if (type == Actionable.MODULATE) {
                        is.method_7939((int)maxStorage);
                        if (!FormationPlanePart.spawnItemEntity(serverWorld, te, side, is)) {
                            worked = false;
                        }
                    }
                }
            }
        }
        boolean bl = this.blocked = !w.method_8320(placePos).method_26207().method_15800();
        if (worked) {
            IAEItemStack out = input.copy();
            out.decStackSize(maxStorage);
            if (out.getStackSize() == 0L) {
                return null;
            }
            return out;
        }
        return input;
    }

    private static boolean spawnItemEntity(class_3218 w, class_2586 te, AEPartLocation side, class_1799 is) {
        class_1297 result;
        double centerX = (double)te.method_11016().method_10263() + 0.5;
        double centerY = te.method_11016().method_10264();
        double centerZ = (double)te.method_11016().method_10260() + 0.5;
        class_1542 entity = new class_1542((class_1937)w, centerX, centerY, centerZ, is.method_7972());
        if (is.method_7909() instanceof AECustomEntityItem && (result = ((AECustomEntityItem)is.method_7909()).replaceItemEntity(w, entity, is)) != entity) {
            entity.method_5650();
            entity = result;
        }
        double additionalYOffset = side.yOffset == -1 ? (double)(1.0f - entity.method_17682()) : 0.0;
        double spawnAreaHeight = Math.max(0.0f, 1.0f - entity.method_17682());
        double spawnAreaWidth = Math.max(0.0f, 1.0f - entity.method_17681());
        double offsetX = side.xOffset == 0 ? (double)RANDOM_OFFSET.nextFloat() * spawnAreaWidth - spawnAreaWidth / 2.0 : (double)side.xOffset * (0.525 + (double)(entity.method_17681() / 2.0f));
        double offsetY = side.yOffset == 0 ? (double)RANDOM_OFFSET.nextFloat() * spawnAreaHeight : (double)side.yOffset + additionalYOffset;
        double offsetZ = side.zOffset == 0 ? (double)RANDOM_OFFSET.nextFloat() * spawnAreaWidth - spawnAreaWidth / 2.0 : (double)side.zOffset * (0.525 + (double)(entity.method_17681() / 2.0f));
        double absoluteX = centerX + offsetX;
        double absoluteY = centerY + offsetY;
        double absoluteZ = centerZ + offsetZ;
        entity.method_5814(absoluteX, absoluteY, absoluteZ);
        entity.method_18800((double)side.xOffset * 0.1, (double)side.yOffset * 0.1, (double)side.zOffset * 0.1);
        if (!w.method_8649((class_1297)entity)) {
            entity.method_5650();
            return false;
        }
        return true;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    public Object getModelData() {
        return this.getConnections();
    }

    @Override
    public class_1799 getItemStackRepresentation() {
        return Api.instance().definitions().parts().formationPlane().maybeStack(1).orElse(class_1799.field_8037);
    }

    @Override
    public class_3917<?> getContainerType() {
        return FormationPlaneContainer.TYPE;
    }

    private int countEntitesAround(class_1937 world, class_2338 pos) {
        class_238 t = new class_238(pos).method_1014(8.0);
        List list = world.method_8390(class_1297.class, t, null);
        return list.size();
    }

    private static class PlaneDirectionalPlaceContext
    extends class_1750 {
        private final class_2350 lookDirection;

        public PlaneDirectionalPlaceContext(class_1937 world, class_1657 player, class_2338 pos, class_2350 lookDirection, class_1799 itemStack, class_2350 facing) {
            super(world, player, class_1268.field_5808, itemStack, new class_3965(class_243.method_24955((class_2382)pos), facing, pos, false));
            this.lookDirection = lookDirection;
        }

        public class_2338 method_8037() {
            return this.method_30344().method_17777();
        }

        public boolean method_7716() {
            return this.method_8045().method_8320(this.method_30344().method_17777()).method_26166((class_1750)this);
        }

        public class_2350 method_7715() {
            return class_2350.field_11033;
        }

        public class_2350[] method_7718() {
            switch (this.lookDirection) {
                default: {
                    return new class_2350[]{class_2350.field_11033, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036};
                }
                case field_11036: {
                    return new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
                }
                case field_11043: {
                    return new class_2350[]{class_2350.field_11033, class_2350.field_11043, class_2350.field_11034, class_2350.field_11039, class_2350.field_11036, class_2350.field_11035};
                }
                case field_11035: {
                    return new class_2350[]{class_2350.field_11033, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039, class_2350.field_11036, class_2350.field_11043};
                }
                case field_11039: {
                    return new class_2350[]{class_2350.field_11033, class_2350.field_11039, class_2350.field_11035, class_2350.field_11036, class_2350.field_11043, class_2350.field_11034};
                }
                case field_11034: 
            }
            return new class_2350[]{class_2350.field_11033, class_2350.field_11034, class_2350.field_11035, class_2350.field_11036, class_2350.field_11043, class_2350.field_11039};
        }

        public class_2350 method_8042() {
            return this.lookDirection.method_10166() == class_2350.class_2351.field_11052 ? class_2350.field_11043 : this.lookDirection;
        }

        public boolean method_8046() {
            return false;
        }

        public float method_8044() {
            return this.lookDirection.method_10161() * 90;
        }
    }
}

