/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.UpgradeableContainer;
import appeng.core.Api;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import appeng.parts.automation.SharedItemBusPart;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.item.AEItemStack;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class ImportBusPart
extends SharedItemBusPart
implements IInventoryDestination {
    public static final class_2960 MODEL_BASE = new class_2960("appliedenergistics2", "part/import_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/import_bus_off"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/import_bus_on"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/import_bus_has_channel"));
    private final IActionSource source;
    private int itemsToSend;
    private boolean worked;

    public ImportBusPart(class_1799 is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.source = new MachineSource(this);
    }

    @Override
    public boolean canInsert(class_1799 stack) {
        if (stack.method_7960() || stack.method_7909() == class_1802.field_8162) {
            return false;
        }
        try {
            IMEMonitor<IAEItemStack> inv = this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IAEItemStack out = (IAEItemStack)inv.injectItems((IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(stack), Actionable.SIMULATE, this.source);
            if (out == null) {
                return true;
            }
            return out.getStackSize() != (long)stack.method_7947();
        }
        catch (GridAccessException ex) {
            return false;
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isServer()) {
            ContainerOpener.openContainer(UpgradeableContainer.TYPE, player, ContainerLocator.forPart(this));
        }
        return true;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ImportBus.getMin(), TickRates.ImportBus.getMax(), this.isSleeping(), false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.getProxy().isActive() || !this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.worked = false;
        InventoryAdaptor myAdaptor = this.getHandler();
        FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
        if (myAdaptor != null) {
            try {
                this.itemsToSend = this.calculateItemsToSend();
                IMEMonitor<IAEItemStack> inv = this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
                IEnergyGrid energy = this.getProxy().getEnergy();
                boolean Configured = false;
                for (int x = 0; x < this.availableSlots(); ++x) {
                    IAEItemStack ais = this.getConfig().getAEStackInSlot(x);
                    if (ais == null || this.itemsToSend <= 0) continue;
                    Configured = true;
                    while (this.itemsToSend > 0 && !this.importStuff(myAdaptor, ais, inv, energy, fzMode)) {
                    }
                }
                if (!Configured) {
                    while (this.itemsToSend > 0) {
                        if (!this.importStuff(myAdaptor, null, inv, energy, fzMode)) continue;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            return TickRateModulation.SLEEP;
        }
        return this.worked ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    private boolean importStuff(InventoryAdaptor myAdaptor, IAEItemStack whatToImport, IMEMonitor<IAEItemStack> inv, IEnergySource energy, FuzzyMode fzMode) {
        int toSend = this.calculateMaximumAmountToImport(myAdaptor, whatToImport, inv, fzMode);
        class_1799 newItems = this.getInstalledUpgrades(Upgrades.FUZZY) > 0 ? myAdaptor.removeSimilarItems(toSend, whatToImport == null ? class_1799.field_8037 : whatToImport.getDefinition(), fzMode, this) : myAdaptor.removeItems(toSend, whatToImport == null ? class_1799.field_8037 : whatToImport.getDefinition(), this);
        if (!newItems.method_7960()) {
            IAEItemStack aeStack = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(newItems);
            IAEItemStack failed = Platform.poweredInsert(energy, inv, aeStack, this.source);
            if (failed != null) {
                IAEItemStack spill = inv.injectItems(failed, Actionable.MODULATE, this.source);
                if (spill != null) {
                    myAdaptor.addItems(spill.createItemStack());
                }
                return true;
            }
            this.itemsToSend -= newItems.method_7947();
        } else {
            return true;
        }
        this.worked = true;
        return false;
    }

    private int calculateMaximumAmountToImport(InventoryAdaptor myAdaptor, IAEItemStack whatToImport, IMEMonitor<IAEItemStack> inv, FuzzyMode fzMode) {
        IAEItemStack itemAmountNotStorable;
        class_1799 simResult;
        int toSend = Math.min(this.itemsToSend, 64);
        class_1799 itemStackToImport = whatToImport == null ? class_1799.field_8037 : whatToImport.getDefinition();
        if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            simResult = myAdaptor.simulateSimilarRemove(toSend, itemStackToImport, fzMode, this);
            itemAmountNotStorable = inv.injectItems(AEItemStack.fromItemStack(simResult), Actionable.SIMULATE, this.source);
        } else {
            simResult = myAdaptor.simulateRemove(toSend, itemStackToImport, this);
            itemAmountNotStorable = inv.injectItems(AEItemStack.fromItemStack(simResult), Actionable.SIMULATE, this.source);
        }
        if (itemAmountNotStorable != null) {
            return (int)Math.min((long)simResult.method_7947() - itemAmountNotStorable.getStackSize(), (long)toSend);
        }
        return toSend;
    }

    @Override
    protected boolean isSleeping() {
        return this.getHandler() == null || super.isSleeping();
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

