/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyWatcher;
import appeng.api.networking.energy.IEnergyWatcherHost;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.LevelEmitterContainer;
import appeng.core.Api;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.PartModel;
import appeng.parts.automation.UpgradeablePart;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import java.util.Collection;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class LevelEmitterPart
extends UpgradeablePart
implements IEnergyWatcherHost,
IStackWatcherHost,
ICraftingWatcherHost,
IMEMonitorHandlerReceiver<IAEItemStack>,
ICraftingProvider {
    @PartModels
    public static final class_2960 MODEL_BASE_OFF = new class_2960("appliedenergistics2", "part/level_emitter_base_off");
    @PartModels
    public static final class_2960 MODEL_BASE_ON = new class_2960("appliedenergistics2", "part/level_emitter_base_on");
    @PartModels
    public static final class_2960 MODEL_STATUS_OFF = new class_2960("appliedenergistics2", "part/level_emitter_status_off");
    @PartModels
    public static final class_2960 MODEL_STATUS_ON = new class_2960("appliedenergistics2", "part/level_emitter_status_on");
    @PartModels
    public static final class_2960 MODEL_STATUS_HAS_CHANNEL = new class_2960("appliedenergistics2", "part/level_emitter_status_has_channel");
    public static final PartModel MODEL_OFF_OFF = new PartModel(MODEL_BASE_OFF, MODEL_STATUS_OFF);
    public static final PartModel MODEL_OFF_ON = new PartModel(MODEL_BASE_OFF, MODEL_STATUS_ON);
    public static final PartModel MODEL_OFF_HAS_CHANNEL = new PartModel(MODEL_BASE_OFF, MODEL_STATUS_HAS_CHANNEL);
    public static final PartModel MODEL_ON_OFF = new PartModel(MODEL_BASE_ON, MODEL_STATUS_OFF);
    public static final PartModel MODEL_ON_ON = new PartModel(MODEL_BASE_ON, MODEL_STATUS_ON);
    public static final PartModel MODEL_ON_HAS_CHANNEL = new PartModel(MODEL_BASE_ON, MODEL_STATUS_HAS_CHANNEL);
    private static final int FLAG_ON = 4;
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 1);
    private boolean prevState = false;
    private long lastReportedValue = 0L;
    private long reportingValue = 0L;
    private IStackWatcher myWatcher;
    private IEnergyWatcher myEnergyWatcher;
    private ICraftingWatcher myCraftingWatcher;
    private double centerX;
    private double centerY;
    private double centerZ;

    public LevelEmitterPart(class_1799 is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_EMITTER, RedstoneMode.HIGH_SIGNAL);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.LEVEL_TYPE, LevelType.ITEM_LEVEL);
        this.getConfigManager().registerSetting(Settings.CRAFT_VIA_REDSTONE, YesNo.NO);
    }

    public long getReportingValue() {
        return this.reportingValue;
    }

    public void setReportingValue(long v) {
        this.reportingValue = v;
        if (this.getConfigManager().getSetting(Settings.LEVEL_TYPE) == LevelType.ENERGY_LEVEL) {
            this.configureWatchers();
        } else {
            this.updateState();
        }
    }

    @MENetworkEventSubscribe
    public void powerChanged(MENetworkPowerStatusChange c) {
        this.updateState();
    }

    private void updateState() {
        boolean isOn = this.isLevelEmitterOn();
        if (this.prevState != isOn) {
            this.getHost().markForUpdate();
            class_2586 te = this.getHost().getTile();
            this.prevState = isOn;
            Platform.notifyBlocksOfNeighbors(te.method_10997(), te.method_11016());
            Platform.notifyBlocksOfNeighbors(te.method_10997(), te.method_11016().method_10093(this.getSide().getFacing()));
        }
    }

    public boolean isLevelEmitterOn() {
        boolean flipState;
        if (Platform.isClient()) {
            return (this.getClientFlags() & 4) == 4;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0) {
            try {
                return this.getProxy().getCrafting().isRequesting(this.config.getAEStackInSlot(0));
            }
            catch (GridAccessException gridAccessException) {
                return this.prevState;
            }
        }
        boolean bl = flipState = this.getConfigManager().getSetting(Settings.REDSTONE_EMITTER) == RedstoneMode.LOW_SIGNAL;
        return flipState ? this.reportingValue >= this.lastReportedValue + 1L : this.reportingValue < this.lastReportedValue + 1L;
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelsChanged c) {
        this.updateState();
    }

    @Override
    protected int populateFlags(int cf) {
        return cf | (this.prevState ? 4 : 0);
    }

    @Override
    public void updateWatcher(ICraftingWatcher newWatcher) {
        this.myCraftingWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onRequestChange(ICraftingGrid craftingGrid, IAEItemStack what) {
        this.updateState();
    }

    private void configureWatchers() {
        IAEItemStack myStack = this.config.getAEStackInSlot(0);
        if (this.myWatcher != null) {
            this.myWatcher.reset();
        }
        if (this.myEnergyWatcher != null) {
            this.myEnergyWatcher.reset();
        }
        if (this.myCraftingWatcher != null) {
            this.myCraftingWatcher.reset();
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.getProxy().getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0) {
            if (this.myCraftingWatcher != null && myStack != null) {
                this.myCraftingWatcher.add(myStack);
            }
            return;
        }
        if (this.getConfigManager().getSetting(Settings.LEVEL_TYPE) == LevelType.ENERGY_LEVEL) {
            if (this.myEnergyWatcher != null) {
                this.myEnergyWatcher.add(this.reportingValue);
            }
            try {
                this.lastReportedValue = (long)this.getProxy().getEnergy().getStoredPower();
                this.updateState();
                this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)).removeListener(this);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return;
        }
        try {
            if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0 || myStack == null) {
                this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)).addListener(this, this.getProxy().getGrid());
            } else {
                this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)).removeListener(this);
                if (this.myWatcher != null) {
                    this.myWatcher.add(myStack);
                }
            }
            this.updateReportingValue(this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateReportingValue(IMEMonitor<IAEItemStack> monitor) {
        IAEItemStack myStack = this.config.getAEStackInSlot(0);
        if (myStack == null) {
            this.lastReportedValue = 0L;
            for (IAEItemStack st : monitor.getStorageList()) {
                this.lastReportedValue += st.getStackSize();
            }
        } else if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            this.lastReportedValue = 0L;
            FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
            Collection<IAEItemStack> fuzzyList = monitor.getStorageList().findFuzzy(myStack, fzMode);
            for (IAEItemStack st : fuzzyList) {
                this.lastReportedValue += st.getStackSize();
            }
        } else {
            IAEItemStack r = monitor.getStorageList().findPrecise(myStack);
            this.lastReportedValue = r == null ? 0L : r.getStackSize();
        }
        this.updateState();
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, IActionSource src, IStorageChannel chan) {
        if (chan == Api.instance().storage().getStorageChannel(IItemStorageChannel.class) && fullStack.equals(this.config.getAEStackInSlot(0)) && this.getInstalledUpgrades(Upgrades.FUZZY) == 0) {
            this.lastReportedValue = fullStack.getStackSize();
            this.updateState();
        }
    }

    @Override
    public void updateWatcher(IEnergyWatcher newWatcher) {
        this.myEnergyWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onThresholdPass(IEnergyGrid energyGrid) {
        this.lastReportedValue = (long)energyGrid.getStoredPower();
        this.updateState();
    }

    @Override
    public boolean isValid(Object effectiveGrid) {
        try {
            return this.getProxy().getGrid() == effectiveGrid;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, IActionSource actionSource) {
        this.updateReportingValue((IMEMonitor)monitor);
    }

    @Override
    public void onListUpdate() {
        try {
            this.updateReportingValue(this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    public int isProvidingStrongPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    public void randomDisplayTick(class_1937 world, class_2338 pos, Random r) {
        if (this.isLevelEmitterOn()) {
            AEPartLocation d = this.getSide();
            double d0 = (double)((float)d.xOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)d.yOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)d.zOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.method_8406((class_2394)class_2390.field_11188, 0.5 + (double)pos.method_10263() + d0, 0.5 + (double)pos.method_10264() + d1, 0.5 + (double)pos.method_10260() + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 16.0f;
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isServer()) {
            ContainerOpener.openContainer(LevelEmitterContainer.TYPE, player, ContainerLocator.forPart(this));
        }
        return true;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        this.configureWatchers();
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removedStack, class_1799 newStack) {
        if (inv == this.config) {
            this.configureWatchers();
        }
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
    }

    @Override
    public void upgradesChanged() {
        this.configureWatchers();
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.lastReportedValue = data.method_10537("lastReportedValue");
        this.reportingValue = data.method_10537("reportingValue");
        this.prevState = data.method_10577("prevState");
        this.config.readFromNBT(data, "config");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10544("lastReportedValue", this.lastReportedValue);
        data.method_10544("reportingValue", this.reportingValue);
        data.method_10556("prevState", this.prevState);
        this.config.writeToNBT(data, "config");
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, class_1715 table) {
        return false;
    }

    @Override
    public boolean isBusy() {
        return true;
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        IAEItemStack what;
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0 && this.getConfigManager().getSetting(Settings.CRAFT_VIA_REDSTONE) == YesNo.YES && (what = this.config.getAEStackInSlot(0)) != null) {
            craftingTracker.setEmitable(what);
        }
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_HAS_CHANNEL : MODEL_OFF_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_ON : MODEL_OFF_ON;
        }
        return this.isLevelEmitterOn() ? MODEL_ON_OFF : MODEL_OFF_OFF;
    }
}

