/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.me.GridAccessException;
import appeng.parts.automation.UpgradeablePart;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.InventoryAdaptor;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;

public abstract class SharedItemBusPart
extends UpgradeablePart
implements IGridTickable {
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 9);
    private boolean lastRedstone = false;

    public SharedItemBusPart(class_1799 is) {
        super(is);
    }

    @Override
    public void upgradesChanged() {
        this.updateState();
    }

    @Override
    public void readFromNBT(class_2487 extra) {
        super.readFromNBT(extra);
        this.getConfig().readFromNBT(extra, "config");
    }

    @Override
    public void writeToNBT(class_2487 extra) {
        super.writeToNBT(extra);
        this.getConfig().writeToNBT(extra, "config");
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.getConfig();
        }
        return super.getInventoryByName(name);
    }

    @Override
    public void onNeighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
        this.updateState();
        if (this.lastRedstone != this.getHost().hasRedstone(this.getSide())) {
            boolean bl = this.lastRedstone = !this.lastRedstone;
            if (this.lastRedstone && this.getRSMode() == RedstoneMode.SIGNAL_PULSE) {
                this.doBusWork();
            }
        }
    }

    protected InventoryAdaptor getHandler() {
        class_2586 self = this.getHost().getTile();
        class_2586 target = this.getBlockEntity(self, self.method_11016().method_10093(this.getSide().getFacing()));
        return InventoryAdaptor.getAdaptor(target, this.getSide().getFacing().method_10153());
    }

    private class_2586 getBlockEntity(class_2586 self, class_2338 pos) {
        class_1937 w = self.method_10997();
        if (w.method_8398().method_20529(pos)) {
            return w.method_8321(pos);
        }
        return null;
    }

    protected int availableSlots() {
        return Math.min(1 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 4, this.getConfig().getSlotCount());
    }

    protected int calculateItemsToSend() {
        switch (this.getInstalledUpgrades(Upgrades.SPEED)) {
            default: {
                return 1;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 64;
            }
            case 4: 
        }
        return 96;
    }

    protected boolean canDoBusWork() {
        class_2586 self = this.getHost().getTile();
        class_2338 selfPos = self.method_11016().method_10093(this.getSide().getFacing());
        class_1937 world = self.method_10997();
        return world != null && world.method_8398().method_20529(selfPos);
    }

    private void updateState() {
        try {
            if (!this.isSleeping()) {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            } else {
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected abstract TickRateModulation doBusWork();

    AppEngInternalAEInventory getConfig() {
        return this.config;
    }
}

