/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.misc;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.me.GridAccessException;
import appeng.me.helpers.IGridProxyable;
import appeng.me.storage.ITickingMonitor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;

class ItemHandlerAdapter
implements IMEInventory<IAEItemStack>,
IBaseMonitor<IAEItemStack>,
ITickingMonitor {
    private final Map<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object>();
    private IActionSource mySource;
    private final FixedItemInv itemHandler;
    private final IGridProxyable proxyable;
    private final InventoryCache cache;

    ItemHandlerAdapter(FixedItemInv itemHandler, IGridProxyable proxy) {
        this.itemHandler = itemHandler;
        this.proxyable = proxy;
        this.cache = new InventoryCache(this.itemHandler);
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack iox, Actionable type, IActionSource src) {
        class_1799 orgInput;
        class_1799 remaining = orgInput = iox.createItemStack();
        int slotCount = this.itemHandler.getSlotCount();
        boolean simulate = type == Actionable.SIMULATE;
        for (int i = 0; i < slotCount && !remaining.method_7960(); ++i) {
            remaining = this.itemHandler.getSlot(i).attemptInsertion(remaining, simulate ? Simulation.SIMULATE : Simulation.ACTION);
        }
        if (remaining == orgInput) {
            return iox;
        }
        if (type == Actionable.MODULATE) {
            try {
                this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return AEItemStack.fromItemStack(remaining);
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
        class_1799 requestedItemStack = request.createItemStack();
        int remainingSize = requestedItemStack.method_7947();
        class_1799 gathered = class_1799.field_8037;
        boolean simulate = mode == Actionable.SIMULATE;
        for (int i = 0; i < this.itemHandler.getSlotCount(); ++i) {
            class_1799 extracted;
            class_1799 stackInInventorySlot = this.itemHandler.getInvStack(i);
            if (!Platform.itemComparisons().isSameItem(stackInInventorySlot, requestedItemStack)) continue;
            int stackSizeCurrentSlot = stackInInventorySlot.method_7947();
            int remainingCurrentSlot = Math.min(remainingSize, stackSizeCurrentSlot);
            do {
                if ((extracted = this.itemHandler.getSlot(i).attemptAnyExtraction(remainingCurrentSlot, simulate ? Simulation.SIMULATE : Simulation.ACTION)).method_7960()) continue;
                if (extracted == stackInInventorySlot) {
                    extracted = extracted.method_7972();
                }
                if (extracted.method_7947() > remainingCurrentSlot) {
                    AELog.warn("Mod that provided item handler %s is broken. Returned %s items while only requesting %d.", this.itemHandler.getClass().getName(), extracted.toString(), remainingCurrentSlot);
                    extracted.method_7939(remainingCurrentSlot);
                }
                if (simulate && extracted.method_7947() == extracted.method_7914() && remainingCurrentSlot > extracted.method_7914()) {
                    extracted.method_7939(remainingCurrentSlot);
                }
                if (gathered.method_7960()) {
                    gathered = extracted;
                } else {
                    gathered.method_7933(extracted.method_7947());
                }
                remainingCurrentSlot -= extracted.method_7947();
            } while (!simulate && !extracted.method_7960() && remainingCurrentSlot > 0);
            if ((remainingSize -= stackSizeCurrentSlot - remainingCurrentSlot) <= 0) break;
        }
        if (!gathered.method_7960()) {
            if (mode == Actionable.MODULATE) {
                try {
                    this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
            return AEItemStack.fromItemStack(gathered);
        }
        return null;
    }

    @Override
    public TickRateModulation onTick() {
        List<IAEItemStack> changes = this.cache.update();
        if (!changes.isEmpty()) {
            this.postDifference(changes);
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    public void setActionSource(IActionSource mySource) {
        this.mySource = mySource;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        return this.cache.getAvailableItems(out);
    }

    public IItemStorageChannel getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    private void postDifference(Iterable<IAEItemStack> a) {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> l = i.next();
            IMEMonitorHandlerReceiver<IAEItemStack> key = l.getKey();
            if (key.isValid(l.getValue())) {
                key.postChange(this, a, this.mySource);
                continue;
            }
            i.remove();
        }
    }

    private static class InventoryCache {
        private IAEItemStack[] cachedAeStacks = new IAEItemStack[0];
        private final FixedItemInv itemHandler;

        public InventoryCache(FixedItemInv itemHandler) {
            this.itemHandler = itemHandler;
        }

        public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
            Arrays.stream(this.cachedAeStacks).forEach(out::add);
            return out;
        }

        public List<IAEItemStack> update() {
            int slot;
            ArrayList<IAEItemStack> changes = new ArrayList<IAEItemStack>();
            int slots = this.itemHandler.getSlotCount();
            if (slots > this.cachedAeStacks.length) {
                this.cachedAeStacks = Arrays.copyOf(this.cachedAeStacks, slots);
            }
            for (slot = 0; slot < slots; ++slot) {
                IAEItemStack oldAeIS = this.cachedAeStacks[slot];
                class_1799 newIS = this.itemHandler.getInvStack(slot);
                this.handlePossibleSlotChanges(slot, oldAeIS, newIS, changes);
            }
            if (slots < this.cachedAeStacks.length) {
                for (slot = slots; slot < this.cachedAeStacks.length; ++slot) {
                    IAEItemStack aeStack = this.cachedAeStacks[slot];
                    if (aeStack == null) continue;
                    IAEItemStack a = aeStack.copy();
                    a.setStackSize(-a.getStackSize());
                    changes.add(a);
                }
                this.cachedAeStacks = Arrays.copyOf(this.cachedAeStacks, slots);
            }
            return changes;
        }

        private void handlePossibleSlotChanges(int slot, IAEItemStack oldAeIS, class_1799 newIS, List<IAEItemStack> changes) {
            if (oldAeIS != null && oldAeIS.isSameType(newIS)) {
                this.handleStackSizeChanged(slot, oldAeIS, newIS, changes);
            } else {
                this.handleItemChanged(slot, oldAeIS, newIS, changes);
            }
        }

        private void handleStackSizeChanged(int slot, IAEItemStack oldAeIS, class_1799 newIS, List<IAEItemStack> changes) {
            long diff = (long)newIS.method_7947() - oldAeIS.getStackSize();
            if (diff != 0L) {
                IAEItemStack stack = oldAeIS.copy();
                stack.setStackSize(newIS.method_7947());
                this.cachedAeStacks[slot] = stack;
                IAEItemStack a = stack.copy();
                a.setStackSize(diff);
                changes.add(a);
            }
        }

        private void handleItemChanged(int slot, IAEItemStack oldAeIS, class_1799 newIS, List<IAEItemStack> changes) {
            this.cachedAeStacks[slot] = AEItemStack.fromItemStack(newIS);
            if (oldAeIS != null) {
                oldAeIS.setStackSize(-oldAeIS.getStackSize());
                changes.add(oldAeIS);
            }
            if (this.cachedAeStacks[slot] != null) {
                changes.add(this.cachedAeStacks[slot]);
            }
        }
    }
}

