/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.misc;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.ItemAttributes;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.cells.ICellContainer;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.attributes.MEAttributes;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.StorageBusContainer;
import appeng.core.Api;
import appeng.core.settings.TickRates;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.ITickingMonitor;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.MEMonitorIInventory;
import appeng.parts.PartModel;
import appeng.parts.automation.UpgradeablePart;
import appeng.parts.misc.ItemHandlerAdapter;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.PrecisePriorityList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3917;

public class StorageBusPart
extends UpgradeablePart
implements IGridTickable,
ICellContainer,
IMEMonitorHandlerReceiver<IAEItemStack>,
IPriorityHost {
    public static final class_2960 MODEL_BASE = new class_2960("appliedenergistics2", "part/storage_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/storage_bus_off"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/storage_bus_on"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/storage_bus_has_channel"));
    private final IActionSource mySrc;
    private final AppEngInternalAEInventory Config = new AppEngInternalAEInventory(this, 63);
    private int priority = 0;
    private boolean cached = false;
    private ITickingMonitor monitor = null;
    private MEInventoryHandler<IAEItemStack> handler = null;
    private int handlerHash = 0;
    private boolean wasActive = false;
    private byte resetCacheLogic = 0;

    public StorageBusPart(class_1799 is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.mySrc = new MachineSource(this);
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.updateStatus();
    }

    private void updateStatus() {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
                this.getHost().markForUpdate();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged changedChannels) {
        this.updateStatus();
    }

    @Override
    protected int getUpgradeSlots() {
        return 5;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        this.resetCache(true);
        this.getHost().markForSave();
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removedStack, class_1799 newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.Config) {
            this.resetCache(true);
        }
    }

    @Override
    public void upgradesChanged() {
        super.upgradesChanged();
        this.resetCache(true);
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.Config.readFromNBT(data, "config");
        this.priority = data.method_10550("priority");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        this.Config.writeToNBT(data, "config");
        data.method_10569("priority", this.priority);
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.Config;
        }
        return super.getInventoryByName(name);
    }

    private void resetCache(boolean fullReset) {
        if (this.getHost() == null || this.getHost().getTile() == null || this.getHost().getTile().method_10997() == null || this.getHost().getTile().method_10997().field_9236) {
            return;
        }
        this.resetCacheLogic = fullReset ? (byte)2 : (byte)1;
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return this.handler == verificationToken;
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, IActionSource source) {
        try {
            if (this.getProxy().isActive()) {
                this.getProxy().getStorage().postAlterationOfStoredItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class), change, this.mySrc);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void onListUpdate() {
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    public void onNeighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
        if (pos.method_10093(this.getSide().getFacing()).equals((Object)neighbor)) {
            class_2586 te = w.method_8321(neighbor);
            if (te == null) {
                this.resetCache(true);
                this.resetCache();
            } else {
                this.resetCache(false);
            }
        }
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isServer()) {
            ContainerOpener.openContainer(StorageBusContainer.TYPE, player, ContainerLocator.forPart(this));
        }
        return true;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.StorageBus.getMin(), TickRates.StorageBus.getMax(), this.monitor == null, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.resetCacheLogic != 0) {
            this.resetCache();
        }
        if (this.monitor != null) {
            return this.monitor.onTick();
        }
        return TickRateModulation.SLEEP;
    }

    private void resetCache() {
        MEInventoryHandler<IAEItemStack> out;
        boolean fullReset = this.resetCacheLogic == 2;
        this.resetCacheLogic = 0;
        MEInventoryHandler<IAEItemStack> in = this.getInternalHandler();
        IItemList before = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        if (in != null) {
            before = in.getAvailableItems(before);
        }
        this.cached = false;
        if (fullReset) {
            this.handlerHash = 0;
        }
        if (in != (out = this.getInternalHandler())) {
            IItemList after = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
            if (out != null) {
                after = out.getAvailableItems(after);
            }
            Platform.postListChanges(before, after, this, this.mySrc);
        }
    }

    private IMEInventory<IAEItemStack> getInventoryWrapper(class_2586 target) {
        class_2350 targetSide = this.getSide().getFacing().method_10153();
        IStorageMonitorableAccessor accessor = this.getMeAccessor(target, targetSide);
        if (accessor != null) {
            IStorageMonitorable inventory = accessor.getInventory(this.mySrc);
            if (inventory != null) {
                return inventory.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
            }
            return null;
        }
        FixedItemInv handlerExt = this.getFixedItemInv(target, targetSide);
        if (handlerExt != null) {
            return new ItemHandlerAdapter(handlerExt, this);
        }
        return null;
    }

    private int createHandlerHash(class_2586 target) {
        if (target == null) {
            return 0;
        }
        class_2350 targetSide = this.getSide().getFacing().method_10153();
        IStorageMonitorableAccessor accessor = this.getMeAccessor(target, targetSide);
        if (accessor != null) {
            return Objects.hash(target, accessor);
        }
        FixedItemInv itemHandler = this.getFixedItemInv(target, targetSide);
        if (itemHandler != null) {
            return Objects.hash(target, itemHandler, itemHandler.getSlotCount());
        }
        return 0;
    }

    private FixedItemInv getFixedItemInv(class_2586 target, class_2350 targetSide) {
        return (FixedItemInv)MEAttributes.getFirstAttributeOnSide(ItemAttributes.FIXED_INV, target, targetSide);
    }

    private IStorageMonitorableAccessor getMeAccessor(class_2586 target, class_2350 targetSide) {
        return MEAttributes.getFirstAttributeOnSide(MEAttributes.STORAGE_MONITORABLE_ACCESSOR, target, targetSide);
    }

    public MEInventoryHandler<IAEItemStack> getInternalHandler() {
        if (this.cached) {
            return this.handler;
        }
        boolean wasSleeping = this.monitor == null;
        this.cached = true;
        class_2586 self = this.getHost().getTile();
        class_2586 target = self.method_10997().method_8321(self.method_11016().method_10093(this.getSide().getFacing()));
        int newHandlerHash = this.createHandlerHash(target);
        if (newHandlerHash != 0 && newHandlerHash == this.handlerHash) {
            return this.handler;
        }
        this.handlerHash = newHandlerHash;
        this.handler = null;
        this.monitor = null;
        if (target != null) {
            IMEInventory<IAEItemStack> inv = this.getInventoryWrapper(target);
            if (inv instanceof MEMonitorIInventory) {
                MEMonitorIInventory h = (MEMonitorIInventory)inv;
                h.setMode((StorageFilter)this.getConfigManager().getSetting(Settings.STORAGE_FILTER));
            }
            if (inv instanceof ITickingMonitor) {
                this.monitor = (ITickingMonitor)((Object)inv);
                this.monitor.setActionSource(new MachineSource(this));
            }
            if (inv != null) {
                this.checkInterfaceVsStorageBus(target, this.getSide().getOpposite());
                this.handler = new MEInventoryHandler<IAEItemStack>(inv, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
                this.handler.setBaseAccess((AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS));
                this.handler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
                this.handler.setPriority(this.priority);
                IItemList<IAEItemStack> priorityList = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
                int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
                for (int x = 0; x < this.Config.getSlotCount() && x < slotsToUse; ++x) {
                    IAEItemStack is = this.Config.getAEStackInSlot(x);
                    if (is == null) continue;
                    priorityList.add(is);
                }
                if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
                    this.handler.setPartitionList(new FuzzyPriorityList(priorityList, (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE)));
                } else {
                    this.handler.setPartitionList(new PrecisePriorityList(priorityList));
                }
                if (inv instanceof IBaseMonitor) {
                    ((IBaseMonitor)((Object)inv)).addListener(this, this.handler);
                }
            }
        }
        if (wasSleeping != (this.monitor == null)) {
            try {
                ITickManager tm = this.getProxy().getTick();
                if (this.monitor == null) {
                    tm.sleepDevice(this.getProxy().getNode());
                } else {
                    tm.wakeDevice(this.getProxy().getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return this.handler;
    }

    private void checkInterfaceVsStorageBus(class_2586 target, AEPartLocation side) {
        IPart part;
        IInterfaceHost achievement = null;
        if (target instanceof IInterfaceHost) {
            achievement = (IInterfaceHost)target;
        }
        if (target instanceof IPartHost && (part = ((IPartHost)target).getPart(side)) instanceof IInterfaceHost) {
            achievement = (IInterfaceHost)((Object)part);
        }
        if (achievement == null || achievement.getActionableNode() != null) {
            // empty if block
        }
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (channel == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            MEInventoryHandler<IAEItemStack> out;
            MEInventoryHandler<IAEItemStack> mEInventoryHandler = out = this.getProxy().isActive() ? this.getInternalHandler() : null;
            if (out != null) {
                return Collections.singletonList(out);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.resetCache(true);
    }

    @Override
    public void blinkCell(int slot) {
    }

    @Override
    public void saveChanges(ICellInventory<?> cellInventory) {
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Override
    public class_1799 getItemStackRepresentation() {
        return Api.instance().definitions().parts().storageBus().maybeStack(1).orElse(class_1799.field_8037);
    }

    @Override
    public class_3917<?> getContainerType() {
        return StorageBusContainer.TYPE;
    }
}

