/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyGridProvider;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class QuartzFiberPart
extends AEBasePart
implements IEnergyGridProvider {
    @PartModels
    private static final IPartModel MODELS = new PartModel(new class_2960("appliedenergistics2", "part/quartz_fiber"));
    private final AENetworkProxy outerProxy = new AENetworkProxy(this, "outer", this.getProxy().getMachineRepresentation(), true);

    public QuartzFiberPart(class_1799 is) {
        super(is);
        this.getProxy().setIdlePowerUsage(0.0);
        this.getProxy().setFlags(GridFlags.CANNOT_CARRY);
        this.outerProxy.setIdlePowerUsage(0.0);
        this.outerProxy.setFlags(GridFlags.CANNOT_CARRY);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.GLASS;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0);
    }

    @Override
    public void readFromNBT(class_2487 extra) {
        super.readFromNBT(extra);
        this.outerProxy.readFromNBT(extra);
    }

    @Override
    public void writeToNBT(class_2487 extra) {
        super.writeToNBT(extra);
        this.outerProxy.writeToNBT(extra);
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.outerProxy.remove();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.outerProxy.onReady();
    }

    @Override
    public void setPartHostInfo(AEPartLocation side, IPartHost host, class_2586 tile) {
        super.setPartHostInfo(side, host, tile);
        this.outerProxy.setValidSides(EnumSet.of(side.getFacing()));
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return this.outerProxy.getNode();
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 16.0f;
    }

    @Override
    public void onPlacement(class_1657 player, class_1268 hand, class_1799 held, AEPartLocation side) {
        super.onPlacement(player, hand, held, side);
        this.outerProxy.setOwner(player);
    }

    @Override
    public Collection<IEnergyGridProvider> providers() {
        IEnergyGrid eg2;
        ArrayList<IEnergyGridProvider> providers = new ArrayList<IEnergyGridProvider>();
        try {
            eg2 = this.getProxy().getEnergy();
            providers.add(eg2);
        }
        catch (GridAccessException eg2) {
            // empty catch block
        }
        try {
            eg2 = this.outerProxy.getEnergy();
            providers.add(eg2);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return providers;
    }

    @Override
    public double extractProviderPower(double amt, Actionable mode) {
        return 0.0;
    }

    @Override
    public double injectProviderPower(double amt, Actionable mode) {
        return amt;
    }

    @Override
    public double getProviderEnergyDemand(double amt) {
        return 0.0;
    }

    @Override
    public double getProviderStoredEnergy() {
        return 0.0;
    }

    @Override
    public double getProviderMaxEnergy() {
        return 0.0;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS;
    }
}

