/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import alexiil.mc.lib.attributes.Attribute;
import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.SearchOption;
import alexiil.mc.lib.attributes.SearchOptions;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.EmptyFluidExtractable;
import alexiil.mc.lib.attributes.fluid.impl.RejectingFluidInsertable;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class FluidP2PTunnelPart
extends P2PTunnelPart<FluidP2PTunnelPart> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_fluids");
    private final FluidInsertable inputHandler = new InputFluidHandler();
    private final FluidExtractable outputHandler = new OutputFluidHandler();

    public FluidP2PTunnelPart(class_1799 is) {
        super(is);
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public void onTunnelNetworkChange() {
    }

    @Override
    public void onNeighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
        FluidP2PTunnelPart in;
        if (this.isOutput() && (in = (FluidP2PTunnelPart)this.getInput()) != null) {
            in.onTunnelNetworkChange();
        }
    }

    @Override
    public void addAllAttributes(AttributeList<?> to) {
        if (this.isOutput()) {
            to.offer((Object)this.outputHandler);
        } else {
            to.offer((Object)this.inputHandler);
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private <T> T getAttachedAttribute(Attribute<T> attribute, T defaultValue) {
        Object result = null;
        if (this.isActive()) {
            class_2586 self = this.getTile();
            class_2350 direction = this.getSide().getFacing();
            class_2338 targetPos = self.method_11016().method_10093(direction);
            class_1937 world = self.method_10997();
            result = attribute.getFirstOrNull(world, targetPos, (SearchOption)SearchOptions.inDirection((class_2350)direction));
        }
        return (T)(result != null ? result : (Object)defaultValue);
    }

    private FluidInsertable getAttachedOutput() {
        return (FluidInsertable)this.getAttachedAttribute((Attribute)FluidAttributes.INSERTABLE, (Object)RejectingFluidInsertable.NULL);
    }

    private FluidExtractable getAttachedInput() {
        return (FluidExtractable)this.getAttachedAttribute((Attribute)FluidAttributes.EXTRACTABLE, (Object)EmptyFluidExtractable.NULL);
    }

    private class OutputFluidHandler
    implements FluidExtractable {
        private OutputFluidHandler() {
        }

        public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
            return FluidP2PTunnelPart.this.getAttachedInput().attemptExtraction(filter, maxAmount, simulation);
        }

        public FluidVolume attemptAnyExtraction(FluidAmount maxAmount, Simulation simulation) {
            return FluidP2PTunnelPart.this.getAttachedInput().attemptAnyExtraction(maxAmount, simulation);
        }

        public FluidVolume extract(FluidFilter filter, FluidAmount maxAmount) {
            return FluidP2PTunnelPart.this.getAttachedInput().extract(filter, maxAmount);
        }

        public FluidVolume extract(FluidKey filter, FluidAmount maxAmount) {
            return FluidP2PTunnelPart.this.getAttachedInput().extract(filter, maxAmount);
        }

        public FluidVolume extract(FluidAmount maxAmount) {
            return FluidP2PTunnelPart.this.getAttachedInput().extract(maxAmount);
        }

        public boolean couldExtractAnything() {
            return FluidP2PTunnelPart.this.getAttachedInput().couldExtractAnything();
        }

        public FluidExtractable filtered(FluidFilter filter) {
            return FluidP2PTunnelPart.this.getAttachedInput().filtered(filter);
        }

        public FluidExtractable getPureExtractable() {
            return FluidP2PTunnelPart.this.getAttachedInput().getPureExtractable();
        }
    }

    private class InputFluidHandler
    implements FluidInsertable {
        private InputFluidHandler() {
        }

        public FluidVolume attemptInsertion(FluidVolume fluidVolume, Simulation simulation) {
            FluidAmount overflowAmount = FluidAmount.ZERO;
            try {
                int outputTunnels = FluidP2PTunnelPart.this.getOutputs().size();
                FluidAmount amount = fluidVolume.amount();
                if (outputTunnels == 0 || amount.isZero()) {
                    return fluidVolume;
                }
                FluidAmount amountPerOutput = amount.div((long)outputTunnels);
                for (FluidP2PTunnelPart target : FluidP2PTunnelPart.this.getOutputs()) {
                    FluidInsertable output = target.getAttachedOutput();
                    FluidVolume fillWithFluidStack = fluidVolume.withAmount(amountPerOutput.add(overflowAmount));
                    overflowAmount = output.attemptInsertion(fillWithFluidStack, simulation).amount();
                }
                if (simulation.isAction()) {
                    FluidP2PTunnelPart.this.queueTunnelDrain(PowerUnits.TR, amount.sub(overflowAmount).asInexactDouble() * 1000.0);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return fluidVolume.withAmount(overflowAmount);
        }
    }
}

