/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.CacheInfo;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.ItemAttributes;
import alexiil.mc.lib.attributes.item.impl.CombinedFixedItemInv;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartModel;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class ItemP2PTunnelPart
extends P2PTunnelPart<ItemP2PTunnelPart>
implements IGridTickable {
    private static final float POWER_DRAIN = 2.0f;
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_items");
    private boolean partVisited = false;
    private int oldSize = 0;
    private boolean requested;
    private FixedItemInv cachedInv;
    private List<FixedItemInv> cachedInvs = new ArrayList<FixedItemInv>();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public ItemP2PTunnelPart(class_1799 is) {
        super(is);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public void onNeighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
        this.cachedInv = null;
        this.cachedInvs.clear();
        ItemP2PTunnelPart input = (ItemP2PTunnelPart)this.getInput();
        if (input != null && this.isOutput()) {
            input.onTunnelNetworkChange();
        }
    }

    private FixedItemInv getDestination() {
        TunnelCollection itemTunnels;
        this.requested = true;
        if (this.cachedInv != null) {
            return this.cachedInv;
        }
        ArrayList<FixedItemInv> outs = new ArrayList<FixedItemInv>();
        try {
            itemTunnels = this.getOutputs();
        }
        catch (GridAccessException e) {
            return null;
        }
        for (ItemP2PTunnelPart t : itemTunnels) {
            FixedItemInv inv = t.getOutputInv();
            if (inv == null || inv == this) continue;
            if (Platform.getRandomInt() % 2 == 0) {
                outs.add(inv);
                continue;
            }
            outs.add(0, inv);
        }
        this.cachedInvs = outs;
        this.cachedInv = new CombinedFixedItemInv(outs);
        return this.cachedInv;
    }

    private FixedItemInv getOutputInv() {
        FixedItemInv ret = null;
        if (!this.partVisited) {
            this.partVisited = true;
            if (this.getProxy().isActive()) {
                class_2350 facing = this.getSide().getFacing();
                ret = (FixedItemInv)ItemAttributes.FIXED_INV.getFirstOrNullFromNeighbour(this.getTile(), facing);
            }
            this.partVisited = false;
        }
        return ret;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ItemTunnel.getMin(), TickRates.ItemTunnel.getMax(), false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        boolean wasReq = this.requested;
        if (this.requested && !this.cachedInvs.isEmpty()) {
            this.cachedInvs = new ArrayList<FixedItemInv>(this.cachedInvs);
            FixedItemInv lastInv = this.cachedInvs.remove(this.cachedInvs.size() - 1);
            this.cachedInvs.add(0, lastInv);
            this.cachedInv = new CombinedFixedItemInv(this.cachedInvs);
        }
        this.requested = false;
        return wasReq ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    @MENetworkEventSubscribe
    public void changeStateA(MENetworkBootingStatusChange bs) {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().getSlotCount();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @MENetworkEventSubscribe
    public void changeStateB(MENetworkChannelsChanged bs) {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().getSlotCount();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @MENetworkEventSubscribe
    public void changeStateC(MENetworkPowerStatusChange bs) {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().getSlotCount();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @Override
    public void onTunnelNetworkChange() {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().getSlotCount();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        } else {
            ItemP2PTunnelPart input = (ItemP2PTunnelPart)this.getInput();
            if (input != null) {
                input.getHost().notifyNeighbors();
            }
        }
    }

    @Override
    public void addAllAttributes(AttributeList<?> to) {
        to.offer((Object)this.getDestination(), CacheInfo.NOT_CACHABLE);
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

