/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartModel;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import java.io.IOException;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;

public class LightP2PTunnelPart
extends P2PTunnelPart<LightP2PTunnelPart>
implements IGridTickable {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_light");
    private int lastValue = 0;
    private int opacity = -1;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public LightP2PTunnelPart(class_1799 is) {
        super(is);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 0.5f;
    }

    @Override
    public void chanRender(MENetworkChannelsChanged c) {
        this.onTunnelNetworkChange();
        super.chanRender(c);
    }

    @Override
    public void powerRender(MENetworkPowerStatusChange c) {
        this.onTunnelNetworkChange();
        super.powerRender(c);
    }

    @Override
    public void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        data.writeInt(this.isOutput() ? this.lastValue : 0);
        data.writeInt(this.opacity);
    }

    @Override
    public boolean readFromStream(class_2540 data) throws IOException {
        super.readFromStream(data);
        int oldValue = this.lastValue;
        int oldOpacity = this.opacity;
        this.lastValue = data.readInt();
        this.opacity = data.readInt();
        this.setOutput(this.lastValue > 0);
        return this.lastValue != oldValue || oldOpacity != this.opacity;
    }

    private boolean doWork() {
        if (this.isOutput()) {
            return false;
        }
        class_2586 te = this.getTile();
        class_1937 w = te.method_10997();
        int newLevel = w.method_22339(te.method_11016().method_10093(this.getSide().getFacing()));
        if (this.lastValue != newLevel && this.getProxy().isActive()) {
            this.lastValue = newLevel;
            try {
                for (LightP2PTunnelPart out : this.getOutputs()) {
                    out.setLightLevel(this.lastValue);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
        if (this.isOutput() && pos.method_10093(this.getSide().getFacing()).equals((Object)neighbor)) {
            this.opacity = -1;
            this.getHost().markForUpdate();
        } else {
            this.doWork();
        }
    }

    @Override
    public int getLightLevel() {
        if (this.isOutput() && this.isPowered()) {
            return this.blockLight(this.lastValue);
        }
        return 0;
    }

    private void setLightLevel(int out) {
        this.lastValue = out;
        this.getHost().markForUpdate();
    }

    private int blockLight(int emit) {
        if (this.opacity < 0) {
            class_2586 te = this.getTile();
            this.opacity = 255 - te.method_10997().method_22339(te.method_11016().method_10093(this.getSide().getFacing()));
        }
        return (int)((float)emit * ((float)this.opacity / 255.0f));
    }

    @Override
    public void readFromNBT(class_2487 tag) {
        super.readFromNBT(tag);
        this.lastValue = tag.method_10550("lastValue");
    }

    @Override
    public void writeToNBT(class_2487 tag) {
        super.writeToNBT(tag);
        tag.method_10569("lastValue", this.lastValue);
    }

    @Override
    public void onTunnelConfigChange() {
        this.onTunnelNetworkChange();
    }

    @Override
    public void onTunnelNetworkChange() {
        if (this.isOutput()) {
            LightP2PTunnelPart src = (LightP2PTunnelPart)this.getInput();
            if (src != null && src.getProxy().isActive()) {
                this.setLightLevel(src.lastValue);
            } else {
                this.getHost().markForUpdate();
            }
        } else {
            this.doWork();
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.LightTunnel.getMin(), TickRates.LightTunnel.getMax(), false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doWork() ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

