/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.TunnelType;
import appeng.api.definitions.IParts;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.core.Api;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.BasicStatePart;
import appeng.util.Platform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public abstract class P2PTunnelPart<T extends P2PTunnelPart>
extends BasicStatePart {
    private final TunnelCollection type = new TunnelCollection(null, this.getClass());
    private boolean output;
    private short freq;

    public P2PTunnelPart(class_1799 is) {
        super(is);
        this.getProxy().setIdlePowerUsage(this.getPowerDrainPerTick());
    }

    protected float getPowerDrainPerTick() {
        return 1.0f;
    }

    public TunnelCollection<T> getCollection(Collection<P2PTunnelPart> collection, Class<? extends P2PTunnelPart> c) {
        if (this.type.matches(c)) {
            this.type.setSource(collection);
            return this.type;
        }
        return null;
    }

    public T getInput() {
        if (this.getFrequency() == 0) {
            return null;
        }
        try {
            P2PTunnelPart tunnel = this.getProxy().getP2P().getInput(this.getFrequency());
            if (this.getClass().isInstance(tunnel)) {
                return (T)tunnel;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return null;
    }

    public TunnelCollection<T> getOutputs() throws GridAccessException {
        if (this.getProxy().isActive()) {
            return this.getProxy().getP2P().getOutputs(this.getFrequency(), this.getClass());
        }
        return new TunnelCollection(new ArrayList(), this.getClass());
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
        bch.addBox(3.0, 3.0, 13.0, 13.0, 13.0, 14.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    @Override
    public class_1799 getItemStack(PartItemStack type) {
        if (type == PartItemStack.WORLD || type == PartItemStack.NETWORK || type == PartItemStack.WRENCH || type == PartItemStack.PICK) {
            return super.getItemStack(type);
        }
        Optional<class_1799> maybeMEStack = Api.instance().definitions().parts().p2PTunnelME().maybeStack(1);
        if (maybeMEStack.isPresent()) {
            return maybeMEStack.get();
        }
        return super.getItemStack(type);
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.setOutput(data.method_10577("output"));
        this.freq = data.method_10568("freq");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10556("output", this.isOutput());
        data.method_10575("freq", this.getFrequency());
    }

    @Override
    public boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        short oldf = this.freq;
        this.freq = data.readShort();
        return c || oldf != this.freq;
    }

    @Override
    public void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        data.writeShort((int)this.getFrequency());
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    @Override
    public boolean useStandardMemoryCard() {
        return false;
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (hand == class_1268.field_5810) {
            return false;
        }
        class_1799 is = player.method_5998(hand);
        TunnelType tt = Api.instance().registries().p2pTunnel().getTunnelTypeByItem(is);
        if (!is.method_7960() && is.method_7909() instanceof IMemoryCard) {
            Object testPart;
            IMemoryCard mc = (IMemoryCard)is.method_7909();
            class_2487 data = mc.getData(is);
            class_1799 newType = class_1799.method_7915((class_2487)data);
            short freq = data.method_10568("freq");
            if (!newType.method_7960() && newType.method_7909() instanceof IPartItem && (testPart = ((IPartItem)newType.method_7909()).createPart(newType)) instanceof P2PTunnelPart) {
                this.getHost().removePart(this.getSide(), true);
                AEPartLocation dir = this.getHost().addPart(newType, this.getSide(), player, hand);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof P2PTunnelPart) {
                    P2PTunnelPart newTunnel = (P2PTunnelPart)newBus;
                    newTunnel.setOutput(true);
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, freq);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                    newTunnel.onTunnelNetworkChange();
                }
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                return true;
            }
            mc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
        } else if (tt != null) {
            class_1799 newType;
            IParts parts = Api.instance().definitions().parts();
            switch (tt) {
                case LIGHT: {
                    newType = parts.p2PTunnelLight().maybeStack(1).orElse(class_1799.field_8037);
                    break;
                }
                case FLUID: {
                    newType = parts.p2PTunnelFluids().maybeStack(1).orElse(class_1799.field_8037);
                    break;
                }
                case ITEM: {
                    newType = parts.p2PTunnelItems().maybeStack(1).orElse(class_1799.field_8037);
                    break;
                }
                case ME: {
                    newType = parts.p2PTunnelME().maybeStack(1).orElse(class_1799.field_8037);
                    break;
                }
                case REDSTONE: {
                    newType = parts.p2PTunnelRedstone().maybeStack(1).orElse(class_1799.field_8037);
                    break;
                }
                default: {
                    newType = class_1799.field_8037;
                }
            }
            if (!newType.method_7960() && !class_1799.method_7987((class_1799)newType, (class_1799)this.getItemStack())) {
                boolean oldOutput = this.isOutput();
                short myFreq = this.getFrequency();
                this.getHost().removePart(this.getSide(), false);
                AEPartLocation dir = this.getHost().addPart(newType, this.getSide(), player, hand);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof P2PTunnelPart) {
                    P2PTunnelPart newTunnel = (P2PTunnelPart)newBus;
                    newTunnel.setOutput(oldOutput);
                    newTunnel.onTunnelNetworkChange();
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, myFreq);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
                Platform.notifyBlocksOfNeighbors(this.getTile().method_10997(), this.getTile().method_11016());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onPartShiftActivate(class_1657 player, class_1268 hand, class_243 pos) {
        class_1799 is = player.field_7514.method_7391();
        if (!is.method_7960() && is.method_7909() instanceof IMemoryCard) {
            if (Platform.isClient()) {
                return true;
            }
            IMemoryCard mc = (IMemoryCard)is.method_7909();
            class_2487 data = mc.getData(is);
            short storedFrequency = data.method_10568("freq");
            short newFreq = this.getFrequency();
            boolean wasOutput = this.isOutput();
            this.setOutput(false);
            boolean needsNewFrequency = wasOutput || this.getFrequency() == 0 || storedFrequency == newFreq;
            try {
                if (needsNewFrequency) {
                    newFreq = this.getProxy().getP2P().newFrequency();
                }
                this.getProxy().getP2P().updateFreq(this, newFreq);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            this.onTunnelConfigChange();
            class_1799 p2pItem = this.getItemStack(PartItemStack.WRENCH);
            String type = p2pItem.method_7922();
            p2pItem.method_7953(data);
            data.method_10575("freq", this.getFrequency());
            AEColor[] colors = Platform.p2p().toColors(this.getFrequency());
            int[] colorCode = new int[]{colors[0].ordinal(), colors[0].ordinal(), colors[1].ordinal(), colors[1].ordinal(), colors[2].ordinal(), colors[2].ordinal(), colors[3].ordinal(), colors[3].ordinal()};
            data.method_10539("colorCode", colorCode);
            mc.setMemoryCardContents(is, type + ".name", data);
            if (needsNewFrequency) {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_RESET);
            } else {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
            }
            return true;
        }
        return false;
    }

    public void onTunnelConfigChange() {
    }

    public void onTunnelNetworkChange() {
    }

    protected void queueTunnelDrain(PowerUnits unit, double f) {
        double ae_to_tax = unit.convertTo(PowerUnits.AE, f * 0.05);
        try {
            this.getProxy().getEnergy().extractAEPower(ae_to_tax, Actionable.MODULATE, PowerMultiplier.ONE);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public short getFrequency() {
        return this.freq;
    }

    public void setFrequency(short freq) {
        short oldf = this.freq;
        this.freq = freq;
        if (oldf != this.freq) {
            this.getHost().markForUpdate();
        }
    }

    public boolean isOutput() {
        return this.output;
    }

    void setOutput(boolean output) {
        this.output = output;
    }

    @Override
    public Object getModelData() {
        long ret = Short.toUnsignedLong(this.getFrequency());
        if (this.isActive() && this.isPowered()) {
            ret |= 0x10000L;
        }
        return ret;
    }
}

