/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2457;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class RedstoneP2PTunnelPart
extends P2PTunnelPart<RedstoneP2PTunnelPart> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_redstone");
    private int power;
    private boolean recursive = false;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public RedstoneP2PTunnelPart(class_1799 is) {
        super(is);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 0.5f;
    }

    @MENetworkEventSubscribe
    public void changeStateA(MENetworkBootingStatusChange bs) {
        this.setNetworkReady();
    }

    private void setNetworkReady() {
        RedstoneP2PTunnelPart in;
        if (this.isOutput() && (in = (RedstoneP2PTunnelPart)this.getInput()) != null) {
            this.putInput(in.power);
        }
    }

    private void putInput(Object o) {
        int newPower;
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        if (this.isOutput() && this.getProxy().isActive() && this.power != (newPower = ((Integer)o).intValue())) {
            this.power = newPower;
            this.notifyNeighbors();
        }
        this.recursive = false;
    }

    private void notifyNeighbors() {
        class_1937 world = this.getTile().method_10997();
        Platform.notifyBlocksOfNeighbors(world, this.getTile().method_11016());
        for (class_2350 face : class_2350.values()) {
            Platform.notifyBlocksOfNeighbors(world, this.getTile().method_11016().method_10093(face));
        }
    }

    @MENetworkEventSubscribe
    public void changeStateB(MENetworkChannelsChanged bs) {
        this.setNetworkReady();
    }

    @MENetworkEventSubscribe
    public void changeStateC(MENetworkPowerStatusChange bs) {
        this.setNetworkReady();
    }

    @Override
    public void readFromNBT(class_2487 tag) {
        super.readFromNBT(tag);
        this.power = tag.method_10550("power");
    }

    @Override
    public void writeToNBT(class_2487 tag) {
        super.writeToNBT(tag);
        tag.method_10569("power", this.power);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.setNetworkReady();
    }

    @Override
    public void onNeighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
        if (!this.isOutput()) {
            class_2338 target = this.getTile().method_11016().method_10093(this.getSide().getFacing());
            class_2680 state = this.getTile().method_10997().method_8320(target);
            class_2248 b = state.method_26204();
            if (b != null && !this.isOutput()) {
                class_2350 srcSide = this.getSide().getFacing();
                if (b instanceof class_2457) {
                    srcSide = class_2350.field_11036;
                }
                this.power = b.method_9524(state, (class_1922)this.getTile().method_10997(), target, srcSide);
                this.power = Math.max(this.power, b.method_9524(state, (class_1922)this.getTile().method_10997(), target, srcSide));
                this.sendToOutput(this.power);
            } else {
                this.sendToOutput(0);
            }
        }
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public int isProvidingStrongPower() {
        return this.isOutput() ? this.power : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.isOutput() ? this.power : 0;
    }

    private void sendToOutput(int power) {
        try {
            for (RedstoneP2PTunnelPart rs : this.getOutputs()) {
                rs.putInput(power);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

