/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.parts.IStorageMonitorPart;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.render.TesrRenderHelper;
import appeng.core.Api;
import appeng.core.localization.PlayerMessages;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractDisplayPart;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public abstract class AbstractMonitorPart
extends AbstractDisplayPart
implements IStorageMonitorPart,
IStackWatcherHost {
    private static final IWideReadableNumberConverter NUMBER_CONVERTER = ReadableNumberConverter.INSTANCE;
    private IAEItemStack configuredItem;
    private String lastHumanReadableText;
    private boolean isLocked;
    private IStackWatcher myWatcher;

    public AbstractMonitorPart(class_1799 is) {
        super(is);
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.isLocked = data.method_10577("isLocked");
        class_2487 myItem = data.method_10562("configuredItem");
        this.configuredItem = AEItemStack.fromNBT(myItem);
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10556("isLocked", this.isLocked);
        class_2487 myItem = new class_2487();
        if (this.configuredItem != null) {
            this.configuredItem.writeToNBT(myItem);
        }
        data.method_10566("configuredItem", (class_2520)myItem);
    }

    @Override
    public void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isLocked);
        data.writeBoolean(this.configuredItem != null);
        if (this.configuredItem != null) {
            this.configuredItem.writeToPacket(data);
        }
    }

    @Override
    public boolean readFromStream(class_2540 data) throws IOException {
        boolean needRedraw = super.readFromStream(data);
        boolean isLocked = data.readBoolean();
        needRedraw = this.isLocked != isLocked;
        this.isLocked = isLocked;
        boolean val = data.readBoolean();
        this.configuredItem = val ? AEItemStack.fromPacket(data) : null;
        return needRedraw;
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (this.isLocked) {
            return super.onPartActivate(player, hand, pos);
        }
        class_1799 eq = player.method_5998(hand);
        this.configuredItem = AEItemStack.fromItemStack(eq);
        this.configureWatchers();
        this.getHost().markForSave();
        this.getHost().markForUpdate();
        return true;
    }

    @Override
    public boolean onPartShiftActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (player.method_5998(hand).method_7960()) {
            this.isLocked = !this.isLocked;
            player.method_9203((this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).get(), class_156.field_25140);
            this.getHost().markForSave();
            this.getHost().markForUpdate();
        }
        return true;
    }

    private void configureWatchers() {
        if (this.myWatcher != null) {
            this.myWatcher.reset();
        }
        try {
            if (this.configuredItem != null) {
                if (this.myWatcher != null) {
                    this.myWatcher.add(this.configuredItem);
                }
                this.updateReportingValue(this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)));
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateReportingValue(IMEMonitor<IAEItemStack> itemInventory) {
        if (this.configuredItem != null) {
            IAEItemStack result = itemInventory.getStorageList().findPrecise(this.configuredItem);
            if (result == null) {
                this.configuredItem.setStackSize(0L);
            } else {
                this.configuredItem.setStackSize(result.getStackSize());
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderDynamic(float partialTicks, class_4587 matrixStack, class_4597 buffers, int combinedLightIn, int combinedOverlayIn) {
        if ((this.getClientFlags() & 0x14) != 20) {
            return;
        }
        IAEItemStack ais = this.getDisplayed();
        if (ais == null) {
            return;
        }
        matrixStack.method_22903();
        matrixStack.method_22904(0.5, 0.5, 0.5);
        class_2350 facing = this.getSide().getFacing();
        TesrRenderHelper.rotateToFace(matrixStack, facing, this.getSpin());
        matrixStack.method_22904(0.0, 0.05, 0.5);
        TesrRenderHelper.renderItem2dWithAmount(matrixStack, buffers, ais, 0.4f, -0.23f, 0xF000F0, combinedOverlayIn);
        matrixStack.method_22909();
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    public IAEItemStack getDisplayed() {
        return this.configuredItem;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, IActionSource src, IStorageChannel chan) {
        if (this.configuredItem != null) {
            if (fullStack == null) {
                this.configuredItem.setStackSize(0L);
            } else {
                this.configuredItem.setStackSize(fullStack.getStackSize());
            }
            long stackSize = this.configuredItem.getStackSize();
            String humanReadableText = NUMBER_CONVERTER.toWideReadableForm(stackSize);
            if (!humanReadableText.equals(this.lastHumanReadableText)) {
                this.lastHumanReadableText = humanReadableText;
                this.getHost().markForUpdate();
            }
        }
    }

    @Override
    public boolean showNetworkInfo(class_239 where) {
        return false;
    }

    protected IPartModel selectModel(IPartModel off, IPartModel on, IPartModel hasChannel, IPartModel lockedOff, IPartModel lockedOn, IPartModel lockedHasChannel) {
        if (this.isActive()) {
            if (this.isLocked()) {
                return lockedHasChannel;
            }
            return hasChannel;
        }
        if (this.isPowered()) {
            if (this.isLocked()) {
                return lockedOn;
            }
            return on;
        }
        if (this.isLocked()) {
            return lockedOff;
        }
        return off;
    }
}

