/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.parts.IMonitorPart;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import java.io.IOException;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3532;

public abstract class AbstractReportingPart
extends AEBasePart
implements IMonitorPart,
IPowerChannelState {
    protected static final int POWERED_FLAG = 4;
    protected static final int CHANNEL_FLAG = 16;
    private static final int BOOTING_FLAG = 8;
    private byte spin = 0;
    private int clientFlags = 0;
    private int opacity = -1;

    public AbstractReportingPart(class_1799 is) {
        this(is, false);
    }

    protected AbstractReportingPart(class_1799 is, boolean requireChannel) {
        super(is);
        if (requireChannel) {
            this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
            this.getProxy().setIdlePowerUsage(0.5);
        } else {
            this.getProxy().setIdlePowerUsage(0.0625);
        }
    }

    @MENetworkEventSubscribe
    public final void bootingRender(MENetworkBootingStatusChange c) {
        if (!this.isLightSource()) {
            this.getHost().markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public final void powerRender(MENetworkPowerStatusChange c) {
        this.getHost().markForUpdate();
    }

    @Override
    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    @Override
    public void onNeighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
        if (pos.method_10093(this.getSide().getFacing()).equals((Object)neighbor)) {
            this.opacity = -1;
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.spin = data.method_10571("spin");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10567("spin", this.getSpin());
    }

    @Override
    public void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        this.clientFlags = this.getSpin() & 3;
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                this.clientFlags = this.getClientFlags() | 4;
            }
            if (this.getProxy().getPath().isNetworkBooting()) {
                this.clientFlags = this.getClientFlags() | 8;
            }
            if (this.getProxy().getNode().meetsChannelRequirements()) {
                this.clientFlags = this.getClientFlags() | 0x10;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        data.writeByte((int)((byte)this.getClientFlags()));
        data.writeInt(this.opacity);
    }

    @Override
    public boolean readFromStream(class_2540 data) throws IOException {
        super.readFromStream(data);
        int oldFlags = this.getClientFlags();
        int oldOpacity = this.opacity;
        this.clientFlags = data.readByte();
        this.opacity = data.readInt();
        this.spin = (byte)(this.getClientFlags() & 3);
        return this.getClientFlags() != oldFlags || this.opacity != oldOpacity;
    }

    @Override
    public final int getLightLevel() {
        return this.blockLight(this.isPowered() ? (this.isLightSource() ? 15 : 9) : 0);
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        class_2586 te = this.getTile();
        if (Platform.isWrench(player, player.field_7514.method_7391(), te.method_11016())) {
            if (Platform.isServer()) {
                if (this.getSpin() > 3) {
                    this.spin = 0;
                }
                switch (this.getSpin()) {
                    case 0: {
                        this.spin = 1;
                        break;
                    }
                    case 1: {
                        this.spin = (byte)3;
                        break;
                    }
                    case 2: {
                        this.spin = 0;
                        break;
                    }
                    case 3: {
                        this.spin = (byte)2;
                    }
                }
                this.getHost().markForUpdate();
                this.saveChanges();
            }
            return true;
        }
        return super.onPartActivate(player, hand, pos);
    }

    @Override
    public final void onPlacement(class_1657 player, class_1268 hand, class_1799 held, AEPartLocation side) {
        super.onPlacement(player, hand, held, side);
        byte rotation = (byte)(class_3532.method_15357((double)((double)(player.field_6031 * 4.0f / 360.0f) + 2.5)) & 3);
        if (side == AEPartLocation.UP) {
            this.spin = rotation;
        } else if (side == AEPartLocation.DOWN) {
            this.spin = rotation;
        }
    }

    private final int blockLight(int emit) {
        if (this.opacity < 0) {
            class_2586 te = this.getTile();
            class_1937 world = te.method_10997();
            class_2338 pos = te.method_11016().method_10093(this.getSide().getFacing());
            this.opacity = 255 - world.method_8320(pos).method_26193((class_1922)world, pos);
        }
        return (int)((float)emit * ((float)this.opacity / 255.0f));
    }

    @Override
    public final boolean isPowered() {
        try {
            if (Platform.isServer()) {
                return this.getProxy().getEnergy().isNetworkPowered();
            }
            return (this.getClientFlags() & 4) == 4;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    @Override
    public final boolean isActive() {
        if (!this.isLightSource()) {
            return (this.getClientFlags() & 0x14) == 20;
        }
        return this.isPowered();
    }

    protected IPartModel selectModel(IPartModel offModels, IPartModel onModels, IPartModel hasChannelModels) {
        if (this.isActive()) {
            return hasChannelModels;
        }
        if (this.isPowered()) {
            return onModels;
        }
        return offModels;
    }

    public final int getClientFlags() {
        return this.clientFlags;
    }

    public final byte getSpin() {
        return this.spin;
    }

    public abstract boolean isLightSource();
}

