/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.SingleItemSlot;
import alexiil.mc.lib.attributes.item.compat.FixedInventoryVanillaWrapper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.Api;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.PlayerSource;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractMonitorPart;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class ConversionMonitorPart
extends AbstractMonitorPart {
    @PartModels
    public static final class_2960 MODEL_OFF = new class_2960("appliedenergistics2", "part/conversion_monitor_off");
    @PartModels
    public static final class_2960 MODEL_ON = new class_2960("appliedenergistics2", "part/conversion_monitor_on");
    @PartModels
    public static final class_2960 MODEL_LOCKED_OFF = new class_2960("appliedenergistics2", "part/conversion_monitor_locked_off");
    @PartModels
    public static final class_2960 MODEL_LOCKED_ON = new class_2960("appliedenergistics2", "part/conversion_monitor_locked_on");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL);
    public static final IPartModel MODELS_LOCKED_OFF = new PartModel(MODEL_BASE, MODEL_LOCKED_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_LOCKED_ON = new PartModel(MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_LOCKED_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_HAS_CHANNEL);

    public ConversionMonitorPart(class_1799 is) {
        super(is);
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        class_1799 eq = player.method_5998(hand);
        if (this.isLocked()) {
            if (eq.method_7960()) {
                this.insertItem(player, hand, true);
            } else {
                if (Platform.isWrench(player, eq, this.getLocation().getPos()) && (this.getDisplayed() == null || !this.getDisplayed().equals(eq))) {
                    return super.onPartActivate(player, hand, pos);
                }
                this.insertItem(player, hand, false);
            }
        } else if (this.getDisplayed() != null && this.getDisplayed().equals(eq)) {
            this.insertItem(player, hand, false);
        } else {
            return super.onPartActivate(player, hand, pos);
        }
        return true;
    }

    @Override
    public boolean onClicked(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (this.getDisplayed() != null) {
            this.extractItem(player, this.getDisplayed().getDefinition().method_7914());
        }
        return true;
    }

    @Override
    public boolean onShiftClicked(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (this.getDisplayed() != null) {
            this.extractItem(player, 1);
        }
        return true;
    }

    private void insertItem(class_1657 player, class_1268 hand, boolean allItems) {
        try {
            IEnergyGrid energy = this.getProxy().getEnergy();
            IMEMonitor<IAEItemStack> cell = this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
            if (allItems) {
                if (this.getDisplayed() != null) {
                    IAEItemStack input = this.getDisplayed().copy();
                    FixedInventoryVanillaWrapper inv = new FixedInventoryVanillaWrapper((class_1263)player.field_7514);
                    for (int x = 0; x < inv.getSlotCount(); ++x) {
                        SingleItemSlot slot;
                        class_1799 canExtract;
                        class_1799 targetStack = inv.getInvStack(x);
                        if (!input.equals(targetStack) || (canExtract = (slot = inv.getSlot(x)).attemptAnyExtraction(targetStack.method_7947(), Simulation.SIMULATE)).method_7960()) continue;
                        input.setStackSize(canExtract.method_7947());
                        IAEItemStack failedToInsert = Platform.poweredInsert(energy, cell, input, new PlayerSource(player, this));
                        slot.extract(failedToInsert == null ? canExtract.method_7947() : canExtract.method_7947() - (int)failedToInsert.getStackSize());
                    }
                }
            } else {
                AEItemStack input = AEItemStack.fromItemStack(player.method_5998(hand));
                IAEItemStack failedToInsert = Platform.poweredInsert(energy, cell, input, new PlayerSource(player, this));
                player.method_6122(hand, failedToInsert == null ? class_1799.field_8037 : failedToInsert.createItemStack());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void extractItem(class_1657 player, int count) {
        IAEItemStack input = this.getDisplayed();
        if (input != null) {
            try {
                if (!this.getProxy().isActive()) {
                    return;
                }
                IEnergyGrid energy = this.getProxy().getEnergy();
                IMEMonitor<IAEItemStack> cell = this.getProxy().getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
                input.setStackSize(count);
                IAEItemStack retrieved = Platform.poweredExtraction(energy, cell, input, new PlayerSource(player, this));
                if (retrieved != null) {
                    class_1799 newItems = retrieved.createItemStack();
                    InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(player);
                    newItems = adaptor.addItems(newItems);
                    if (!newItems.method_7960()) {
                        class_2586 te = this.getTile();
                        List<class_1799> list = Collections.singletonList(newItems);
                        Platform.spawnDrops(player.field_6002, te.method_11016().method_10093(this.getSide().getFacing()), list);
                    }
                    if (player.field_7512 != null) {
                        player.field_7512.method_7623();
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL, MODELS_LOCKED_OFF, MODELS_LOCKED_ON, MODELS_LOCKED_HAS_CHANNEL);
    }
}

