/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.parts.IPartModel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.implementations.PatternTermContainer;
import appeng.core.Api;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractTerminalPart;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3917;

public class PatternTerminalPart
extends AbstractTerminalPart {
    @PartModels
    public static final class_2960 MODEL_OFF = new class_2960("appliedenergistics2", "part/pattern_terminal_off");
    @PartModels
    public static final class_2960 MODEL_ON = new class_2960("appliedenergistics2", "part/pattern_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL);
    private final AppEngInternalInventory crafting = new AppEngInternalInventory(this, 9);
    private final AppEngInternalInventory output = new AppEngInternalInventory(this, 3);
    private final AppEngInternalInventory pattern = new AppEngInternalInventory(this, 2);
    private boolean craftingMode = true;
    private boolean substitute = false;

    public PatternTerminalPart(class_1799 is) {
        super(is);
    }

    @Override
    public void getDrops(List<class_1799> drops, boolean wrenched) {
        for (class_1799 is : this.pattern) {
            if (is.method_7960()) continue;
            drops.add(is);
        }
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.setCraftingRecipe(data.method_10577("craftingMode"));
        this.setSubstitution(data.method_10577("substitute"));
        this.pattern.readFromNBT(data, "pattern");
        this.output.readFromNBT(data, "outputList");
        this.crafting.readFromNBT(data, "craftingGrid");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10556("craftingMode", this.craftingMode);
        data.method_10556("substitute", this.substitute);
        this.pattern.writeToNBT(data, "pattern");
        this.output.writeToNBT(data, "outputList");
        this.crafting.writeToNBT(data, "craftingGrid");
    }

    @Override
    public class_3917<?> getContainerType(class_1657 p) {
        if (Platform.checkPermissions(p, this, SecurityPermissions.CRAFT, false)) {
            return PatternTermContainer.TYPE;
        }
        return MEMonitorableContainer.TYPE;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removedStack, class_1799 newStack) {
        if (inv == this.pattern && slot == 1) {
            class_1799 is = this.pattern.getInvStack(1);
            ICraftingPatternDetails details = Api.instance().crafting().decodePattern(is, this.getHost().getTile().method_10997());
            if (details != null) {
                IAEItemStack item;
                int x;
                this.setCraftingRecipe(details.isCraftable());
                this.setSubstitution(details.canSubstitute());
                for (x = 0; x < this.crafting.getSlotCount() && x < details.getSparseInputs().length; ++x) {
                    item = details.getSparseInputs()[x];
                    this.crafting.forceSetInvStack(x, item == null ? class_1799.field_8037 : item.createItemStack());
                }
                for (x = 0; x < this.output.getSlotCount() && x < details.getSparseOutputs().length; ++x) {
                    item = details.getSparseOutputs()[x];
                    this.output.forceSetInvStack(x, item == null ? class_1799.field_8037 : item.createItemStack());
                }
            }
        } else if (inv == this.crafting) {
            this.fixCraftingRecipes();
        }
        this.getHost().markForSave();
    }

    private void fixCraftingRecipes() {
        if (this.craftingMode) {
            for (int x = 0; x < this.crafting.getSlotCount(); ++x) {
                class_1799 is = this.crafting.getInvStack(x);
                if (is.method_7960()) continue;
                is.method_7939(1);
            }
        }
    }

    public boolean isCraftingRecipe() {
        return this.craftingMode;
    }

    public void setCraftingRecipe(boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.fixCraftingRecipes();
    }

    public boolean isSubstitution() {
        return this.substitute;
    }

    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("output")) {
            return this.output;
        }
        if (name.equals("pattern")) {
            return this.pattern;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }
}

