/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IMaterials;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public final class DisassembleRecipe
extends class_1852 {
    public static final class_1865<DisassembleRecipe> SERIALIZER = new class_1866(DisassembleRecipe::new);
    private static final class_1799 MISMATCHED_STACK = class_1799.field_8037;
    private final Map<IItemDefinition, IItemDefinition> cellMappings;
    private final Map<IItemDefinition, IItemDefinition> nonCellMappings;

    public DisassembleRecipe(class_2960 id) {
        super(id);
        IDefinitions definitions = Api.instance().definitions();
        IBlocks blocks = definitions.blocks();
        IItems items = definitions.items();
        IMaterials mats = definitions.materials();
        this.cellMappings = new HashMap<IItemDefinition, IItemDefinition>(4);
        this.nonCellMappings = new HashMap<IItemDefinition, IItemDefinition>(5);
        this.cellMappings.put(items.cell1k(), mats.cell1kPart());
        this.cellMappings.put(items.cell4k(), mats.cell4kPart());
        this.cellMappings.put(items.cell16k(), mats.cell16kPart());
        this.cellMappings.put(items.cell64k(), mats.cell64kPart());
        this.nonCellMappings.put(items.encodedPattern(), mats.blankPattern());
        this.nonCellMappings.put(blocks.craftingStorage1k(), mats.cell1kPart());
        this.nonCellMappings.put(blocks.craftingStorage4k(), mats.cell4kPart());
        this.nonCellMappings.put(blocks.craftingStorage16k(), mats.cell16kPart());
        this.nonCellMappings.put(blocks.craftingStorage64k(), mats.cell64kPart());
    }

    public boolean matches(@Nonnull class_1715 inv, @Nonnull class_1937 w) {
        return !this.getOutput((class_1263)inv).method_7960();
    }

    @Nonnull
    private class_1799 getOutput(class_1263 inventory) {
        int itemCount = 0;
        class_1799 output = MISMATCHED_STACK;
        for (int slotIndex = 0; slotIndex < inventory.method_5439(); ++slotIndex) {
            class_1799 stackInSlot = inventory.method_5438(slotIndex);
            if (stackInSlot.method_7960()) continue;
            if (++itemCount > 1) {
                return MISMATCHED_STACK;
            }
            Optional<class_1799> maybeCellOutput = this.getCellOutput(stackInSlot);
            if (maybeCellOutput.isPresent()) {
                IItemList list;
                class_1799 storageCellStack = maybeCellOutput.get();
                ICellInventoryHandler<IAEItemStack> cellInv = Api.instance().registries().cell().getCellInventory(stackInSlot, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
                if (cellInv != null && !(list = cellInv.getAvailableItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList())).isEmpty()) {
                    return class_1799.field_8037;
                }
                output = storageCellStack;
            }
            output = this.getNonCellOutput(stackInSlot).orElse(output);
        }
        return output;
    }

    @Nonnull
    private Optional<class_1799> getCellOutput(class_1799 compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.cellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<class_1799> getNonCellOutput(class_1799 compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.nonCellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.empty();
    }

    @Nonnull
    public class_1799 craft(@Nonnull class_1715 inv) {
        return this.getOutput((class_1263)inv);
    }

    public boolean method_8113(int i, int i1) {
        return false;
    }

    @Nonnull
    public class_1865<DisassembleRecipe> method_8119() {
        return SERIALIZER;
    }
}

