/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.core.AEConfig;
import appeng.recipes.handlers.GrinderOptionalResult;
import appeng.recipes.handlers.GrinderRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class GrinderRecipeSerializer
implements class_1865<GrinderRecipe> {
    public static final GrinderRecipeSerializer INSTANCE = new GrinderRecipeSerializer();

    private GrinderRecipeSerializer() {
    }

    public GrinderRecipe read(class_2960 recipeId, JsonObject json) {
        String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
        JsonObject inputObj = class_3518.method_15296((JsonObject)json, (String)"input");
        class_1856 ingredient = class_1856.method_8102((JsonElement)inputObj);
        int ingredientCount = 1;
        if (inputObj.has("count")) {
            ingredientCount = inputObj.get("count").getAsInt();
        }
        JsonObject result = class_3518.method_15296((JsonObject)json, (String)"result");
        class_1799 primaryResult = class_1869.method_8155((JsonObject)class_3518.method_15296((JsonObject)result, (String)"primary"));
        JsonArray optionalResultsJson = class_3518.method_15292((JsonObject)result, (String)"optional", null);
        List<GrinderOptionalResult> optionalResults = Collections.emptyList();
        if (optionalResultsJson != null) {
            optionalResults = new ArrayList(optionalResultsJson.size());
            for (JsonElement optionalResultJson : optionalResultsJson) {
                if (!optionalResultJson.isJsonObject()) {
                    throw new IllegalStateException("Entry in optional result list should be an object.");
                }
                class_1799 optionalResultItem = class_1869.method_8155((JsonObject)optionalResultJson.getAsJsonObject());
                float optionalChance = class_3518.method_15277((JsonObject)optionalResultJson.getAsJsonObject(), (String)"percentageChance", (float)AEConfig.instance().getOreDoublePercentage()) / 100.0f;
                optionalResults.add(new GrinderOptionalResult(optionalChance, optionalResultItem));
            }
        }
        int turns = class_3518.method_15282((JsonObject)json, (String)"turns", (int)8);
        return new GrinderRecipe(recipeId, group, ingredient, ingredientCount, primaryResult, turns, optionalResults);
    }

    @Nullable
    public GrinderRecipe read(class_2960 recipeId, class_2540 buffer) {
        String group = buffer.method_10800(Short.MAX_VALUE);
        class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
        int ingredientCount = buffer.method_10816();
        class_1799 result = buffer.method_10819();
        int turns = buffer.method_10816();
        int optionalResultsCount = buffer.method_10816();
        ArrayList<GrinderOptionalResult> optionalResults = new ArrayList<GrinderOptionalResult>(optionalResultsCount);
        for (int i = 0; i < optionalResultsCount; ++i) {
            float chance = buffer.readFloat();
            class_1799 optionalResult = buffer.method_10819();
            optionalResults.add(new GrinderOptionalResult(chance, optionalResult));
        }
        return new GrinderRecipe(recipeId, group, ingredient, ingredientCount, result, turns, optionalResults);
    }

    public void write(class_2540 buffer, GrinderRecipe recipe) {
        buffer.method_10814(recipe.method_8112());
        recipe.getIngredient().method_8088(buffer);
        buffer.method_10804(recipe.getIngredientCount());
        buffer.method_10793(recipe.method_8110());
        buffer.method_10804(recipe.getTurns());
        List<GrinderOptionalResult> optionalResults = recipe.getOptionalResults();
        buffer.method_10804(optionalResults.size());
        for (GrinderOptionalResult optionalResult : optionalResults) {
            buffer.writeFloat(optionalResult.getChance());
            buffer.method_10793(optionalResult.getResult());
        }
    }
}

