/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.api.features.AEFeature;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.server.ISubCommand;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class ChunkLogger
implements ISubCommand {
    private boolean enabled = false;
    private boolean listenerRegistered = false;

    private void onChunkLoadEvent(class_3218 world, class_2818 chunk) {
        if (!this.enabled) {
            return;
        }
        AELog.info("Chunk Loaded:   " + chunk.method_12004().field_9181 + ", " + chunk.method_12004().field_9180, new Object[0]);
        this.displayStack();
    }

    private void onChunkUnloadEvent(class_3218 world, class_2818 chunk) {
        if (!this.enabled) {
            return;
        }
        AELog.info("Chunk Unloaded: " + chunk.method_12004().field_9181 + ", " + chunk.method_12004().field_9180, new Object[0]);
        this.displayStack();
    }

    private void displayStack() {
        if (AEConfig.instance().isFeatureEnabled(AEFeature.CHUNK_LOGGER_TRACE)) {
            boolean output = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                if (output) {
                    AELog.info("\t\t" + e.getClassName() + '.' + e.getMethodName() + " (" + e.getLineNumber() + ')', new Object[0]);
                    continue;
                }
                output = e.getClassName().contains("EventBus") && e.getMethodName().contains("post");
            }
        }
    }

    @Override
    public synchronized void call(MinecraftServer srv, CommandContext<class_2168> data, class_2168 sender) {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            if (!this.listenerRegistered) {
                ServerChunkEvents.CHUNK_LOAD.register(this::onChunkLoadEvent);
                ServerChunkEvents.CHUNK_UNLOAD.register(this::onChunkUnloadEvent);
                this.listenerRegistered = true;
            }
            sender.method_9226((class_2561)new class_2588("commands.ae2.ChunkLoggerOn"), true);
        } else {
            sender.method_9226((class_2561)new class_2588("commands.ae2.ChunkLoggerOff"), true);
        }
    }
}

