/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.worlddata.WorldData;
import appeng.items.storage.SpatialStorageCellItem;
import appeng.server.ISubCommand;
import appeng.spatial.SpatialStorageDimensionIds;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStoragePlotManager;
import appeng.spatial.TransitionInfo;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class SpatialStorageCommand
implements ISubCommand {
    @Override
    public void addArguments(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").executes(ctx -> {
            SpatialStorageCommand.showPlotInfo((class_2168)ctx.getSource(), SpatialStorageCommand.getCurrentPlot((class_2168)ctx.getSource()));
            return 1;
        })).then(class_2170.method_9244((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            SpatialStorageCommand.showPlotInfo((class_2168)ctx.getSource(), SpatialStorageCommand.getPlot(plotId));
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"tp").then(class_2170.method_9244((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            SpatialStorageCommand.teleportToPlot((class_2168)ctx.getSource(), plotId);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tpback").executes(ctx -> {
            this.teleportBack((class_2168)ctx.getSource());
            return 1;
        })).then(class_2170.method_9244((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            this.teleportBack((class_2168)ctx.getSource(), SpatialStorageCommand.getPlot(plotId));
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"givecell").then(class_2170.method_9244((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            this.giveCell((class_2168)ctx.getSource(), plotId);
            return 1;
        })));
    }

    private void teleportBack(class_2168 source) {
        if (source.method_9225().method_27983() != SpatialStorageDimensionIds.WORLD_ID) {
            throw new class_2164((class_2561)new class_2585("Must be within the spatial storage world."));
        }
        class_2338 playerPos = new class_2338(source.method_9222());
        int x = playerPos.method_10263();
        int z = playerPos.method_10260();
        for (SpatialStoragePlot plot : SpatialStoragePlotManager.INSTANCE.getPlots()) {
            class_2338 origin = plot.getOrigin();
            class_2338 size = plot.getSize();
            if (x < origin.method_10263() || x > origin.method_10263() + size.method_10263() || z < origin.method_10260() || z > origin.method_10260() + size.method_10260()) continue;
            this.teleportBack(source, plot);
            return;
        }
        throw new class_2164((class_2561)new class_2585("Couldn't find a plot for the current position."));
    }

    private void teleportBack(class_2168 source, SpatialStoragePlot plot) {
        TransitionInfo lastTransition = plot.getLastTransition();
        if (lastTransition == null) {
            throw new class_2164((class_2561)new class_2585("This plot doesn't have a last known transition."));
        }
        String command = SpatialStorageCommand.getTeleportCommand(lastTransition.getWorldId(), lastTransition.getMin().method_10069(0, 1, 0));
        SpatialStorageCommand.runCommandFor(source, command);
    }

    private static void showPlotInfo(class_2168 source, SpatialStoragePlot plot) {
        SpatialStorageCommand.sendKeyValuePair(source, "Plot ID", String.valueOf(plot.getId()));
        int playerId = plot.getOwner();
        if (playerId != -1) {
            UUID profileId = WorldData.instance().playerData().getProfileId(playerId);
            if (profileId == null) {
                SpatialStorageCommand.sendKeyValuePair(source, "Owner", "Unknown AE2 player (" + playerId + ")");
            } else {
                MinecraftServer server = AppEng.instance().getServer();
                class_3222 player = server.method_3760().method_14602(profileId);
                if (player == null) {
                    SpatialStorageCommand.sendKeyValuePair(source, "Owner", "Unknown Minecraft profile (" + profileId + ")");
                } else {
                    SpatialStorageCommand.sendKeyValuePair(source, "Owner", player.method_5476());
                }
            }
        } else {
            SpatialStorageCommand.sendKeyValuePair(source, "Owner", "Unknown");
        }
        SpatialStorageCommand.sendKeyValuePair(source, "Size", SpatialStorageCommand.formatBlockPos(plot.getSize(), "x"));
        String teleportToPlotCommand = SpatialStorageCommand.getTeleportCommand(SpatialStorageDimensionIds.WORLD_ID.method_29177(), plot.getOrigin());
        SpatialStorageCommand.sendKeyValuePair(source, "Origin", (class_2561)new class_2585(SpatialStorageCommand.formatBlockPos(plot.getOrigin(), ",")).method_27694(SpatialStorageCommand.makeCommandLink(teleportToPlotCommand, "Teleport into plot")));
        SpatialStorageCommand.sendKeyValuePair(source, "Region file:", plot.getRegionFilename());
        TransitionInfo lastTransition = plot.getLastTransition();
        if (lastTransition != null) {
            source.method_9226((class_2561)new class_2585("Last Transition:").method_27695(new class_124[]{class_124.field_1073, class_124.field_1067}), true);
            String sourceWorldId = lastTransition.getWorldId().toString();
            class_2585 sourceLink = new class_2585(sourceWorldId + " - " + SpatialStorageCommand.formatBlockPos(lastTransition.getMin(), ",") + " to " + SpatialStorageCommand.formatBlockPos(lastTransition.getMax(), ","));
            String tpCommand = SpatialStorageCommand.getTeleportCommand(lastTransition.getWorldId(), lastTransition.getMin().method_10069(0, 1, 0));
            sourceLink.method_27694(SpatialStorageCommand.makeCommandLink(tpCommand, "Click to teleport"));
            SpatialStorageCommand.sendKeyValuePair(source, "Source", (class_2561)sourceLink);
            SpatialStorageCommand.sendKeyValuePair(source, "When", lastTransition.getTimestamp().toString());
        } else {
            source.method_9226((class_2561)new class_2585("Last Transition unknown"), true);
        }
    }

    private static void teleportToPlot(class_2168 source, int plotId) {
        SpatialStoragePlot plot = SpatialStorageCommand.getPlot(plotId);
        String teleportCommand = SpatialStorageCommand.getTeleportCommand(SpatialStorageDimensionIds.WORLD_ID.method_29177(), plot.getOrigin());
        SpatialStorageCommand.runCommandFor(source, teleportCommand);
    }

    private void giveCell(class_2168 source, int plotId) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        SpatialStoragePlot plot = SpatialStorageCommand.getPlot(plotId);
        int longestSide = SpatialStorageCommand.getLongestSide(plot.getSize());
        class_1799 cell = longestSide <= 2 ? Api.instance().definitions().items().spatialCell2().stack(1) : (longestSide <= 16 ? Api.instance().definitions().items().spatialCell16().stack(1) : Api.instance().definitions().items().spatialCell128().stack(1));
        if (!(cell.method_7909() instanceof SpatialStorageCellItem)) {
            throw new class_2164((class_2561)new class_2585("Storage cell items don't implement the storage cell interface!"));
        }
        SpatialStorageCellItem spatialCellItem = (SpatialStorageCellItem)cell.method_7909();
        spatialCellItem.setStoredDimension(cell, plotId, plot.getSize());
        player.method_7270(cell);
    }

    private static int getLongestSide(class_2338 size) {
        return Math.max(size.method_10263(), Math.max(size.method_10264(), size.method_10260()));
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<class_2168> ctx, class_2168 sender) {
        ArrayList<SpatialStoragePlot> plots = new ArrayList<SpatialStoragePlot>(SpatialStoragePlotManager.INSTANCE.getPlots());
        plots.sort(Comparator.comparing(plot -> {
            TransitionInfo lastTransition = plot.getLastTransition();
            if (lastTransition != null) {
                return lastTransition.getTimestamp();
            }
            return Instant.MIN;
        }).reversed());
        for (int i = 0; i < Math.min(5, plots.size()); ++i) {
            SpatialStoragePlot plot2 = (SpatialStoragePlot)plots.get(i);
            String size = SpatialStorageCommand.formatBlockPos(plot2.getSize(), "x");
            class_2338 originPos = plot2.getOrigin();
            String origin = SpatialStorageCommand.formatBlockPos(originPos, ",");
            class_5250 infoLink = new class_2585("Plot #" + plot2.getId()).method_27694(SpatialStorageCommand.makeCommandLink("/ae2 spatial info " + plot2.getId(), "Click to show details"));
            class_5250 tpLink = new class_2585("Origin: " + origin).method_27694(SpatialStorageCommand.makeCommandLink("/ae2 spatial tp " + plot2.getId(), "Click to teleport into plot"));
            class_5250 message = new class_2585("").method_10852((class_2561)infoLink).method_27693(" Size: " + size + " ").method_10852((class_2561)tpLink);
            sender.method_9226((class_2561)message, true);
        }
    }

    private static String formatBlockPos(class_2338 size, String separator) {
        return size.method_10263() + separator + size.method_10264() + separator + size.method_10260();
    }

    private static UnaryOperator<class_2583> makeCommandLink(String command, String tooltip) {
        return style -> style.method_27706(class_124.field_1073).method_10958(new class_2558(class_2558.class_2559.field_11750, command)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(tooltip)));
    }

    private static void runCommandFor(class_2168 source, String command) {
        class_2170 commandManager = AppEng.instance().getServer().method_3734();
        commandManager.method_9249(source, command);
    }

    private static String getTeleportCommand(class_2960 worldId, class_2338 pos) {
        return "/execute in " + worldId + " run tp @s " + pos.method_10263() + " " + (pos.method_10264() + 1) + " " + pos.method_10260();
    }

    private static SpatialStoragePlot getPlot(int plotId) {
        SpatialStoragePlot plot = SpatialStoragePlotManager.INSTANCE.getPlot(plotId);
        if (plot == null) {
            throw new class_2164((class_2561)new class_2585("Plot not found: " + plotId));
        }
        return plot;
    }

    private static void sendKeyValuePair(class_2168 source, String label, class_2561 value) {
        source.method_9226((class_2561)new class_2585("").method_10852((class_2561)new class_2585(label + ": ").method_27692(class_124.field_1067)).method_10852(value), true);
    }

    private static void sendKeyValuePair(class_2168 source, String label, String value) {
        SpatialStorageCommand.sendKeyValuePair(source, label, (class_2561)new class_2585(value));
    }

    private static SpatialStoragePlot getCurrentPlot(class_2168 source) {
        if (source.method_9225().method_27983() != SpatialStorageDimensionIds.WORLD_ID) {
            throw new class_2164((class_2561)new class_2585("Must be within the spatial storage world."));
        }
        class_2338 playerPos = new class_2338(source.method_9222());
        int x = playerPos.method_10263();
        int z = playerPos.method_10260();
        for (SpatialStoragePlot plot : SpatialStoragePlotManager.INSTANCE.getPlots()) {
            class_2338 origin = plot.getOrigin();
            class_2338 size = plot.getSize();
            if (x < origin.method_10263() || x > origin.method_10263() + size.method_10263() || z < origin.method_10260() || z > origin.method_10260() + size.method_10260()) continue;
            return plot;
        }
        throw new class_2164((class_2561)new class_2585("Couldn't find a plot for the current position."));
    }
}

