/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.Api;
import appeng.server.ISubCommand;
import com.google.common.math.StatsAccumulator;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TestOreGenCommand
implements ISubCommand {
    private final class_2680 quartzOre = Api.INSTANCE.definitions().blocks().quartzOre().block().method_9564();
    private final class_2680 chargedQuartzOre = Api.INSTANCE.definitions().blocks().quartzOreCharged().block().method_9564();

    @Override
    public void call(MinecraftServer srv, CommandContext<class_2168> data, class_2168 sender) {
        class_2338 center;
        class_3218 world;
        int radius = 1000;
        try {
            class_3222 player = sender.method_9207();
            world = player.method_14220();
            center = new class_2338(player.method_23317(), 0.0, player.method_23321());
        }
        catch (CommandSyntaxException e) {
            world = srv.method_30002();
            center = world.method_27911();
        }
        class_1923 tl = new class_1923(center.method_10069(-radius, 0, -radius));
        class_1923 br = new class_1923(center.method_10069(radius, 0, radius));
        Stats stats = new Stats();
        for (int cx = tl.field_9181; cx <= br.field_9181; ++cx) {
            for (int cz = tl.field_9180; cz <= br.field_9180; ++cz) {
                class_1923 cp = new class_1923(cx, cz);
                this.checkChunk(sender, world, cp, stats);
            }
        }
        AggregatedStats oreCount = AggregatedStats.create(stats.chunks, cs -> cs.quartzOreCount);
        List chunksWithOre = stats.chunks.stream().filter(c -> c.quartzOreCount > 0).collect(Collectors.toList());
        AggregatedStats minHeight = AggregatedStats.create(chunksWithOre, cs -> cs.minHeight);
        AggregatedStats maxHeight = AggregatedStats.create(chunksWithOre, cs -> cs.maxHeight);
        AggregatedStats chargedCount = AggregatedStats.create(chunksWithOre, cs -> cs.chargedOreCount);
        TestOreGenCommand.sendLine(sender, "Checked %d chunks", stats.chunks.size());
        TestOreGenCommand.sendLine(sender, "  Count: %s", oreCount);
        TestOreGenCommand.sendLine(sender, "  Min-Height: %s", minHeight);
        TestOreGenCommand.sendLine(sender, "  Max-Height: %s", maxHeight);
        TestOreGenCommand.sendLine(sender, "  Sub-Type Count: %s", chargedCount);
    }

    private void checkChunk(class_2168 sender, class_3218 world, class_1923 cp, Stats stats) {
        class_2791 chunk = world.method_8402(cp.field_9181, cp.field_9180, class_2806.field_12803, false);
        if (chunk == null) {
            TestOreGenCommand.sendLine(sender, "Skipping chunk %s", cp);
            return;
        }
        ChunkStats chunkStats = new ChunkStats();
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        TestOreGenCommand.sendLine(sender, "Checking chunk %s", cp);
        for (int x = cp.method_8326(); x <= cp.method_8327(); ++x) {
            blockPos.method_20787(x);
            for (int z = cp.method_8328(); z <= cp.method_8329(); ++z) {
                blockPos.method_20788(z);
                for (int y = 0; y < world.method_8322(); ++y) {
                    blockPos.method_10099(y);
                    class_2680 state = chunk.method_8320((class_2338)blockPos);
                    if (state != this.quartzOre && state != this.chargedQuartzOre) continue;
                    chunkStats.minHeight = Math.min(chunkStats.minHeight, y);
                    chunkStats.maxHeight = Math.max(chunkStats.maxHeight, y);
                    ++chunkStats.quartzOreCount;
                    if (state != this.chargedQuartzOre) continue;
                    ++chunkStats.chargedOreCount;
                }
            }
        }
        stats.chunks.add(chunkStats);
    }

    private static void sendLine(class_2168 sender, String text, Object ... args) {
        sender.method_9226((class_2561)new class_2585(String.format(Locale.ROOT, text, args)), true);
    }

    private static class AggregatedStats {
        public final double min;
        public final double max;
        public final double mean;
        public final double stdDev;

        public AggregatedStats(double min, double max, double mean, double stdDev) {
            this.min = min;
            this.max = max;
            this.mean = mean;
            this.stdDev = stdDev;
        }

        public static <T> AggregatedStats create(List<T> values, ToDoubleFunction<T> getter) {
            if (values.isEmpty()) {
                return new AggregatedStats(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
            }
            StatsAccumulator accumulator = new StatsAccumulator();
            for (T value : values) {
                accumulator.add(getter.applyAsDouble(value));
            }
            return new AggregatedStats(accumulator.min(), accumulator.max(), accumulator.mean(), accumulator.populationStandardDeviation());
        }

        public String toString() {
            if (Double.isNaN(this.min)) {
                return "Invalid";
            }
            return String.format(Locale.ROOT, "min=%.2f, max=%.2f, mean=%.2f, stdDev=%.2f", this.min, this.max, this.mean, this.stdDev);
        }
    }

    private static class ChunkStats {
        public int quartzOreCount = 0;
        public int chargedOreCount = 0;
        public int minHeight = Integer.MAX_VALUE;
        public int maxHeight = Integer.MIN_VALUE;

        private ChunkStats() {
        }
    }

    private static class Stats {
        public final List<ChunkStats> chunks = new ArrayList<ChunkStats>();

        private Stats() {
        }
    }
}

