/*
 * Decompiled with CFR 0.152.
 */
package appeng.services;

import appeng.api.util.DimensionalCoord;
import appeng.core.Api;
import appeng.services.compass.CompassReader;
import appeng.services.compass.ICompassCallback;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_5425;
import net.minecraft.server.MinecraftServer;

public final class CompassService {
    private static final int CHUNK_SIZE = 16;
    private final MinecraftServer server;
    private final WeakHashMap<class_3218, CompassReader> worldSet = new WeakHashMap(10);
    private final ExecutorService executor;
    private int jobSize;

    public CompassService(MinecraftServer server, @Nonnull ThreadFactory factory) {
        this.server = server;
        this.executor = Executors.newSingleThreadExecutor(factory);
        this.jobSize = 0;
    }

    public Future<?> getCompassDirection(DimensionalCoord coord, int maxRange, ICompassCallback cc) {
        ++this.jobSize;
        return this.executor.submit(new CMDirectionRequest(coord, maxRange, cc));
    }

    private int jobSize() {
        return this.jobSize;
    }

    private void cleanUp() {
        for (CompassReader cr : this.worldSet.values()) {
            cr.close();
        }
    }

    public void tryUpdateArea(class_5425 w, class_1923 chunkPos) {
        class_2791 chunk = w.method_8392(chunkPos.field_9181, chunkPos.field_9180);
        this.updateArea(w.method_8410(), chunk);
    }

    public void updateArea(class_3218 w, class_2791 chunk) {
        this.updateArea(w, chunk, 16);
        this.updateArea(w, chunk, 48);
        this.updateArea(w, chunk, 80);
        this.updateArea(w, chunk, 112);
        this.updateArea(w, chunk, 144);
        this.updateArea(w, chunk, 176);
        this.updateArea(w, chunk, 208);
        this.updateArea(w, chunk, 240);
    }

    public void notifyBlockChange(class_3218 w, class_2338 pos) {
        class_2791 chunk = w.method_22350(pos);
        this.updateArea(w, chunk, pos.method_10264());
    }

    private Future<?> updateArea(class_3218 w, class_2791 c, int y) {
        ++this.jobSize;
        int cdy = y >> 5;
        int low_y = cdy << 5;
        int hi_y = low_y + 32;
        int cx = c.method_12004().field_9181;
        int cz = c.method_12004().field_9180;
        class_2248 skyStoneBlock = Api.instance().definitions().blocks().skyStoneBlock().block();
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int i = 0; i < 16; ++i) {
            pos.method_20787(i);
            for (int j = 0; j < 16; ++j) {
                pos.method_20788(j);
                for (int k = low_y; k < hi_y; ++k) {
                    pos.method_10099(k);
                    class_2248 blk = c.method_8320((class_2338)pos).method_26204();
                    if (blk != skyStoneBlock) continue;
                    return this.executor.submit(new CMUpdatePost(w, cx, cz, cdy, true));
                }
            }
        }
        return this.executor.submit(new CMUpdatePost(w, cx, cz, cdy, false));
    }

    public void kill() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(6L, TimeUnit.MINUTES);
            this.jobSize = 0;
            for (CompassReader cr : this.worldSet.values()) {
                cr.close();
            }
            this.worldSet.clear();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private CompassReader getReader(class_3218 world) {
        CompassReader cr = this.worldSet.get(world);
        if (cr == null) {
            cr = new CompassReader(world);
            this.worldSet.put(world, cr);
        }
        return cr;
    }

    private int dist(int ax, int az, int bx, int bz) {
        int up = (bz - az) * 16;
        int side = (bx - ax) * 16;
        return up * up + side * side;
    }

    private double rad(int ax, int az, int bx, int bz) {
        int up = bz - az;
        int side = bx - ax;
        return Math.atan2(-up, side) - 1.5707963267948966;
    }

    private class CMDirectionRequest
    implements Runnable {
        public final int maxRange;
        public final DimensionalCoord coord;
        public final ICompassCallback callback;

        public CMDirectionRequest(DimensionalCoord coord, int getMaxRange, ICompassCallback cc) {
            this.coord = coord;
            this.maxRange = getMaxRange;
            this.callback = cc;
        }

        @Override
        public void run() {
            class_3218 world = (class_3218)this.coord.getWorld();
            CompassService.this.jobSize--;
            int cx = this.coord.x >> 4;
            int cz = this.coord.z >> 4;
            CompassReader cr = CompassService.this.getReader(world);
            if (cr.hasBeacon(cx, cz)) {
                this.callback.calculatedDirection(true, true, -999.0, 0.0);
                if (CompassService.this.jobSize() < 2) {
                    CompassService.this.cleanUp();
                }
                return;
            }
            for (int offset = 1; offset < this.maxRange; ++offset) {
                int closeness;
                int minX = cx - offset;
                int minZ = cz - offset;
                int maxX = cx + offset;
                int maxZ = cz + offset;
                int closest = Integer.MAX_VALUE;
                int chosen_x = cx;
                int chosen_z = cz;
                for (int z = minZ; z <= maxZ; ++z) {
                    if (cr.hasBeacon(minX, z) && (closeness = CompassService.this.dist(cx, cz, minX, z)) < closest) {
                        closest = closeness;
                        chosen_x = minX;
                        chosen_z = z;
                    }
                    if (!cr.hasBeacon(maxX, z) || (closeness = CompassService.this.dist(cx, cz, maxX, z)) >= closest) continue;
                    closest = closeness;
                    chosen_x = maxX;
                    chosen_z = z;
                }
                for (int x = minX + 1; x < maxX; ++x) {
                    if (cr.hasBeacon(x, minZ) && (closeness = CompassService.this.dist(cx, cz, x, minZ)) < closest) {
                        closest = closeness;
                        chosen_x = x;
                        chosen_z = minZ;
                    }
                    if (!cr.hasBeacon(x, maxZ) || (closeness = CompassService.this.dist(cx, cz, x, maxZ)) >= closest) continue;
                    closest = closeness;
                    chosen_x = x;
                    chosen_z = maxZ;
                }
                if (closest >= Integer.MAX_VALUE) continue;
                this.callback.calculatedDirection(true, false, CompassService.this.rad(cx, cz, chosen_x, chosen_z), CompassService.this.dist(cx, cz, chosen_x, chosen_z));
                if (CompassService.this.jobSize() < 2) {
                    CompassService.this.cleanUp();
                }
                return;
            }
            this.callback.calculatedDirection(false, true, -999.0, 999.0);
            if (CompassService.this.jobSize() < 2) {
                CompassService.this.cleanUp();
            }
        }
    }

    private class CMUpdatePost
    implements Runnable {
        public final class_3218 world;
        public final int chunkX;
        public final int chunkZ;
        public final int doubleChunkY;
        public final boolean value;

        public CMUpdatePost(class_3218 world, int cx, int cz, int dcy, boolean val) {
            this.world = world;
            this.chunkX = cx;
            this.doubleChunkY = dcy;
            this.chunkZ = cz;
            this.value = val;
        }

        @Override
        public void run() {
            CompassService.this.jobSize--;
            CompassReader cr = CompassService.this.getReader(this.world);
            cr.setHasBeacon(this.chunkX, this.chunkZ, this.doubleChunkY, this.value);
            if (CompassService.this.jobSize() < 2) {
                CompassService.this.cleanUp();
            }
        }
    }
}

