/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.compass;

import appeng.services.compass.CompassRegion;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3218;

public final class CompassReader {
    private final Map<Long, CompassRegion> regions = new HashMap<Long, CompassRegion>(100);
    private final class_3218 world;

    public CompassReader(class_3218 world) {
        this.world = (class_3218)Preconditions.checkNotNull((Object)world);
    }

    public void close() {
        for (CompassRegion r : this.regions.values()) {
            r.close();
        }
        this.regions.clear();
    }

    public void setHasBeacon(int cx, int cz, int cdy, boolean hasBeacon) {
        CompassRegion r = this.getRegion(cx, cz);
        r.setHasBeacon(cx, cz, cdy, hasBeacon);
    }

    public boolean hasBeacon(int cx, int cz) {
        CompassRegion r = this.getRegion(cx, cz);
        return r.hasBeacon(cx, cz);
    }

    private CompassRegion getRegion(int cx, int cz) {
        long pos = cx >> 10;
        pos <<= 32;
        CompassRegion cr = this.regions.get(pos |= (long)(cz >> 10));
        if (cr == null) {
            cr = new CompassRegion(this.world, cx, cz);
            this.regions.put(pos, cr);
        }
        return cr;
    }
}

