/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.compass;

import com.google.common.base.Preconditions;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

final class CompassRegion {
    private final int lowX;
    private final int lowZ;
    private final class_3218 world;
    private SaveData data;

    public CompassRegion(class_3218 world, int cx, int cz) {
        Preconditions.checkNotNull((Object)world);
        this.world = world;
        int region_x = cx >> 10;
        int region_z = cz >> 10;
        this.lowX = region_x << 10;
        this.lowZ = region_z << 10;
        this.openData(false);
    }

    void close() {
        if (this.data != null) {
            this.data = null;
        }
    }

    boolean hasBeacon(int cx, int cz) {
        if (this.data != null) {
            int val = this.read(cx &= 0x3FF, cz &= 0x3FF);
            return val != 0;
        }
        return false;
    }

    void setHasBeacon(int cx, int cz, int cdy, boolean hasBeacon) {
        cx &= 0x3FF;
        cz &= 0x3FF;
        this.openData(hasBeacon);
        if (this.data != null) {
            int val;
            int originalVal = val = this.read(cx, cz);
            val = hasBeacon ? (val |= 1 << cdy) : (val &= ~(1 << cdy));
            if (originalVal != val) {
                this.write(cx, cz, val);
            }
        }
    }

    private void openData(boolean create) {
        if (this.data != null) {
            return;
        }
        String name = this.lowX + "_" + this.lowZ;
        if (create) {
            this.data = (SaveData)this.world.method_17983().method_17924(() -> new SaveData(name), name);
            if (this.data.bitmap == null) {
                SaveData.access$002(this.data, new byte[0x100000]);
            }
        } else {
            this.data = (SaveData)this.world.method_17983().method_20786(() -> new SaveData(name), name);
        }
    }

    private int read(int cx, int cz) {
        try {
            return this.data.bitmap[cx + cz * 1024];
        }
        catch (IndexOutOfBoundsException outOfBounds) {
            return 0;
        }
    }

    private void write(int cx, int cz, int val) {
        ((SaveData)this.data).bitmap[cx + cz * 1024] = (byte)val;
        this.data.method_80();
    }

    private static class SaveData
    extends class_18 {
        private static final int BITMAP_LENGTH = 0x100000;
        private byte[] bitmap;

        public SaveData(String name) {
            super(name);
        }

        public void method_77(class_2487 nbt) {
            this.bitmap = nbt.method_10547("b");
            if (this.bitmap.length != 0x100000) {
                throw new IllegalStateException("Invalid bitmap length: " + this.bitmap.length);
            }
        }

        public class_2487 method_75(class_2487 compound) {
            compound.method_10570("b", this.bitmap);
            return compound;
        }

        static /* synthetic */ byte[] access$002(SaveData x0, byte[] x1) {
            x0.bitmap = x1;
            return x1;
        }
    }
}

