/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.movable.IMovableHandler;
import appeng.api.movable.IMovableRegistry;
import appeng.api.util.AEPartLocation;
import appeng.api.util.WorldCoord;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.worlddata.WorldData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_1949;
import net.minecraft.class_1951;
import net.minecraft.class_1954;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2672;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3000;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3227;
import net.minecraft.class_3568;

public class CachedPlane {
    private final int x_size;
    private final int z_size;
    private final int cx_size;
    private final int cz_size;
    private final int x_offset;
    private final int y_offset;
    private final int z_offset;
    private final int y_size;
    private final class_2818[][] myChunks;
    private final Column[][] myColumns;
    private final List<class_2586> tiles = new ArrayList<class_2586>();
    private final List<class_1954<class_2248>> ticks = new ArrayList<class_1954<class_2248>>();
    private final class_3218 world;
    private final IMovableRegistry reg = Api.instance().registries().movable();
    private final List<WorldCoord> updates = new ArrayList<WorldCoord>();
    private int verticalBits;
    private final class_2680 matrixBlockState;

    public CachedPlane(class_3218 w, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        class_2248 matrixFrameBlock = Api.instance().definitions().blocks().matrixFrame().maybeBlock().orElse(null);
        this.matrixBlockState = matrixFrameBlock != null ? matrixFrameBlock.method_9564() : null;
        this.world = w;
        this.x_size = maxX - minX + 1;
        this.y_size = maxY - minY + 1;
        this.z_size = maxZ - minZ + 1;
        this.x_offset = minX;
        this.y_offset = minY;
        this.z_offset = minZ;
        int minCX = minX >> 4;
        int minCY = minY >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCY = maxY >> 4;
        int maxCZ = maxZ >> 4;
        this.cx_size = maxCX - minCX + 1;
        int cy_size = maxCY - minCY + 1;
        this.cz_size = maxCZ - minCZ + 1;
        this.myChunks = new class_2818[this.cx_size][this.cz_size];
        this.myColumns = new Column[this.x_size][this.z_size];
        this.verticalBits = 0;
        for (int cy = 0; cy < cy_size; ++cy) {
            this.verticalBits |= 1 << minCY + cy;
        }
        for (int x = 0; x < this.x_size; ++x) {
            for (int z = 0; z < this.z_size; ++z) {
                this.myColumns[x][z] = new Column((class_2791)w.method_8497(minX + x >> 4, minZ + z >> 4), minX + x & 0xF, minZ + z & 0xF, minCY, cy_size);
            }
        }
        IMovableRegistry mr = Api.instance().registries().movable();
        for (int cx = 0; cx < this.cx_size; ++cx) {
            for (int cz = 0; cz < this.cz_size; ++cz) {
                class_2818 c;
                ArrayList<class_2338> deadTiles = new ArrayList<class_2338>();
                this.myChunks[cx][cz] = c = w.method_8497(minCX + cx, minCZ + cz);
                Set blockEntityPositions = c.method_12021();
                for (class_2338 tePOS : blockEntityPositions) {
                    class_2586 te = c.method_8321(tePOS);
                    if (te == null || tePOS.method_10263() < minX || tePOS.method_10263() > maxX || tePOS.method_10264() < minY || tePOS.method_10264() > maxY || tePOS.method_10260() < minZ || tePOS.method_10260() > maxZ) continue;
                    if (mr.askToMove(te)) {
                        this.tiles.add(te);
                        deadTiles.add(tePOS);
                        continue;
                    }
                    BlockStorageData details = new BlockStorageData();
                    this.myColumns[tePOS.method_10263() - minX][tePOS.method_10260() - minZ].fillData(tePOS.method_10264(), details);
                    if (details.state.method_26215()) {
                        w.method_8650(tePOS, false);
                        continue;
                    }
                    this.myColumns[tePOS.method_10263() - minX][tePOS.method_10260() - minZ].setSkip(tePOS.method_10264());
                }
                for (class_2338 cp : deadTiles) {
                    c.method_12041(cp);
                }
                long gameTime = this.getWorld().method_8510();
                class_1951 pendingBlockTicks = this.getWorld().method_8397();
                if (!(pendingBlockTicks instanceof class_1949)) continue;
                List pending = ((class_1949)pendingBlockTicks).method_8671(c.method_12004(), false, true);
                for (class_1954 entry : pending) {
                    class_2338 tePOS = entry.field_9322;
                    if (tePOS.method_10263() < minX || tePOS.method_10263() > maxX || tePOS.method_10264() < minY || tePOS.method_10264() > maxY || tePOS.method_10260() < minZ || tePOS.method_10260() > maxZ) continue;
                    this.ticks.add((class_1954<class_2248>)new class_1954(tePOS, entry.method_8683(), entry.field_9321 - gameTime, entry.field_9320));
                }
            }
        }
        for (class_2586 te : this.tiles) {
            try {
                this.getWorld().field_9231.remove(te);
                if (!(te instanceof class_3000)) continue;
                this.getWorld().field_9246.remove(te);
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    private IMovableHandler getHandler(class_2586 te) {
        IMovableRegistry mr = Api.instance().registries().movable();
        return mr.getHandler(te);
    }

    void swap(CachedPlane dst) {
        IMovableRegistry mr = Api.instance().registries().movable();
        if (dst.x_size == this.x_size && dst.y_size == this.y_size && dst.z_size == this.z_size) {
            AELog.info("Block Copy Scale: " + this.x_size + ", " + this.y_size + ", " + this.z_size, new Object[0]);
            long startTime = System.nanoTime();
            BlockStorageData aD = new BlockStorageData();
            BlockStorageData bD = new BlockStorageData();
            for (int x = 0; x < this.x_size; ++x) {
                for (int z = 0; z < this.z_size; ++z) {
                    Column a = this.myColumns[x][z];
                    Column b = dst.myColumns[x][z];
                    for (int y = 0; y < this.y_size; ++y) {
                        int n = y + this.y_offset;
                        int dst_y = y + dst.y_offset;
                        if (a.doNotSkip(n) && b.doNotSkip(dst_y)) {
                            a.fillData(n, aD);
                            b.fillData(dst_y, bD);
                            a.setBlockState(n, bD);
                            b.setBlockState(dst_y, aD);
                            continue;
                        }
                        this.markForUpdate(x + this.x_offset, n, z + this.z_offset);
                        dst.markForUpdate(x + dst.x_offset, dst_y, z + dst.z_offset);
                    }
                }
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            AELog.info("Block Copy Time: " + duration, new Object[0]);
            for (class_2586 class_25862 : this.tiles) {
                class_2338 tePOS = class_25862.method_11016();
                dst.addTile(tePOS.method_10263() - this.x_offset, tePOS.method_10264() - this.y_offset, tePOS.method_10260() - this.z_offset, class_25862, this, mr);
            }
            for (class_2586 class_25863 : dst.tiles) {
                class_2338 tePOS = class_25863.method_11016();
                this.addTile(tePOS.method_10263() - dst.x_offset, tePOS.method_10264() - dst.y_offset, tePOS.method_10260() - dst.z_offset, class_25863, dst, mr);
            }
            for (class_1954 class_19542 : this.ticks) {
                class_2338 tePOS = class_19542.field_9322;
                dst.addTick(tePOS.method_10263() - this.x_offset, tePOS.method_10264() - this.y_offset, tePOS.method_10260() - this.z_offset, (class_1954<class_2248>)class_19542);
            }
            for (class_1954 class_19543 : dst.ticks) {
                class_2338 tePOS = class_19543.field_9322;
                this.addTick(tePOS.method_10263() - dst.x_offset, tePOS.method_10264() - dst.y_offset, tePOS.method_10260() - dst.z_offset, (class_1954<class_2248>)class_19543);
            }
            startTime = System.nanoTime();
            this.updateChunks();
            dst.updateChunks();
            endTime = System.nanoTime();
            duration = endTime - startTime;
            AELog.info("Update Time: " + duration, new Object[0]);
        }
    }

    private void markForUpdate(int x, int y, int z) {
        this.updates.add(new WorldCoord(x, y, z));
        for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
            this.updates.add(new WorldCoord(x + d.xOffset, y + d.yOffset, z + d.zOffset));
        }
    }

    private void addTick(int x, int y, int z, class_1954<class_2248> entry) {
        class_2338 where = new class_2338(x + this.x_offset, y + this.y_offset, z + this.z_offset);
        this.world.method_14196().method_8675(where, entry.method_8683(), (int)entry.field_9321, entry.field_9320);
    }

    private void addTile(int x, int y, int z, class_2586 te, CachedPlane alternateDestination, IMovableRegistry mr) {
        block5: {
            try {
                Column c = this.myColumns[x][z];
                if (c.doNotSkip(y + this.y_offset) || alternateDestination == null) {
                    IMovableHandler handler = this.getHandler(te);
                    try {
                        handler.moveTile(te, (class_1937)this.world, new class_2338(x + this.x_offset, y + this.y_offset, z + this.z_offset));
                    }
                    catch (Throwable e) {
                        AELog.debug(e);
                        class_2338 pos = new class_2338(x, y, z);
                        c.c.method_12007(pos, te);
                        this.world.method_8413(pos, this.world.method_8320(pos), this.world.method_8320(pos), z);
                    }
                    mr.doneMoving(te);
                    break block5;
                }
                alternateDestination.addTile(x, y, z, te, null, mr);
            }
            catch (Throwable e) {
                AELog.debug(e);
            }
        }
    }

    private void updateChunks() {
        class_3568 lightManager = this.world.method_22336();
        if (lightManager instanceof class_3227) {
            class_3227 serverLightManager = (class_3227)lightManager;
            for (int x = 0; x < this.cx_size; ++x) {
                for (int z = 0; z < this.cz_size; ++z) {
                    class_2818 c = this.myChunks[x][z];
                    serverLightManager.method_17310((class_2791)c, false);
                    c.method_12220();
                }
            }
        }
        for (int x = 0; x < this.cx_size; ++x) {
            for (int z = 0; z < this.cz_size; ++z) {
                class_2818 c = this.myChunks[x][z];
                WorldData.instance().compassData().service().updateArea((class_3218)this.getWorld(), (class_2791)c);
                class_2672 cdp = new class_2672(c, this.verticalBits);
                this.world.method_14178().field_17254.method_17210(c.method_12004(), false).forEach(spe -> spe.field_13987.method_14364((class_2596)cdp));
            }
        }
        class_3215 serverChunkProvider = this.world.method_14178();
        serverChunkProvider.method_12127(() -> false);
    }

    List<WorldCoord> getUpdates() {
        return this.updates;
    }

    class_1937 getWorld() {
        return this.world;
    }

    private class Column {
        private final int x;
        private final int z;
        private final class_2791 c;
        private List<Integer> skipThese = null;

        public Column(class_2791 chunk, int x, int z, int chunkY, int chunkHeight) {
            this.x = x;
            this.z = z;
            this.c = chunk;
            class_2826[] storage = this.c.method_12006();
            for (int ay = 0; ay < chunkHeight; ++ay) {
                int by = ay + chunkY;
                class_2826 extendedblockstorage = storage[by];
                if (extendedblockstorage != null) continue;
                extendedblockstorage = storage[by] = new class_2826(by << 4);
            }
        }

        private void setBlockState(int y, BlockStorageData data) {
            if (data.state == CachedPlane.this.matrixBlockState) {
                data.state = class_2246.field_10124.method_9564();
            }
            class_2826[] storage = this.c.method_12006();
            class_2826 extendedBlockStorage = storage[y >> 4];
            extendedBlockStorage.method_16675(this.x, y & 0xF, this.z, data.state);
        }

        private void fillData(int y, BlockStorageData data) {
            class_2826[] storage = this.c.method_12006();
            class_2826 extendedblockstorage = storage[y >> 4];
            data.state = extendedblockstorage.method_12254(this.x, y & 0xF, this.z);
        }

        private boolean doNotSkip(int y) {
            class_2826[] storage = this.c.method_12006();
            class_2826 extendedblockstorage = storage[y >> 4];
            if (CachedPlane.this.reg.isBlacklisted(extendedblockstorage.method_12254(this.x, y & 0xF, this.z).method_26204())) {
                return false;
            }
            return this.skipThese == null || !this.skipThese.contains(y);
        }

        private void setSkip(int yCoord) {
            if (this.skipThese == null) {
                this.skipThese = new ArrayList<Integer>();
            }
            this.skipThese.add(yCoord);
        }
    }

    private static class BlockStorageData {
        public class_2680 state;

        private BlockStorageData() {
        }
    }
}

