/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.spatial.TransitionInfo;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;

public class SpatialStoragePlot {
    private static final String TAG_ID = "id";
    private static final String TAG_SIZE = "size";
    private static final String TAG_OWNER = "owner";
    private static final String TAG_LAST_TRANSITION = "last_transition";
    private static final int REGION_SIZE = 512;
    public static final int MAX_SIZE = 128;
    private final int id;
    private final class_2338 size;
    private final int owner;
    @Nullable
    private TransitionInfo lastTransition;

    public SpatialStoragePlot(int id, class_2338 size, int owner) {
        this.id = id;
        this.size = size;
        this.owner = owner;
        if (size.method_10263() < 1 || size.method_10264() < 1 || size.method_10260() < 1) {
            throw new IllegalArgumentException("Plot size " + size + " is smaller than minimum size.");
        }
        if (size.method_10263() > 128 || size.method_10264() > 128 || size.method_10260() > 128) {
            throw new IllegalArgumentException("Plot size " + size + " exceeds maximum size of " + 128);
        }
    }

    public int getId() {
        return this.id;
    }

    public class_2338 getSize() {
        return this.size;
    }

    public int getOwner() {
        return this.owner;
    }

    @Nullable
    public TransitionInfo getLastTransition() {
        return this.lastTransition;
    }

    void setLastTransition(TransitionInfo info) {
        this.lastTransition = info;
    }

    public class_2338 getOrigin() {
        int signBits = this.id & 3;
        int offsetBits = this.id >> 2;
        int offsetScale = 1;
        int posx = 256;
        int posz = 256;
        while (offsetBits != 0) {
            posx += 512 * offsetScale * (offsetBits & 1);
            posz += 512 * offsetScale * (offsetBits >> 1 & 1);
            offsetBits >>= 2;
            offsetScale <<= 1;
        }
        if ((signBits & 1) != 0) {
            posz *= -1;
        }
        if ((signBits & 2) != 0) {
            posx *= -1;
        }
        return new class_2338(posx -= 64, 64, posz -= 64);
    }

    public String getRegionFilename() {
        class_2338 origin = this.getOrigin();
        class_1923 originChunk = new class_1923(origin);
        return String.format(Locale.ROOT, "r.%d.%d.mca", originChunk.method_17885(), originChunk.method_17886());
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10569(TAG_ID, this.id);
        tag.method_10566(TAG_SIZE, (class_2520)class_2512.method_10692((class_2338)this.size));
        tag.method_10569(TAG_OWNER, this.owner);
        if (this.lastTransition != null) {
            tag.method_10566(TAG_LAST_TRANSITION, (class_2520)this.lastTransition.toTag());
        }
        return tag;
    }

    public static SpatialStoragePlot fromTag(class_2487 tag) {
        int id = tag.method_10550(TAG_ID);
        class_2338 size = class_2512.method_10691((class_2487)tag.method_10562(TAG_SIZE));
        int ownerId = tag.method_10550(TAG_OWNER);
        SpatialStoragePlot plot = new SpatialStoragePlot(id, size, ownerId);
        if (tag.method_10573(TAG_LAST_TRANSITION, 10)) {
            plot.lastTransition = TransitionInfo.fromTag(tag.method_10562(TAG_LAST_TRANSITION));
        }
        return plot;
    }
}

