/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.core.AELog;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.TransitionInfo;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class SpatialStorageWorldData
extends class_18 {
    public static final String ID = "ae2_spatial_storage";
    private static final int CURRENT_FORMAT = 2;
    private static final String TAG_FORMAT = "format";
    private static final String TAG_PLOTS = "plots";
    private final Int2ObjectOpenHashMap<SpatialStoragePlot> plots = new Int2ObjectOpenHashMap();

    public SpatialStorageWorldData() {
        super(ID);
    }

    public SpatialStoragePlot getPlotById(int id) {
        return (SpatialStoragePlot)this.plots.get(id);
    }

    public List<SpatialStoragePlot> getPlots() {
        return ImmutableList.copyOf((Collection)this.plots.values());
    }

    public SpatialStoragePlot allocatePlot(class_2338 size, int owner) {
        int nextId = 1;
        IntIterator intIterator = this.plots.keySet().iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            if (id < nextId) continue;
            nextId = id + 1;
        }
        SpatialStoragePlot plot = new SpatialStoragePlot(nextId, size, owner);
        this.plots.put(nextId, (Object)plot);
        this.method_80();
        return plot;
    }

    public void removePlot(int plotId) {
        this.plots.remove(plotId);
        this.method_80();
    }

    public void setLastTransition(int plotId, TransitionInfo info) {
        SpatialStoragePlot plot = (SpatialStoragePlot)this.plots.get(plotId);
        if (plot != null) {
            plot.setLastTransition(info);
        }
        this.method_80();
    }

    public void method_77(class_2487 tag) {
        int version = tag.method_10550(TAG_FORMAT);
        if (version != 2) {
            throw new IllegalStateException("Invalid AE2 spatial info version: " + version);
        }
        class_2499 plotsTag = tag.method_10554(TAG_PLOTS, 10);
        for (class_2520 plotTag : plotsTag) {
            SpatialStoragePlot plot = SpatialStoragePlot.fromTag((class_2487)plotTag);
            if (this.plots.containsKey(plot.getId())) {
                AELog.warn("Overwriting duplicate plot id %s", plot.getId());
            }
            this.plots.put(plot.getId(), (Object)plot);
        }
    }

    public class_2487 method_75(class_2487 tag) {
        tag.method_10569(TAG_FORMAT, 2);
        class_2499 plotTags = new class_2499();
        for (SpatialStoragePlot plot : this.plots.values()) {
            plotTags.add((Object)plot.toTag());
        }
        tag.method_10566(TAG_PLOTS, (class_2520)plotTags);
        return tag;
    }
}

