/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.AttributeProvider;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.util.ICommonTile;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.model.AEModelData;
import appeng.core.AELog;
import appeng.core.features.IStackSrc;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IPriorityHost;
import appeng.hooks.TickHandler;
import appeng.tile.DeferredTileEntityUnloader;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class AEBaseBlockEntity
extends class_2586
implements IOrientable,
ICommonTile,
ICustomNameObject,
BlockEntityClientSerializable,
RenderAttachmentBlockEntity,
AttributeProvider {
    private static final ThreadLocal<WeakReference<AEBaseBlockEntity>> DROP_NO_ITEMS;
    private static final Map<Class<? extends class_2586>, IStackSrc> ITEM_STACKS;
    private int renderFragment = 0;
    @Nullable
    private String customName;
    private class_2350 forward = class_2350.field_11043;
    private class_2350 up = class_2350.field_11036;
    private boolean markDirtyQueued = false;

    protected void onChunkUnloaded() {
    }

    public AEBaseBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public static void registerTileItem(Class<? extends class_2586> c, IStackSrc wat) {
        ITEM_STACKS.put(c, wat);
    }

    public boolean dropItems() {
        WeakReference<AEBaseBlockEntity> what = DROP_NO_ITEMS.get();
        return what == null || what.get() != this;
    }

    public boolean notLoaded() {
        return !this.field_11863.method_22340(this.field_11867);
    }

    @Nonnull
    public class_2586 getTile() {
        return this;
    }

    @Nullable
    protected class_1799 getItemFromTile(Object obj) {
        IStackSrc src = ITEM_STACKS.get(obj.getClass());
        if (src == null) {
            return class_1799.field_8037;
        }
        return src.stack(1);
    }

    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.customName = data.method_10545("customName") ? data.method_10558("customName") : null;
        try {
            if (this.canBeRotated()) {
                this.forward = class_2350.valueOf((String)data.method_10558("forward"));
                this.up = class_2350.valueOf((String)data.method_10558("up"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        if (this.canBeRotated()) {
            data.method_10582("forward", this.getForward().name());
            data.method_10582("up", this.getUp().name());
        }
        if (this.customName != null) {
            data.method_10582("customName", this.customName);
        }
        return data;
    }

    public void onReady() {
    }

    private boolean readUpdateData(class_2540 stream) {
        boolean output = false;
        try {
            this.renderFragment = 100;
            output = this.readFromStream(stream);
            if ((this.renderFragment & 1) == 1) {
                output = true;
            }
            this.renderFragment = 0;
        }
        catch (Throwable t) {
            AELog.debug(t);
        }
        return output;
    }

    public class_2487 toClientTag(class_2487 data) {
        boolean finished = false;
        class_2540 stream = new class_2540(Unpooled.buffer());
        try {
            this.writeToStream(stream);
            if (stream.readableBytes() == 0) {
                finished = true;
            }
        }
        catch (Throwable t) {
            AELog.debug(t);
        }
        if (!finished) {
            stream.capacity(stream.readableBytes());
            data.method_10570("X", stream.array());
        }
        return data;
    }

    public void fromClientTag(class_2487 tag) {
        class_2540 stream = new class_2540(Unpooled.copiedBuffer((byte[])tag.method_10547("X")));
        if (this.readUpdateData(stream)) {
            this.markForUpdate();
        }
    }

    protected boolean readFromStream(class_2540 data) throws IOException {
        if (this.canBeRotated()) {
            class_2350 old_Forward = this.forward;
            class_2350 old_Up = this.up;
            byte orientation = data.readByte();
            this.forward = class_2350.values()[orientation & 7];
            this.up = class_2350.values()[orientation >> 3];
            return this.forward != old_Forward || this.up != old_Up;
        }
        return false;
    }

    protected void writeToStream(class_2540 data) throws IOException {
        if (this.canBeRotated()) {
            byte orientation = (byte)(this.up.ordinal() << 3 | this.forward.ordinal());
            data.writeByte((int)orientation);
        }
    }

    public void markForUpdate() {
        if (this.renderFragment > 0) {
            this.renderFragment |= 1;
        } else if (this.field_11863 != null && !this.method_11015() && !this.notLoaded()) {
            AEBaseTileBlock tileBlock;
            class_2680 newState;
            boolean alreadyUpdated = false;
            class_2680 currentState = this.method_11010();
            if (currentState.method_26204() instanceof AEBaseTileBlock && currentState != (newState = (tileBlock = (AEBaseTileBlock)currentState.method_26204()).getBlockEntityBlockState(currentState, this))) {
                AELog.blockUpdate(this.field_11867, currentState, newState, this);
                this.field_11863.method_8501(this.field_11867, newState);
                alreadyUpdated = true;
            }
            if (!alreadyUpdated) {
                this.field_11863.method_8413(this.field_11867, currentState, currentState, 1);
            }
        }
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public class_2350 getForward() {
        return this.forward;
    }

    @Override
    public class_2350 getUp() {
        return this.up;
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        this.forward = inForward;
        this.up = inUp;
        this.markForUpdate();
        Platform.notifyBlocksOfNeighbors(this.field_11863, this.field_11867);
        this.saveChanges();
    }

    public void onPlacement(class_1750 context) {
        class_1799 stack = context.method_8041();
        if (stack.method_7985()) {
            this.uploadSettings(SettingsFrom.DISMANTLE_ITEM, stack.method_7969());
        }
    }

    public void uploadSettings(SettingsFrom from, class_2487 compound) {
        FixedItemInv inv;
        IConfigManager cm;
        if (this instanceof IConfigurableObject && (cm = ((IConfigurableObject)((Object)this)).getConfigManager()) != null) {
            cm.readFromNBT(compound);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            pHost.setPriority(compound.method_10550("priority"));
        }
        if (this instanceof ISegmentedInventory && (inv = ((ISegmentedInventory)((Object)this)).getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            AppEngInternalAEInventory target = (AppEngInternalAEInventory)inv;
            AppEngInternalAEInventory tmp = new AppEngInternalAEInventory(null, target.getSlotCount());
            tmp.readFromNBT(compound, "config");
            for (int x = 0; x < tmp.getSlotCount(); ++x) {
                target.forceSetInvStack(x, tmp.getInvStack(x));
            }
        }
    }

    @Override
    public void getDrops(class_1937 w, class_2338 pos, List<class_1799> drops) {
    }

    public void getNoDrops(class_1937 w, class_2338 pos, List<class_1799> drops) {
    }

    public class_2487 downloadSettings(SettingsFrom from) {
        FixedItemInv inv;
        IConfigManager cm;
        class_2487 output = new class_2487();
        if (this.hasCustomInventoryName()) {
            class_2487 dsp = new class_2487();
            dsp.method_10582("Name", this.customName);
            output.method_10566("display", (class_2520)dsp);
        }
        if (this instanceof IConfigurableObject && (cm = ((IConfigurableObject)((Object)this)).getConfigManager()) != null) {
            cm.writeToNBT(output);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            output.method_10569("priority", pHost.getPriority());
        }
        if (this instanceof ISegmentedInventory && (inv = ((ISegmentedInventory)((Object)this)).getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            ((AppEngInternalAEInventory)inv).writeToNBT(output, "config");
        }
        return output.isEmpty() ? null : output;
    }

    @Override
    public class_2561 getCustomInventoryName() {
        return new class_2585(this.hasCustomInventoryName() ? this.customName : this.getClass().getSimpleName());
    }

    @Override
    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void securityBreak() {
        this.field_11863.method_22352(this.field_11867, true);
        this.disableDrops();
    }

    public boolean isClient() {
        class_1937 world = this.method_10997();
        return world == null || world.method_8608();
    }

    public void disableDrops() {
        DROP_NO_ITEMS.set(new WeakReference<AEBaseBlockEntity>(this));
    }

    public void saveChanges() {
        if (this.field_11863 != null) {
            this.field_11863.method_8524(this.field_11867, (class_2586)this);
            if (!this.markDirtyQueued) {
                TickHandler.instance().addCallable(null, this::markDirtyAtEndOfTick);
                this.markDirtyQueued = true;
            }
        }
    }

    private Object markDirtyAtEndOfTick(class_1937 w) {
        this.method_5431();
        this.markDirtyQueued = false;
        return null;
    }

    public void setName(String name) {
        this.customName = name;
    }

    public Object getRenderAttachmentData() {
        return new AEModelData(this.up, this.forward);
    }

    public void addAllAttributes(class_1937 world, class_2338 pos, class_2680 state, AttributeList<?> to) {
    }

    static {
        DeferredTileEntityUnloader.register();
        DROP_NO_ITEMS = new ThreadLocal();
        ITEM_STACKS = new HashMap<Class<? extends class_2586>, IStackSrc>();
    }
}

