/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile;

import appeng.hooks.TickHandler;
import appeng.tile.AEBaseBlockEntity;
import appeng.util.IWorldCallable;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2586;

class DeferredTileEntityUnloader
implements IWorldCallable<Void> {
    private final List<AEBaseBlockEntity> entitiesToRemove;

    public static void register() {
        ServerChunkEvents.CHUNK_UNLOAD.register((serverWorld, worldChunk) -> {
            ArrayList<AEBaseBlockEntity> entitiesToRemove = null;
            for (class_2586 value : worldChunk.method_12214().values()) {
                if (!(value instanceof AEBaseBlockEntity)) continue;
                if (entitiesToRemove == null) {
                    entitiesToRemove = new ArrayList<AEBaseBlockEntity>();
                }
                entitiesToRemove.add((AEBaseBlockEntity)value);
            }
            if (entitiesToRemove != null) {
                TickHandler.instance().addCallable((class_1936)serverWorld, new DeferredTileEntityUnloader(entitiesToRemove));
            }
        });
    }

    public DeferredTileEntityUnloader(List<AEBaseBlockEntity> entitiesToRemove) {
        this.entitiesToRemove = entitiesToRemove;
    }

    @Override
    public Void call(class_1937 world) {
        for (AEBaseBlockEntity blockEntity : this.entitiesToRemove) {
            blockEntity.onChunkUnloaded();
        }
        return null;
    }
}

