/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.config.Actionable;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.core.Api;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.CraftingCPUCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.AENetworkProxyMultiblock;
import appeng.tile.crafting.CraftingCubeModelData;
import appeng.tile.grid.AENetworkBlockEntity;
import appeng.util.Platform;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class CraftingBlockEntity
extends AENetworkBlockEntity
implements IAEMultiBlock<CraftingCPUCluster>,
IPowerChannelState {
    private final CraftingCPUCalculator calc = new CraftingCPUCalculator(this);
    private class_2487 previousState = null;
    private boolean isCoreBlock = false;
    private CraftingCPUCluster cluster;

    public CraftingBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setFlags(GridFlags.MULTIBLOCK, GridFlags.REQUIRE_CHANNEL);
        this.getProxy().setValidSides(EnumSet.noneOf(class_2350.class));
    }

    @Override
    protected AENetworkProxy createProxy() {
        return new AENetworkProxyMultiblock(this, "proxy", this.getItemFromTile(this), true);
    }

    @Override
    protected class_1799 getItemFromTile(Object obj) {
        Optional<class_1799> is = ((CraftingBlockEntity)obj).isAccelerator() ? Api.instance().definitions().blocks().craftingAccelerator().maybeStack(1) : Api.instance().definitions().blocks().craftingUnit().maybeStack(1);
        return is.orElseGet(() -> super.getItemFromTile(obj));
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.cluster != null) {
            this.cluster.updateName();
        }
    }

    public boolean isAccelerator() {
        if (this.field_11863 == null) {
            return false;
        }
        AbstractCraftingUnitBlock unit = (AbstractCraftingUnitBlock)this.field_11863.method_8320(this.field_11867).method_26204();
        return unit.type == AbstractCraftingUnitBlock.CraftingUnitType.ACCELERATOR;
    }

    @Override
    public void onReady() {
        super.onReady();
        this.getProxy().setVisualRepresentation(this.getItemFromTile(this));
        this.calc.calculateMultiblock(this.field_11863, this.field_11867);
    }

    public void updateMultiBlock(class_2338 changedPos) {
        this.calc.updateMultiblockAfterNeighborUpdate(this.field_11863, this.field_11867, changedPos);
    }

    public void updateStatus(CraftingCPUCluster c) {
        if (this.cluster != null && this.cluster != c) {
            this.cluster.breakCluster();
        }
        this.cluster = c;
        this.updateMeta(true);
    }

    public void updateMeta(boolean updateFormed) {
        class_2680 newState;
        class_2680 current;
        if (this.field_11863 == null || this.notLoaded() || this.method_11015()) {
            return;
        }
        boolean formed = this.isFormed();
        boolean power = false;
        if (this.getProxy().isReady()) {
            power = this.getProxy().isActive();
        }
        if ((current = this.field_11863.method_8320(this.field_11867)).method_26204() instanceof AbstractCraftingUnitBlock && current != (newState = (class_2680)((class_2680)current.method_11657((class_2769)AbstractCraftingUnitBlock.POWERED, (Comparable)Boolean.valueOf(power))).method_11657((class_2769)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(formed)))) {
            this.field_11863.method_8652(this.field_11867, newState, 2);
        }
        if (updateFormed) {
            if (formed) {
                this.getProxy().setValidSides(EnumSet.allOf(class_2350.class));
            } else {
                this.getProxy().setValidSides(EnumSet.noneOf(class_2350.class));
            }
        }
    }

    public boolean isFormed() {
        if (this.isClient()) {
            return (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)AbstractCraftingUnitBlock.FORMED);
        }
        return this.cluster != null;
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10556("core", this.isCoreBlock());
        if (this.isCoreBlock() && this.cluster != null) {
            this.cluster.writeToNBT(data);
        }
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.setCoreBlock(data.method_10577("core"));
        if (this.isCoreBlock()) {
            if (this.cluster != null) {
                this.cluster.readFromNBT(data);
            } else {
                this.setPreviousState(data.method_10553());
            }
        }
    }

    @Override
    public void disconnect(boolean update) {
        if (this.cluster != null) {
            this.cluster.destroy();
            if (update) {
                this.updateMeta(true);
            }
        }
    }

    @Override
    public CraftingCPUCluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @MENetworkEventSubscribe
    public void onPowerStateChange(MENetworkChannelsChanged ev) {
        this.updateMeta(false);
    }

    @MENetworkEventSubscribe
    public void onPowerStateChange(MENetworkPowerStatusChange ev) {
        this.updateMeta(false);
    }

    public boolean isStatus() {
        return false;
    }

    public boolean isStorage() {
        return false;
    }

    public int getStorageBytes() {
        return 0;
    }

    public void breakCluster() {
        this.method_11000();
        if (this.cluster != null) {
            this.cluster.cancel();
            IMEInventory<IAEItemStack> inv = this.cluster.getInventory();
            LinkedList<class_2338> places = new LinkedList<class_2338>();
            Iterator<CraftingBlockEntity> i = this.cluster.getTiles();
            while (i.hasNext()) {
                CraftingBlockEntity h = i.next();
                if (h == this) {
                    places.add(this.field_11867);
                    continue;
                }
                for (class_2350 d : class_2350.values()) {
                    class_2338 p = h.field_11867.method_10093(d);
                    if (!this.field_11863.method_22347(p)) continue;
                    places.add(p);
                }
            }
            Collections.shuffle(places);
            if (places.isEmpty()) {
                throw new IllegalStateException(this.cluster + " does not contain any kind of blocks, which were destroyed.");
            }
            for (IAEItemStack ais : inv.getAvailableItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList())) {
                IAEItemStack g;
                ais = ais.copy();
                ais.setStackSize(ais.getDefinition().method_7914());
                while ((g = inv.extractItems(ais.copy(), Actionable.MODULATE, this.cluster.getActionSource())) != null) {
                    class_2338 pos = (class_2338)places.poll();
                    places.add(pos);
                    Platform.spawnDrops(this.field_11863, pos, Collections.singletonList(g.createItemStack()));
                }
            }
            this.cluster.destroy();
        }
    }

    @Override
    public boolean isPowered() {
        if (this.isClient()) {
            return (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)AbstractCraftingUnitBlock.POWERED);
        }
        return this.getProxy().isActive();
    }

    @Override
    public boolean isActive() {
        if (Platform.isServer()) {
            return this.getProxy().isActive();
        }
        return this.isPowered() && this.isFormed();
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public void setCoreBlock(boolean isCoreBlock) {
        this.isCoreBlock = isCoreBlock;
    }

    public class_2487 getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(class_2487 previousState) {
        this.previousState = previousState;
    }

    @Override
    public Object getRenderAttachmentData() {
        return new CraftingCubeModelData(this.getUp(), this.getForward(), this.getConnections());
    }

    protected EnumSet<class_2350> getConnections() {
        if (this.field_11863 == null) {
            return EnumSet.noneOf(class_2350.class);
        }
        EnumSet<class_2350> connections = EnumSet.noneOf(class_2350.class);
        for (class_2350 facing : class_2350.values()) {
            if (!this.isConnected((class_1922)this.field_11863, this.field_11867, facing)) continue;
            connections.add(facing);
        }
        return connections;
    }

    private boolean isConnected(class_1922 world, class_2338 pos, class_2350 side) {
        class_2338 adjacentPos = pos.method_10093(side);
        return world.method_8320(adjacentPos).method_26204() instanceof AbstractCraftingUnitBlock;
    }
}

