/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEColor;
import appeng.core.Api;
import appeng.tile.crafting.CraftingBlockEntity;
import appeng.tile.crafting.CraftingMonitorModelData;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class CraftingMonitorBlockEntity
extends CraftingBlockEntity
implements IColorableTile {
    @Environment(value=EnvType.CLIENT)
    private Integer dspList;
    @Environment(value=EnvType.CLIENT)
    private boolean updateList;
    private IAEItemStack dspPlay;
    private AEColor paintedColor = AEColor.TRANSPARENT;

    public CraftingMonitorBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    protected boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        boolean hasItem = data.readBoolean();
        this.dspPlay = hasItem ? AEItemStack.fromPacket(data) : null;
        this.setUpdateList(true);
        return oldPaintedColor != this.paintedColor || c;
    }

    @Override
    protected void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        data.writeByte(this.paintedColor.ordinal());
        if (this.dspPlay == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            this.dspPlay.writeToPacket(data);
        }
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        if (data.method_10545("paintedColor")) {
            this.paintedColor = AEColor.values()[data.method_10571("paintedColor")];
        }
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10567("paintedColor", (byte)this.paintedColor.ordinal());
        return data;
    }

    @Override
    public boolean isAccelerator() {
        return false;
    }

    @Override
    public boolean isStatus() {
        return true;
    }

    public void setJob(IAEItemStack is) {
        if (is == null != (this.dspPlay == null)) {
            this.dspPlay = is == null ? null : is.copy();
            this.markForUpdate();
        } else if (is != null && this.dspPlay != null && is.getStackSize() != this.dspPlay.getStackSize()) {
            this.dspPlay = is.copy();
            this.markForUpdate();
        }
    }

    public IAEItemStack getJobProgress() {
        return this.dspPlay;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(class_2350 side, AEColor newPaintedColor, class_1657 who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    public Integer getDisplayList() {
        return this.dspList;
    }

    public void setDisplayList(Integer dspList) {
        this.dspList = dspList;
    }

    public boolean isUpdateList() {
        return this.updateList;
    }

    public void setUpdateList(boolean updateList) {
        this.updateList = updateList;
    }

    @Override
    protected class_1799 getItemFromTile(Object obj) {
        Optional<class_1799> is = Api.instance().definitions().blocks().craftingMonitor().maybeStack(1);
        return is.orElseGet(() -> super.getItemFromTile(obj));
    }

    @Override
    @Nonnull
    public CraftingMonitorModelData getRenderAttachmentData() {
        return new CraftingMonitorModelData(this.getUp(), this.getForward(), this.getConnections(), this.getColor());
    }
}

