/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.definitions.ITileDefinition;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.container.ContainerNull;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.network.TargetPoint;
import appeng.core.sync.packets.AssemblerAnimationPacket;
import appeng.items.misc.EncodedPatternItem;
import appeng.me.GridAccessException;
import appeng.parts.automation.DefinitionUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.crafting.AssemblerAnimationStatus;
import appeng.tile.grid.AENetworkInvBlockEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class MolecularAssemblerBlockEntity
extends AENetworkInvBlockEntity
implements IUpgradeableHost,
IConfigManagerHost,
IGridTickable,
ICraftingMachine,
IPowerChannelState {
    public static final String INVENTORY_MAIN = "molecular_assembler";
    private final class_1715 craftingInv;
    private final AppEngInternalInventory gridInv = new AppEngInternalInventory(this, 10, 1);
    private final AppEngInternalInventory patternInv = new AppEngInternalInventory(this, 1, 1);
    private final FixedItemInv internalInv = new WrapperChainedItemHandler(new FixedItemInv[]{this.gridInv, this.patternInv});
    private final LimitedFixedItemInv gridInvExt;
    private final IConfigManager settings;
    private final UpgradeInventory upgrades;
    private boolean isPowered = false;
    private AEPartLocation pushDirection = AEPartLocation.INTERNAL;
    private class_1799 myPattern = class_1799.field_8037;
    private ICraftingPatternDetails myPlan = null;
    private double progress = 0.0;
    private boolean isAwake = false;
    private boolean forcePlan = false;
    private boolean reboot = true;
    @Environment(value=EnvType.CLIENT)
    private AssemblerAnimationStatus animationStatus;

    public MolecularAssemblerBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        ITileDefinition assembler = Api.instance().definitions().blocks().molecularAssembler();
        this.settings = new ConfigManager(this);
        this.settings.registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getProxy().setIdlePowerUsage(0.0);
        this.upgrades = new DefinitionUpgradeInventory(assembler, this, this.getUpgradeSlots());
        this.craftingInv = new class_1715((class_1703)new ContainerNull(), 3, 3);
        this.gridInvExt = this.gridInv.createLimitedFixedInv();
        int i = 0;
        while (i < 9) {
            int slot = i++;
            this.gridInvExt.getRule(slot).disallowExtraction().limitInsertionCount(1).filterInserts(stack -> this.isValidIngredientForSlot(slot, stack));
        }
        this.gridInvExt.getRule(9).disallowInsertion();
    }

    private boolean isValidIngredientForSlot(int slot, class_1799 stack) {
        return this.myPlan != null && !ItemHandlerUtil.isEmpty((FixedItemInv)this.patternInv) && this.myPlan.isValidItemForSlot(slot, stack, this.method_10997());
    }

    private int getUpgradeSlots() {
        return 5;
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, class_1715 table, class_2350 where) {
        if (this.myPattern.method_7960()) {
            boolean isEmpty;
            boolean bl = isEmpty = ItemHandlerUtil.isEmpty((FixedItemInv)this.gridInv) && ItemHandlerUtil.isEmpty((FixedItemInv)this.patternInv);
            if (isEmpty && patternDetails.isCraftable()) {
                this.forcePlan = true;
                this.myPlan = patternDetails;
                this.pushDirection = AEPartLocation.fromFacing(where);
                for (int x = 0; x < table.method_5439(); ++x) {
                    this.gridInv.setInvStack(x, table.method_5438(x), Simulation.ACTION);
                }
                this.updateSleepiness();
                this.saveChanges();
                return true;
            }
        }
        return false;
    }

    private void updateSleepiness() {
        boolean wasEnabled = this.isAwake;
        boolean bl = this.isAwake = this.myPlan != null && this.hasMats() || this.canPush();
        if (wasEnabled != this.isAwake) {
            try {
                if (this.isAwake) {
                    this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
                } else {
                    this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private boolean canPush() {
        return !this.gridInv.getInvStack(9).method_7960();
    }

    private boolean hasMats() {
        if (this.myPlan == null) {
            return false;
        }
        for (int x = 0; x < this.craftingInv.method_5439(); ++x) {
            this.craftingInv.method_5447(x, this.gridInv.getInvStack(x));
        }
        return !this.myPlan.getOutput(this.craftingInv, this.method_10997()).method_7960();
    }

    @Override
    public boolean acceptsPlans() {
        return ItemHandlerUtil.isEmpty((FixedItemInv)this.patternInv);
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    protected boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    @Override
    protected void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        class_1799 pattern;
        super.method_11007(data);
        if (this.forcePlan && this.myPlan != null && !(pattern = this.myPlan.getPattern()).method_7960()) {
            class_2487 compound = new class_2487();
            pattern.method_7953(compound);
            data.method_10566("myPlan", (class_2520)compound);
            data.method_10569("pushDirection", this.pushDirection.ordinal());
        }
        this.upgrades.writeToNBT(data, "upgrades");
        this.settings.writeToNBT(data);
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        class_1799 myPat;
        super.method_11014(state, data);
        if (data.method_10545("myPlan") && !(myPat = class_1799.method_7915((class_2487)data.method_10562("myPlan"))).method_7960() && myPat.method_7909() instanceof EncodedPatternItem) {
            class_1937 w = this.method_10997();
            ICraftingPatternDetails ph = Api.instance().crafting().decodePattern(myPat, w);
            if (ph != null && ph.isCraftable()) {
                this.forcePlan = true;
                this.myPlan = ph;
                this.pushDirection = AEPartLocation.fromOrdinal(data.method_10550("pushDirection"));
            }
        }
        this.upgrades.readFromNBT(data, "upgrades");
        this.settings.readFromNBT(data);
        this.recalculatePlan();
    }

    private void recalculatePlan() {
        this.reboot = true;
        if (this.forcePlan) {
            return;
        }
        class_1799 is = this.patternInv.getInvStack(0);
        if (!is.method_7960() && is.method_7909() instanceof EncodedPatternItem) {
            if (!class_1799.method_7987((class_1799)is, (class_1799)this.myPattern)) {
                class_1937 w = this.method_10997();
                ICraftingPatternDetails ph = Api.instance().crafting().decodePattern(is, w);
                if (ph != null && ph.isCraftable()) {
                    this.progress = 0.0;
                    this.myPattern = is;
                    this.myPlan = ph;
                }
            }
        } else {
            this.progress = 0.0;
            this.forcePlan = false;
            this.myPlan = null;
            this.myPattern = class_1799.field_8037;
            this.pushDirection = AEPartLocation.INTERNAL;
        }
        this.updateSleepiness();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        if (name.equals(INVENTORY_MAIN)) {
            return this.internalInv;
        }
        return null;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.internalInv;
    }

    @Override
    @NotNull
    public FixedItemInv getExternalInventory() {
        return this.gridInvExt;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
        if (inv == this.gridInv || inv == this.patternInv) {
            this.recalculatePlan();
        }
    }

    public int getCraftingProgress() {
        return (int)this.progress;
    }

    @Override
    public void getDrops(class_1937 w, class_2338 pos, List<class_1799> drops) {
        super.getDrops(w, pos, drops);
        for (int h = 0; h < this.upgrades.getSlotCount(); ++h) {
            class_1799 is = this.upgrades.getInvStack(h);
            if (is.method_7960()) continue;
            drops.add(is);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        this.recalculatePlan();
        this.updateSleepiness();
        return new TickingRequest(1, 1, !this.isAwake, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.gridInv.getInvStack(9).method_7960()) {
            this.pushOut(this.gridInv.getInvStack(9));
            if (this.gridInv.getInvStack(9).method_7960()) {
                this.saveChanges();
            }
            this.ejectHeldItems();
            this.updateSleepiness();
            this.progress = 0.0;
            return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
        }
        if (this.myPlan == null) {
            this.updateSleepiness();
            return TickRateModulation.SLEEP;
        }
        if (this.reboot) {
            ticksSinceLastCall = 1;
        }
        if (!this.isAwake) {
            return TickRateModulation.SLEEP;
        }
        this.reboot = false;
        int speed = 10;
        switch (this.upgrades.getInstalledUpgrades(Upgrades.SPEED)) {
            case 0: {
                speed = 10;
                this.progress += (double)this.userPower(ticksSinceLastCall, 10, 1.0);
                break;
            }
            case 1: {
                speed = 13;
                this.progress += (double)this.userPower(ticksSinceLastCall, 13, 1.3);
                break;
            }
            case 2: {
                speed = 17;
                this.progress += (double)this.userPower(ticksSinceLastCall, 17, 1.7);
                break;
            }
            case 3: {
                speed = 20;
                this.progress += (double)this.userPower(ticksSinceLastCall, 20, 2.0);
                break;
            }
            case 4: {
                speed = 25;
                this.progress += (double)this.userPower(ticksSinceLastCall, 25, 2.5);
                break;
            }
            case 5: {
                speed = 50;
                this.progress += (double)this.userPower(ticksSinceLastCall, 50, 5.0);
            }
        }
        if (this.progress >= 100.0) {
            for (int x = 0; x < this.craftingInv.method_5439(); ++x) {
                this.craftingInv.method_5447(x, this.gridInv.getInvStack(x));
            }
            this.progress = 0.0;
            class_1799 output = this.myPlan.getOutput(this.craftingInv, this.method_10997());
            if (!output.method_7960()) {
                this.pushOut(output.method_7972());
                for (int x = 0; x < this.craftingInv.method_5439(); ++x) {
                    this.gridInv.setInvStack(x, Platform.getRecipeRemainder(this.craftingInv.method_5438(x)), Simulation.ACTION);
                }
                if (ItemHandlerUtil.isEmpty((FixedItemInv)this.patternInv)) {
                    this.forcePlan = false;
                    this.myPlan = null;
                    this.pushDirection = AEPartLocation.INTERNAL;
                }
                this.ejectHeldItems();
                AEItemStack item = AEItemStack.fromItemStack(output);
                if (item != null) {
                    TargetPoint where = new TargetPoint(this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260(), 32.0, this.field_11863);
                    NetworkHandler.instance().sendToAllAround(new AssemblerAnimationPacket(this.field_11867, (byte)speed, item), where);
                }
                this.saveChanges();
                this.updateSleepiness();
                return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
            }
        }
        return TickRateModulation.FASTER;
    }

    private void ejectHeldItems() {
        if (this.gridInv.getInvStack(9).method_7960()) {
            for (int x = 0; x < 9; ++x) {
                class_1799 is = this.gridInv.getInvStack(x);
                if (is.method_7960() || this.myPlan != null && this.myPlan.isValidItemForSlot(x, is, this.field_11863)) continue;
                this.gridInv.setInvStack(9, is, Simulation.ACTION);
                this.gridInv.setInvStack(x, class_1799.field_8037, Simulation.ACTION);
                this.saveChanges();
                return;
            }
        }
    }

    private int userPower(int ticksPassed, int bonusValue, double acceleratorTax) {
        try {
            return (int)(this.getProxy().getEnergy().extractAEPower((double)(ticksPassed * bonusValue) * acceleratorTax, Actionable.MODULATE, PowerMultiplier.CONFIG) / acceleratorTax);
        }
        catch (GridAccessException e) {
            return 0;
        }
    }

    private void pushOut(class_1799 output) {
        if (this.pushDirection == AEPartLocation.INTERNAL) {
            for (class_2350 d : class_2350.values()) {
                output = this.pushTo(output, d);
            }
        } else {
            output = this.pushTo(output, this.pushDirection.getFacing());
        }
        if (output.method_7960() && this.forcePlan) {
            this.forcePlan = false;
            this.recalculatePlan();
        }
        this.gridInv.setInvStack(9, output, Simulation.ACTION);
    }

    private class_1799 pushTo(class_1799 output, class_2350 d) {
        int newSize;
        if (output.method_7960()) {
            return output;
        }
        class_2586 te = this.method_10997().method_8321(this.field_11867.method_10093(d));
        if (te == null) {
            return output;
        }
        InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(te, d.method_10153());
        if (adaptor == null) {
            return output;
        }
        int size = output.method_7947();
        int n = newSize = (output = adaptor.addItems(output)).method_7960() ? 0 : output.method_7947();
        if (size != newSize) {
            this.saveChanges();
        }
        return output;
    }

    @MENetworkEventSubscribe
    public void onPowerEvent(MENetworkPowerStatusChange p) {
        this.updatePowerState();
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    @Override
    public boolean isPowered() {
        return this.isPowered;
    }

    @Override
    public boolean isActive() {
        return this.isPowered;
    }

    @Environment(value=EnvType.CLIENT)
    public void setAnimationStatus(@Nullable AssemblerAnimationStatus status) {
        this.animationStatus = status;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public AssemblerAnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }
}

