/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.client.render.effects.ParticleTypes;
import appeng.core.AppEng;
import appeng.mixins.RenderPhaseMixin;
import appeng.tile.crafting.AssemblerAnimationStatus;
import appeng.tile.crafting.MolecularAssemblerBlockEntity;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2394;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_809;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class MolecularAssemblerRenderer
extends class_827<MolecularAssemblerBlockEntity> {
    public static final class_1091 LIGHTS_MODEL = new class_1091(AppEng.makeId("block/molecular_assembler_lights"), "");
    private static final class_1921 MC_161917_RENDERTYPE_FIX = MolecularAssemblerRenderer.createRenderType();
    private final Random particleRandom = new Random();

    public MolecularAssemblerRenderer(class_824 rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(MolecularAssemblerBlockEntity molecularAssembler, float partialTicks, class_4587 ms, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        AssemblerAnimationStatus status = molecularAssembler.getAnimationStatus();
        if (status != null) {
            if (!class_310.method_1551().method_1493()) {
                if (status.isExpired()) {
                    molecularAssembler.setAnimationStatus(null);
                }
                status.setAccumulatedTicks(status.getAccumulatedTicks() + partialTicks);
                status.setTicksUntilParticles(status.getTicksUntilParticles() - partialTicks);
            }
            this.renderStatus(molecularAssembler, ms, bufferIn, combinedLightIn, status);
        }
        if (molecularAssembler.isPowered()) {
            this.renderPowerLight(ms, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }

    private void renderPowerLight(class_4587 ms, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        class_310 minecraft = class_310.method_1551();
        class_1087 lightsModel = minecraft.method_1554().method_4742(LIGHTS_MODEL);
        class_4588 buffer = bufferIn.getBuffer(MC_161917_RENDERTYPE_FIX);
        minecraft.method_1541().method_3350().method_3367(ms.method_23760(), buffer, null, lightsModel, 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn);
    }

    private void renderStatus(MolecularAssemblerBlockEntity molecularAssembler, class_4587 ms, class_4597 bufferIn, int combinedLightIn, AssemblerAnimationStatus status) {
        double centerX = (float)molecularAssembler.method_11016().method_10263() + 0.5f;
        double centerY = (float)molecularAssembler.method_11016().method_10264() + 0.5f;
        double centerZ = (float)molecularAssembler.method_11016().method_10260() + 0.5f;
        class_310 minecraft = class_310.method_1551();
        if (status.getTicksUntilParticles() <= 0.0f) {
            status.setTicksUntilParticles(4.0f);
            if (AppEng.instance().shouldAddParticles(this.particleRandom)) {
                for (int x = 0; x < (int)Math.ceil((double)status.getSpeed() / 5.0); ++x) {
                    minecraft.field_1713.method_3056((class_2394)ParticleTypes.CRAFTING, centerX, centerY, centerZ, 0.0, 0.0, 0.0);
                }
            }
        }
        class_1799 is = status.getIs();
        class_918 itemRenderer = minecraft.method_1480();
        ms.method_22903();
        ms.method_22904(0.5, 0.5, 0.5);
        if (!(is.method_7909() instanceof class_1747)) {
            ms.method_22904(0.0, (double)-0.3f, 0.0);
        } else {
            ms.method_22904(0.0, (double)-0.2f, 0.0);
        }
        itemRenderer.method_23178(is, class_809.class_811.field_4318, combinedLightIn, class_4608.field_21444, ms, bufferIn);
        ms.method_22909();
    }

    private static class_1921 createRenderType() {
        class_4668.class_4683 mipmapBlockAtlasTexture = new class_4668.class_4683(class_1059.field_5275, false, true);
        class_4668.class_4676 disableLightmap = new class_4668.class_4676(false);
        class_1921.class_4688 glState = class_1921.class_4688.method_23598().method_23613(mipmapBlockAtlasTexture).method_23615(RenderPhaseMixin.getTranslucentTransparency()).method_23602(new class_4668.class_4669(0.05f)).method_23608(disableLightmap).method_23617(true);
        return class_1921.method_24048((String)"ae2_translucent_alphatest", (class_293)class_290.field_20888, (int)7, (int)256, (class_1921.class_4688)glState);
    }
}

