/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.grindstone;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import appeng.api.implementations.tiles.ICrankable;
import appeng.recipes.handlers.GrinderOptionalResult;
import appeng.recipes.handlers.GrinderRecipe;
import appeng.recipes.handlers.GrinderRecipes;
import appeng.tile.AEBaseInvBlockEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorFixedInv;
import appeng.util.inv.InvOperation;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class GrinderBlockEntity
extends AEBaseInvBlockEntity
implements ICrankable {
    private static final int SLOT_PROCESSING = 6;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 7);
    private final LimitedFixedItemInv invExt = this.inv.createLimitedFixedInv();
    private int points;

    public GrinderBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.invExt.getAllRule().disallowExtraction().disallowInsertion();
        this.invExt.getSubRule(3, 6).allowExtraction();
        this.invExt.getSubRule(0, 3).filterInserts(stack -> GrinderRecipes.isValidIngredient(this.field_11863, stack)).allowInsertion();
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        super.setOrientation(inForward, inUp);
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        state.method_26204().method_9612(state, this.field_11863, this.field_11867, state.method_26204(), this.field_11867, false);
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.inv;
    }

    @Override
    protected FixedItemInv getItemHandlerForSide(class_2350 side) {
        return this.invExt;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
    }

    @Override
    public boolean canTurn() {
        if (this.isClient()) {
            return false;
        }
        if (this.inv.getInvStack(6).method_7960()) {
            for (int x = 0; x < 3; ++x) {
                GrinderRecipe r;
                class_1799 item = this.inv.getInvStack(x);
                if (item.method_7960() || (r = GrinderRecipes.findForInput(this.field_11863, item)) == null) continue;
                class_1799 ais = item.method_7972();
                ais.method_7939(r.getIngredientCount());
                item.method_7934(r.getIngredientCount());
                if (item.method_7947() <= 0) {
                    item = class_1799.field_8037;
                }
                this.inv.setInvStack(x, item, Simulation.ACTION);
                this.inv.setInvStack(6, ais, Simulation.ACTION);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void applyTurn() {
        if (this.isClient()) {
            return;
        }
        ++this.points;
        class_1799 processing = this.inv.getInvStack(6);
        GrinderRecipe r = GrinderRecipes.findForInput(this.field_11863, processing);
        if (r != null) {
            if (r.getTurns() > this.points) {
                return;
            }
            this.points = 0;
            AdaptorFixedInv sia = new AdaptorFixedInv(this.inv.getSubInv(3, 6));
            this.addItem(sia, r.method_8110());
            for (GrinderOptionalResult optionalResult : r.getOptionalResults()) {
                float chance = (float)(Platform.getRandomInt() % 2000) / 2000.0f;
                if (!(chance <= optionalResult.getChance())) continue;
                this.addItem(sia, optionalResult.getResult());
            }
            this.inv.setInvStack(6, class_1799.field_8037, Simulation.ACTION);
        }
    }

    private void addItem(InventoryAdaptor sia, class_1799 output) {
        if (output.method_7960()) {
            return;
        }
        class_1799 notAdded = sia.addItems(output);
        if (!notAdded.method_7960()) {
            ArrayList<class_1799> out = new ArrayList<class_1799>();
            out.add(notAdded);
            Platform.spawnDrops(this.field_11863, this.field_11867.method_10093(this.getForward()), out);
        }
    }

    @Override
    public boolean canCrankAttach(class_2350 directionToCrank) {
        return this.getUp() == directionToCrank;
    }
}

